/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.misc.http.HttpError;
import es.gob.afirma.core.misc.http.SslSecurityManager;
import es.gob.afirma.core.misc.http.URLName;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import javax.security.auth.callback.PasswordCallback;

public class UrlHttpManagerImpl
implements UrlHttpManager {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String JAVA_PARAM_DISABLE_SSL_CHECKS = "disableSslChecks";
    public static final String JAVA_PARAM_SECURE_DOMAINS_LIST = "secureDomainsList";
    public static final int DEFAULT_TIMEOUT = -1;
    private static final String HTTPS = "https";
    private static final String URN_SEPARATOR = ":";
    private static final String PROT_SEPARATOR = "://";
    private static final String ACCEPT = "Accept";
    private static KeyStore sslKeyStore = null;
    private static PasswordCallback sslKeyStorePasswordCallback = null;

    protected UrlHttpManagerImpl() {
    }

    public static void setSslKeyStore(KeyStore keyStore) {
        sslKeyStore = keyStore;
    }

    public static void setSslKeyStorePasswordCallback(PasswordCallback passwordCallback) {
        sslKeyStorePasswordCallback = passwordCallback;
    }

    @Override
    public byte[] readUrl(String string, UrlHttpMethod urlHttpMethod) throws IOException {
        return this.readUrl(string, -1, null, null, urlHttpMethod);
    }

    private static boolean isLocal(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("La URL no puede ser nula");
        }
        try {
            return InetAddress.getByName(uRL.getHost()).isLoopbackAddress();
        }
        catch (Exception exception) {
            LOGGER.warning("Error comprobando si una URL es el bucle local: " + exception);
            return false;
        }
    }

    @Override
    public byte[] readUrl(String string, int n, String string2, String string3, UrlHttpMethod urlHttpMethod) throws IOException {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.setProperty("Content-Type", string2);
        }
        if (string3 != null) {
            properties.setProperty(ACCEPT, string3);
        }
        return this.readUrl(string, n, urlHttpMethod, properties);
    }

    @Override
    public byte[] readUrl(String string, int n, UrlHttpMethod urlHttpMethod, Properties properties) throws IOException {
        byte[] byArray;
        Object object;
        String string2;
        String string3;
        String string4;
        if (string == null) {
            throw new IllegalArgumentException("La URL a leer no puede ser nula");
        }
        URLName uRLName = new URLName(string);
        if (uRLName.getUsername() != null || uRLName.getPassword() != null) {
            string4 = uRLName.getUsername() != null && uRLName.getPassword() != null ? uRLName.getUsername() + URN_SEPARATOR + uRLName.getPassword() : (uRLName.getUsername() != null ? uRLName.getUsername() : uRLName.getPassword());
            string3 = Base64.encode(string4.getBytes());
            string2 = uRLName.getProtocol() + PROT_SEPARATOR + uRLName.getHost() + (uRLName.getPort() != -1 ? URN_SEPARATOR + Integer.toString(uRLName.getPort()) : "") + "/" + (uRLName.getFile() != null ? uRLName.getFile() : "");
        } else {
            string2 = string;
            string3 = null;
        }
        string4 = null;
        String string5 = null;
        if (UrlHttpMethod.POST.equals((Object)urlHttpMethod) || UrlHttpMethod.PUT.equals((Object)urlHttpMethod)) {
            object = new StringTokenizer(string2, "?");
            string5 = ((StringTokenizer)object).nextToken();
            if (string2.contains("?")) {
                string4 = ((StringTokenizer)object).nextToken();
            }
        }
        object = new URL(string5 != null ? string5 : string2);
        boolean bl = Boolean.parseBoolean(System.getProperty(JAVA_PARAM_DISABLE_SSL_CHECKS, "false"));
        boolean bl2 = UrlHttpManagerImpl.checkIsSecureDomain((URL)object);
        if ((bl || bl2) && ((URL)object).getProtocol().equals(HTTPS)) {
            try {
                UrlHttpManagerImpl.disableSslChecks();
                LOGGER.info("Deshabilitada la comprobacion SSL para el acceso al dominio: " + ((URL)object).getHost());
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido ajustar la confianza SSL, es posible que no se pueda completar la conexion: " + exception);
            }
        }
        try {
            HttpURLConnection httpURLConnection = Platform.OS.ANDROID.equals((Object)Platform.getOS()) || UrlHttpManagerImpl.isLocal((URL)object) ? (HttpURLConnection)((URL)object).openConnection(Proxy.NO_PROXY) : (HttpURLConnection)((URL)object).openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestMethod(urlHttpMethod.toString());
            Properties properties2 = new Properties();
            if (properties != null) {
                properties2.putAll((Map<?, ?>)properties);
            }
            if (string3 != null && !properties2.containsKey("Authorization")) {
                httpURLConnection.addRequestProperty("Authorization", "Basic " + string3);
            }
            if (!properties2.containsKey(ACCEPT)) {
                httpURLConnection.addRequestProperty(ACCEPT, "*/*");
            }
            if (!properties2.containsKey("Connection")) {
                httpURLConnection.addRequestProperty("Connection", "keep-alive");
            }
            if (!properties2.containsKey("Host")) {
                httpURLConnection.addRequestProperty("Host", ((URL)object).getHost());
            }
            if (!properties2.containsKey("Origin")) {
                httpURLConnection.addRequestProperty("Origin", ((URL)object).getProtocol() + PROT_SEPARATOR + ((URL)object).getHost());
            }
            for (Map.Entry<Object, Object> object22 : properties2.entrySet()) {
                httpURLConnection.addRequestProperty((String)object22.getKey(), (String)object22.getValue());
            }
            if (string4 != null) {
                httpURLConnection.setRequestProperty("Content-Length", String.valueOf(string4.getBytes(StandardCharsets.UTF_8).length));
                httpURLConnection.setDoOutput(true);
                Throwable throwable = null;
                try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                    outputStream.write(string4.getBytes(StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            if (n != -1) {
                httpURLConnection.setConnectTimeout(n);
            }
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            String string6 = Integer.toString(n2);
            if (string6.startsWith("4") || string6.startsWith("5")) {
                if (((URL)object).getProtocol().equals(HTTPS)) {
                    UrlHttpManagerImpl.enableSslChecks();
                }
                throw new HttpError(n2, httpURLConnection.getResponseMessage(), AOUtil.getDataFromInputStream(httpURLConnection.getErrorStream()), string2);
            }
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                byArray = AOUtil.getDataFromInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            if (bl && ((URL)object).getProtocol().equals(HTTPS)) {
                UrlHttpManagerImpl.enableSslChecks();
            }
            throw iOException;
        }
        if (bl && ((URL)object).getProtocol().equals(HTTPS)) {
            UrlHttpManagerImpl.enableSslChecks();
        }
        return byArray;
    }

    public static void enableSslChecks() {
        SslSecurityManager.enableSslChecks();
    }

    public static void setTrustManager(TrustManager[] trustManagerArray, HostnameVerifier hostnameVerifier) throws KeyManagementException, NoSuchAlgorithmException {
        SslSecurityManager.setTrustManagerAndKeyManager(trustManagerArray, hostnameVerifier, sslKeyStore, sslKeyStorePasswordCallback);
    }

    public static void disableSslChecks() throws KeyManagementException, NoSuchAlgorithmException {
        SslSecurityManager.disableSslChecks();
    }

    private static boolean checkIsSecureDomain(URL uRL) {
        String string = System.getProperty(JAVA_PARAM_SECURE_DOMAINS_LIST);
        if (string != null && !string.isEmpty()) {
            String[] stringArray;
            String string2 = uRL.getHost();
            for (String string3 : stringArray = string.split(",")) {
                String string4 = string3.replace("*", "");
                if (!(string3.startsWith("*") && string3.endsWith("*") ? string2.contains(string4) : (string3.startsWith("*") ? string2.endsWith(string4) : (string3.endsWith("*") ? string2.startsWith(string4) : string2.equals(string4))))) continue;
                return true;
            }
        }
        return false;
    }

    static {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }
}

