/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import es.gob.afirma.core.misc.LoggerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.PasswordCallback;

public final class SslSecurityManager {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final TrustManager[] DUMMY_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }};
    private static final String KEYSTORE = "javax.net.ssl.keyStore";
    private static final String KEYSTORE_PASS = "javax.net.ssl.keyStorePassword";
    private static final String KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String KEYSTORE_DEFAULT_TYPE = "JKS";
    private static final String SSL_CONTEXT = "SSL";
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    private static final SSLSocketFactory DEFAULT_SSL_SOCKET_FACTORY = HttpsURLConnection.getDefaultSSLSocketFactory();

    private SslSecurityManager() {
    }

    public static void disableSslChecks() throws KeyManagementException, NoSuchAlgorithmException {
        SslSecurityManager.setTrustManagerAndKeyManager(DUMMY_TRUST_MANAGER, new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        }, null, null);
    }

    public static void enableSslChecks() {
        HttpsURLConnection.setDefaultSSLSocketFactory(DEFAULT_SSL_SOCKET_FACTORY);
        HttpsURLConnection.setDefaultHostnameVerifier(DEFAULT_HOSTNAME_VERIFIER);
        LOGGER.fine("Habilitadas comprobaciones SSL");
    }

    public static void setTrustManagerAndKeyManager(TrustManager[] trustManagerArray, HostnameVerifier hostnameVerifier, KeyStore keyStore, PasswordCallback passwordCallback) throws KeyManagementException, NoSuchAlgorithmException {
        KeyManager[] keyManagerArray;
        if (trustManagerArray == null || trustManagerArray.length < 1) {
            throw new IllegalArgumentException("Es necesario proporcionar al menos un TrustManager");
        }
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("Es necesario proporcionar un HostnameVerifier");
        }
        SSLContext sSLContext = SSLContext.getInstance(SSL_CONTEXT);
        try {
            keyManagerArray = SslSecurityManager.getKeyManager(keyStore, passwordCallback);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "No ha sido posible obtener el KeyManager con el KeyStore '" + System.getProperty(KEYSTORE) + "', se usara null: " + exception, exception);
            keyManagerArray = null;
        }
        sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    private static KeyManager[] getKeyManager(KeyStore keyStore, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        Object object;
        char[] cArray;
        KeyStore keyStore2;
        if (keyStore != null) {
            LOGGER.info("Se usara el almacen de claves SSL proporcionado de forma directa: " + keyStore.getType());
            keyStore2 = keyStore;
            cArray = passwordCallback != null ? passwordCallback.getPassword() : new char[]{};
        } else {
            object = System.getProperty(KEYSTORE);
            String string = System.getProperty(KEYSTORE_PASS);
            String string2 = System.getProperty(KEYSTORE_TYPE);
            if (object == null || ((String)object).isEmpty()) {
                return null;
            }
            File file = new File((String)object);
            if (!file.isFile() || !file.canRead()) {
                LOGGER.warning("El KeyStore SSL no existe o no es legible: " + LoggerUtil.getCleanUserHomePath(file.getAbsolutePath()));
                return null;
            }
            keyStore2 = KeyStore.getInstance(string2 != null && !string2.isEmpty() ? string2 : KEYSTORE_DEFAULT_TYPE);
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                keyStore2.load(fileInputStream, string != null ? string.toCharArray() : null);
            }
            cArray = string != null ? string.toCharArray() : new char[]{};
        }
        object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ((KeyManagerFactory)object).init(keyStore2, cArray);
        return ((KeyManagerFactory)object).getKeyManagers();
    }
}

