/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.SecureXmlBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class OfficeAnalizer {
    private static final String ZIP_MIMETYPE = "application/zip";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final Set<String> OOXML_MIMETYPES = new HashSet<String>(17);
    private static final Set<String> ODF_MIMETYPES = new HashSet<String>(15);
    private static final Map<String, String> FILE_EXTENSIONS = new HashMap<String, String>();
    private static final Map<String, String> FILE_DESCRIPTIONS = new HashMap<String, String>();
    private static final long THRESHOLD_FILE_SIZE = 1000000000L;

    private OfficeAnalizer() {
    }

    static String getMimeType(byte[] byArray) throws IOException {
        String string = null;
        if ((long)byArray.length >= 1000000000L) {
            throw new IOException("El archivo tiene un tamano superior al permitido.");
        }
        File file = AOFileUtils.createTempFile(byArray);
        try (ZipFile zipFile = new ZipFile(file);){
            InputStream inputStream;
            if (OfficeAnalizer.isODFFile(zipFile)) {
                inputStream = zipFile.getInputStream(zipFile.getEntry("mimetype"));
                Throwable throwable = null;
                try {
                    string = OfficeAnalizer.getODFMimeType(inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            } else if (OfficeAnalizer.isOOXMLFile(zipFile)) {
                inputStream = zipFile.getInputStream(zipFile.getEntry("[Content_Types].xml"));
                Throwable throwable = null;
                try {
                    string = OfficeAnalizer.getOOXMLMimeType(inputStream);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            } else {
                string = OfficeAnalizer.getMimeTypeOffice97(byArray);
            }
            if (string == null) {
                string = ZIP_MIMETYPE;
            }
        }
        catch (ZipException zipException) {
            // empty catch block
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException iOException) {
            LOGGER.warning("No se ha podido eliminar el fichero temporal:  " + iOException);
        }
        if (string == null) {
            string = OfficeAnalizer.getMimeTypeOffice97(byArray);
        }
        if (string == null) {
            string = "application/octect-stream";
        }
        return string;
    }

    private static String getMimeTypeOffice97(byte[] byArray) {
        String string = new String(byArray);
        if (string.contains("Microsoft Excel")) {
            return "application/vnd.ms-excel";
        }
        if (string.contains("Microsoft Office Word")) {
            return "application/msword";
        }
        if (string.contains("Microsoft Office PowerPoint")) {
            return "application/vnd.ms-powerpoint";
        }
        if (string.contains("Microsoft Project")) {
            return "application/vnd.ms-project";
        }
        if (string.contains("Microsoft Visio")) {
            return "application/vnd.visio";
        }
        return null;
    }

    static String getExtension(byte[] byArray) throws IOException {
        String string = OfficeAnalizer.getMimeType(byArray);
        return FILE_EXTENSIONS.get(string);
    }

    static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        return FILE_EXTENSIONS.get(string);
    }

    static String getDescription(byte[] byArray) throws IOException {
        String string = OfficeAnalizer.getMimeType(byArray);
        return FILE_DESCRIPTIONS.get(string);
    }

    static String getDescription(String string) {
        if (string == null) {
            return null;
        }
        return FILE_DESCRIPTIONS.get(string);
    }

    public static boolean isOOXMLDocument(byte[] byArray) {
        boolean bl;
        File file = null;
        try {
            if ((long)byArray.length >= 1000000000L) {
                throw new IOException("El archivo tiene un tamano superior al permitido.");
            }
            file = AOFileUtils.createTempFile(byArray);
            try (ZipFile zipFile = new ZipFile(file);){
                bl = OfficeAnalizer.isOOXMLFile(zipFile);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (file != null) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                LOGGER.warning("No se ha podido eliminar el fichero temporal:  " + iOException);
            }
        }
        return bl;
    }

    private static boolean isOOXMLFile(ZipFile zipFile) throws IOException {
        return zipFile.getEntry("[Content_Types].xml") != null && zipFile.getEntry("_rels/.rels") != null && zipFile.getEntry("docProps/app.xml") != null && zipFile.getEntry("docProps/core.xml") != null;
    }

    public static String getOOXMLMimeType(InputStream inputStream) {
        Document document;
        try {
            document = SecureXmlBuilder.getSecureDocumentBuilder().parse(inputStream);
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido analizar el XML de ContentTypes de OOXML: " + exception);
            return null;
        }
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equalsIgnoreCase("Types")) {
            return null;
        }
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!node.getNodeName().equalsIgnoreCase("Override")) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = null;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                if (!namedNodeMap.item(j).getNodeName().equalsIgnoreCase("ContentType")) continue;
                node2 = namedNodeMap.item(j);
                break;
            }
            if (node2 == null) continue;
            String string = node2.getNodeValue();
            if (string.indexOf(46) != -1) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            if (!OOXML_MIMETYPES.contains(string)) continue;
            return string;
        }
        return null;
    }

    public static boolean isODFDocument(byte[] byArray) throws IOException {
        boolean bl;
        File file = null;
        try {
            if ((long)byArray.length >= 1000000000L) {
                throw new IOException("El archivo tiene un tamano superior al permitido.");
            }
            file = AOFileUtils.createTempFile(byArray);
            try (ZipFile zipFile = new ZipFile(file);){
                bl = OfficeAnalizer.isODFFile(zipFile);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (file != null) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                LOGGER.warning("No se ha podido eliminar el fichero temporal:  " + iOException);
            }
        }
        return bl;
    }

    private static boolean isODFFile(ZipFile zipFile) throws IOException {
        if (zipFile.getEntry("mimetype") == null) {
            return false;
        }
        if (zipFile.getEntry("content.xml") == null) {
            return false;
        }
        if (zipFile.getEntry("meta.xml") == null) {
            return false;
        }
        if (zipFile.getEntry("settings.xml") == null) {
            return false;
        }
        if (zipFile.getEntry("styles.xml") == null) {
            return false;
        }
        return zipFile.getEntry("META-INF/manifest.xml") != null;
    }

    private static String getODFMimeType(InputStream inputStream) {
        String string;
        try {
            string = new String(AOUtil.getDataFromInputStream(inputStream));
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido obtener el tipo de contenido ODF del flujo de entrada: " + exception);
            return null;
        }
        if (ODF_MIMETYPES.contains(string)) {
            return string;
        }
        return null;
    }

    static {
        OOXML_MIMETYPES.add("application/vnd.ms-word.document.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        OOXML_MIMETYPES.add("application/vnd.ms-word.template.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.template.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.presentationml.template");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.addin.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.slideshow.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.presentation.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.addin.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.sheet.binary.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.sheet.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.template.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text-web");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text-master");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.graphics");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.graphics-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.presentation");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.presentation-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.spreadsheet");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.spreadsheet-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.chart");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.formula");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.database");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.image");
        ODF_MIMETYPES.add("application/vnd.openofficeorg.extension");
        FILE_EXTENSIONS.put(ZIP_MIMETYPE, "zip");
        FILE_EXTENSIONS.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        FILE_EXTENSIONS.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx");
        FILE_EXTENSIONS.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.text", "odt");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.presentation", "odp");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.spreadsheet", "ods");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.graphics", "odg");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.chart", "odc");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.formula", "odf");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.database", "odb");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.image", "odi");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.text-master", "odm");
        FILE_EXTENSIONS.put("application/msword", "doc");
        FILE_EXTENSIONS.put("application/vnd.ms-powerpoint", "ppt");
        FILE_EXTENSIONS.put("application/vnd.ms-excel", "xls");
        FILE_EXTENSIONS.put("application/vnd.ms-project", "mpp");
        FILE_DESCRIPTIONS.put(ZIP_MIMETYPE, "Archivo zip");
        FILE_DESCRIPTIONS.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Documento de texto");
        FILE_DESCRIPTIONS.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", "Presentaci\u00f3n");
        FILE_DESCRIPTIONS.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Hoja de c\u00e1lculo");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.text", "Documento de texto");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.presentation", "Presentaci\u00f3n");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.spreadsheet", "Hoja de c\u00e1lculo");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.graphics", "Gr\u00e1fico");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.chart", "Diagrama");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.formula", "F\u00f3rmula");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.database", "Base de datos");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.image", "Imagen");
        FILE_DESCRIPTIONS.put("application/vnd.oasis.opendocument.text-master", "Plantilla de documento");
        FILE_DESCRIPTIONS.put("application/msword", "Documento de texto");
        FILE_DESCRIPTIONS.put("application/vnd.ms-powerpoint", "Presentaci\u00f3n");
        FILE_DESCRIPTIONS.put("application/vnd.ms-excel", "Hoja de c\u00e1lculo");
        FILE_DESCRIPTIONS.put("application/vnd.ms-project", "Planificaci&oacute;n de proyecto");
    }
}

