/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.Platform;
import java.util.Arrays;

public final class LoggerUtil {
    private static Boolean allowExtendedLogs = null;

    private LoggerUtil() {
    }

    public static String getCleanUserHomePath(String string) {
        return string.replace(Platform.getUserHome(), "USERHOME");
    }

    public static String getTrimStr(String string) {
        if (allowExtendedLogs == null) {
            allowExtendedLogs = Boolean.getBoolean("allow.extended.logs");
        }
        if (!allowExtendedLogs.booleanValue() && string != null && string.length() >= 200) {
            return string.substring(0, 200) + "...";
        }
        return string;
    }

    public static String getTrimBytes(byte[] byArray) {
        if (allowExtendedLogs == null) {
            allowExtendedLogs = Boolean.getBoolean("allow.extended.logs");
        }
        if (!allowExtendedLogs.booleanValue() && byArray != null && byArray.length > 200) {
            return new String(Arrays.copyOfRange(byArray, 0, 200)) + "...";
        }
        return new String(byArray);
    }
}

