/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.misc.SecureXmlBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class AOFileUtils {
    private static final String SHORTENER_ELLIPSE = "...";
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static boolean posixSupported = false;
    private static boolean posixSupportDefined = false;

    private AOFileUtils() {
    }

    public static File createTempFile(byte[] byArray) throws IOException {
        File file = File.createTempFile("afirma", null);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        return file;
    }

    public static String pathLengthShortener(String string, int n) {
        int n2;
        if (string == null) {
            throw new IllegalArgumentException("El numbre de la ruta no puede ser nulo");
        }
        if (string.length() <= n) {
            return string;
        }
        char[] cArray = new char[n];
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = SHORTENER_ELLIPSE.toCharArray();
        int n3 = cArray2.length - 1;
        int n4 = n - 1;
        for (n2 = 0; n2 < n && cArray2[n3 - n2] != '/' && cArray2[n3 - n2] != '\\'; ++n2) {
            cArray[n4 - n2] = cArray2[n3 - n2];
        }
        int n5 = n - n2;
        if (n5 < SHORTENER_ELLIPSE.length()) {
            System.arraycopy(cArray3, 0, cArray, 0, cArray3.length);
        } else {
            int n6 = 0;
            while (n6 + cArray3.length < n5) {
                cArray[n6] = cArray2[n6];
                ++n6;
            }
            int n7 = 0;
            while (n6 + n7 < n5) {
                cArray[n6 + n7] = cArray3[n7];
                ++n7;
            }
        }
        return new String(cArray);
    }

    public static boolean isXML(byte[] byArray) {
        try {
            SAXParser sAXParser = SecureXmlBuilder.getSecureSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) {
                    this.log(sAXParseException);
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) {
                    this.log(sAXParseException);
                }

                @Override
                public void error(SAXParseException sAXParseException) {
                    this.log(sAXParseException);
                }

                private void log(Exception exception) {
                    LOGGER.fine("El documento no es un XML: " + exception);
                }
            });
            xMLReader.parse(new InputSource(new ByteArrayInputStream(byArray)));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void setAllPermissions(File file) {
        Collection<AclEntry> collection;
        try {
            file.setReadable(true, false);
            file.setWritable(true, false);
            file.setExecutable(true, false);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No se han podido establecer los permisos del archivo " + LoggerUtil.getCleanUserHomePath(file.getAbsolutePath()), exception);
        }
        AclFileAttributeView aclFileAttributeView = AOFileUtils.getAclAttributes(file);
        if (aclFileAttributeView != null) {
            try {
                collection = aclFileAttributeView.getAcl();
                ArrayList<AclEntry> arrayList = new ArrayList<AclEntry>();
                for (AclEntry aclEntry : collection) {
                    UserPrincipal userPrincipal = aclEntry.principal();
                    AclEntry aclEntry2 = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).setFlags(AclEntryFlag.DIRECTORY_INHERIT, AclEntryFlag.FILE_INHERIT).setPermissions(AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.DELETE, AclEntryPermission.WRITE_DATA, AclEntryPermission.READ_ACL, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_DATA, AclEntryPermission.EXECUTE, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.DELETE, AclEntryPermission.DELETE_CHILD).build();
                    arrayList.add(aclEntry2);
                }
                aclFileAttributeView.setAcl(arrayList);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "No se ha podido establecer la ACL del archivo " + LoggerUtil.getCleanUserHomePath(file.getAbsolutePath()), exception);
            }
        }
        if (AOFileUtils.isPosixSupported()) {
            collection = new HashSet();
            collection.add((AclEntry)((Object)PosixFilePermission.OWNER_READ));
            collection.add((AclEntry)((Object)PosixFilePermission.GROUP_READ));
            collection.add((AclEntry)((Object)PosixFilePermission.OTHERS_READ));
            collection.add((AclEntry)((Object)PosixFilePermission.OWNER_WRITE));
            collection.add((AclEntry)((Object)PosixFilePermission.GROUP_WRITE));
            collection.add((AclEntry)((Object)PosixFilePermission.OTHERS_WRITE));
            collection.add((AclEntry)((Object)PosixFilePermission.OWNER_EXECUTE));
            collection.add((AclEntry)((Object)PosixFilePermission.GROUP_EXECUTE));
            collection.add((AclEntry)((Object)PosixFilePermission.OTHERS_EXECUTE));
            try {
                Files.setPosixFilePermissions(file.toPath(), collection);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "No se han podido dar permisos posix sobre el archivo " + LoggerUtil.getCleanUserHomePath(file.getAbsolutePath()), exception);
            }
        }
    }

    private static boolean isPosixSupported() {
        if (!posixSupportDefined) {
            posixSupported = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
            posixSupportDefined = true;
        }
        return posixSupported;
    }

    private static AclFileAttributeView getAclAttributes(File file) {
        return Files.getFileAttributeView(file.toPath(), AclFileAttributeView.class, new LinkOption[0]);
    }

    private static void setAclAttributes(File file, AclFileAttributeView aclFileAttributeView) {
        AclFileAttributeView aclFileAttributeView2 = Files.getFileAttributeView(file.toPath(), AclFileAttributeView.class, new LinkOption[0]);
        try {
            aclFileAttributeView2.setAcl(aclFileAttributeView.getAcl());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "No se pudo establecer la ACL de permisos sobre el fichero " + LoggerUtil.getCleanUserHomePath(file.getAbsolutePath()), iOException);
        }
    }
}

