/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.misc.Base64;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Properties;

public final class TriphaseUtil {
    private static final String INCLUDE_ONLY_SIGNNING_CERTIFICATE = "includeOnlySignningCertificate";
    private static final String PARAM_NAME_CERT_SEPARATOR = ",";

    private TriphaseUtil() {
    }

    public static String prepareCertChainParam(Certificate[] certificateArray, Properties properties) throws CertificateEncodingException {
        if (certificateArray == null || certificateArray.length < 1) {
            throw new IllegalArgumentException("La cadena de certificados no puede ser nula ni vacia");
        }
        if (properties == null || Boolean.parseBoolean(properties.getProperty(INCLUDE_ONLY_SIGNNING_CERTIFICATE, Boolean.FALSE.toString()))) {
            return Base64.encode(certificateArray[0].getEncoded(), true);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Certificate certificate : certificateArray) {
            stringBuilder.append(Base64.encode(certificate.getEncoded(), true));
            stringBuilder.append(PARAM_NAME_CERT_SEPARATOR);
        }
        String string = stringBuilder.toString();
        return string.substring(0, string.length() - PARAM_NAME_CERT_SEPARATOR.length());
    }
}

