/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AdESPolicyPropertiesManager;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class ExtraParamsProcessor {
    private static final int SIZE_1MB = 0x100000;
    private static final String ETSI_CADES_DETACHED = "ETSI.CAdES.detached";
    private static final String EXPANDIBLE_POLICY_KEY = "expPolicy";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private ExtraParamsProcessor() {
    }

    public static Properties convertToProperties(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        try {
            properties.load(new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception exception) {
            LOGGER.warning("Se han encontrado entradas no validas en la configuracion de la operacion: " + exception);
        }
        return properties;
    }

    public static Properties expandProperties(Properties properties) throws IncompatiblePolicyException {
        return ExtraParamsProcessor.expandProperties(properties, null, null);
    }

    public static Properties expandProperties(Properties properties, byte[] byArray, String string) throws IncompatiblePolicyException {
        Properties properties2 = new Properties();
        for (String string2 : properties.keySet().toArray(new String[properties.size()])) {
            properties2.setProperty(string2, properties.getProperty(string2));
        }
        ExtraParamsProcessor.expandPolicyKeys(properties2, byArray, string);
        return properties2;
    }

    private static void expandPolicyKeys(Properties properties, byte[] byArray, String string) throws IncompatiblePolicyException {
        if (!properties.containsKey(EXPANDIBLE_POLICY_KEY)) {
            return;
        }
        String string2 = properties.getProperty(EXPANDIBLE_POLICY_KEY);
        if (!ExtraParamsProcessor.isSupportedPolicy(string2)) {
            properties.remove(EXPANDIBLE_POLICY_KEY);
            throw new IncompatiblePolicyException("No se soporta la expansion de atributos para la politica: " + string2);
        }
        String string3 = ExtraParamsProcessor.normalizeFormat(string);
        if (string3.equals("CAdES") && ("FirmaAGE".equals(string2) || "FirmaAGE18".equals(string2))) {
            ExtraParamsProcessor.setCAdESPolicyAGEAttributes(string2, properties, byArray);
        } else if (string3.equals("XAdES") && ("FirmaAGE".equals(string2) || "FirmaAGE18".equals(string2))) {
            ExtraParamsProcessor.setXAdESPolicyAGEAttributes(string2, properties);
        } else if (string3.equals("PAdES") && "FirmaAGE".equals(string2)) {
            ExtraParamsProcessor.setPAdESPolicyAGEAttributes(string2, properties);
        } else {
            properties.remove(EXPANDIBLE_POLICY_KEY);
            throw new IncompatiblePolicyException(String.format("El formato de firma %1s no esta soportado por la politica %2s", string, string2));
        }
        properties.remove(EXPANDIBLE_POLICY_KEY);
    }

    private static String normalizeFormat(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("CAdES") || string.equalsIgnoreCase("CAdEStri")) {
            string2 = "CAdES";
        } else if (string.equalsIgnoreCase("XAdES") || string.equalsIgnoreCase("XAdEStri") || string.toLowerCase(Locale.US).startsWith("XAdES".toLowerCase(Locale.US) + " ")) {
            string2 = "XAdES";
        } else if (string.equalsIgnoreCase("Adobe PDF") || string.equalsIgnoreCase("PAdES") || string.equalsIgnoreCase("Adobe PDF TriPhase") || string.equalsIgnoreCase("PAdEStri")) {
            string2 = "PAdES";
        }
        return string2 != null ? string2 : string;
    }

    private static boolean isSupportedPolicy(String string) {
        return "FirmaAGE".equals(string) || "FirmaAGE18".equals(string);
    }

    private static void setCAdESPolicyAGEAttributes(String string, Properties properties, byte[] byArray) {
        String string2;
        if (!properties.containsKey("mode") && byArray != null) {
            properties.setProperty("mode", byArray.length < 0x100000 ? "implicit" : "explicit");
        }
        if ("baseline".equalsIgnoreCase(string2 = properties.getProperty("profile"))) {
            LOGGER.warning("Se ignora la configuracion del parametro 'profile' en favor de los requisitos establecidos por la politica de firma");
        }
        properties.setProperty("profile", "advanced");
        AdESPolicyPropertiesManager.setProperties(properties, string, "CAdES");
    }

    private static void setXAdESPolicyAGEAttributes(String string, Properties properties) {
        String string2;
        String string3 = properties.getProperty("format");
        if (!"XAdES Detached".equalsIgnoreCase(string3) && !"XAdES Enveloped".equalsIgnoreCase(string3)) {
            if (string3 != null) {
                LOGGER.warning("Se ignora la configuracion del parametro 'format' en favor de los requisitos establecidos por la politica de firma");
            }
            properties.setProperty("format", "XAdES Detached");
        }
        if ("baseline".equalsIgnoreCase(string2 = properties.getProperty("profile"))) {
            LOGGER.warning("Se ignora la configuracion del parametro 'profile' en favor de los requisitos establecidos por la politica de firma");
        }
        properties.setProperty("profile", "advanced");
        AdESPolicyPropertiesManager.setProperties(properties, string, "XAdES");
    }

    private static void setPAdESPolicyAGEAttributes(String string, Properties properties) throws IncompatiblePolicyException {
        if (properties.containsKey("signatureSubFilter") && !ETSI_CADES_DETACHED.equals(properties.getProperty("signatureSubFilter"))) {
            throw new IncompatiblePolicyException("En PAdES con politica firma AGE debe usarse siempre el filtro 'ETSI.CAdES.detached'");
        }
        properties.setProperty("signatureSubFilter", ETSI_CADES_DETACHED);
        AdESPolicyPropertiesManager.setProperties(properties, string, "PAdES");
    }

    public static void configAutoFormat(AOSigner aOSigner, byte[] byArray, Properties properties) {
        String string = aOSigner.getClass().getName();
        if (string.equals("es.gob.afirma.signers.pades.AOPDFSigner")) {
            try {
                Method method = aOSigner.getClass().getMethod("configureRespectfulProperties", byte[].class, Properties.class);
                method.invoke(null, byArray, properties);
            }
            catch (Exception exception) {
                LOGGER.warning("Error al configurar una firma PAdES igual a las existentes: " + exception);
            }
        }
    }

    public static final class IncompatiblePolicyException
    extends Exception {
        private static final long serialVersionUID = -6420193548487585455L;

        IncompatiblePolicyException(String string) {
            super(string);
        }
    }
}

