/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ParameterLocalAccessRequestedException;
import es.gob.afirma.core.misc.protocol.ProtocolVersion;
import es.gob.afirma.core.misc.protocol.UrlParameters;
import es.gob.afirma.core.signers.ExtraParamsProcessor;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class UrlParametersToSignAndSave
extends UrlParameters {
    private static final int MAX_ID_LENGTH = 20;
    private static final String CRYPTO_OPERATION_PARAM = "cop";
    private static final String FORMAT_PARAM = "format";
    private static final String ALGORITHM_PARAM = "algorithm";
    private static final String FILENAME_PARAM = "filename";
    private static final String ID_PARAM = "id";
    private static final String VER_PARAM = "ver";
    private static final String STICKY_PARAM = "sticky";
    private static final String RESET_STICKY_PARAM = "resetsticky";
    private static final Set<String> SUPPORTED_SIGNATURE_ALGORITHMS = new HashSet<String>();
    private Operation operation;
    private String signFormat;
    private String signAlgorithm;
    private String minimumVersion;
    private boolean sticky;
    private boolean resetSticky;

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getSignatureFormat() {
        return this.signFormat;
    }

    public String getSignatureAlgorithm() {
        return this.signAlgorithm;
    }

    UrlParametersToSignAndSave() {
        this.setData(null);
        this.setFileId(null);
        this.setRetrieveServletUrl(null);
    }

    void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setSignFormat(String string) {
        this.signFormat = string;
    }

    void setSignAlgorithm(String string) {
        this.signAlgorithm = string;
    }

    void setMinimumVersion(String string) {
        this.minimumVersion = string;
    }

    public boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public void setResetSticky(boolean bl) {
        this.resetSticky = bl;
    }

    public boolean getResetSticky() {
        return this.resetSticky;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setSignAndSaveParameters(Map<String, String> map) throws ParameterException {
        String string = null;
        if (map.containsKey(ID_PARAM)) {
            string = map.get(ID_PARAM);
        } else if (map.containsKey("fileid")) {
            string = map.get("fileid");
        }
        if (string != null) {
            if (string.length() > 20) {
                throw new ParameterException("La longitud del identificador para la firma es mayor de 20 caracteres.");
            }
            for (char c : string.toLowerCase(Locale.ENGLISH).toCharArray()) {
                if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
                throw new ParameterException("El identificador de la firma debe ser alfanumerico.");
            }
            this.setSessionId(string);
        }
        if (map.containsKey(VER_PARAM)) {
            this.setMinimumVersion(map.get(VER_PARAM));
        } else {
            this.setMinimumVersion(Integer.toString(ProtocolVersion.VERSION_0.getVersion()));
        }
        if (map.containsKey(CRYPTO_OPERATION_PARAM)) {
            Operation operation = Operation.getOperation(map.get(CRYPTO_OPERATION_PARAM));
            if (operation == null) throw new ParameterException("Se ha indicado un codigo de operacion incorrecto: " + (Object)((Object)operation));
            this.setOperation(operation);
        } else {
            this.setOperation(Operation.SIGN);
        }
        if (this.getFileId() != null) {
            return;
        }
        if (map.containsKey("stservlet")) {
            URL uRL;
            try {
                uRL = UrlParametersToSignAndSave.validateURL(map.get("stservlet"));
            }
            catch (ParameterLocalAccessRequestedException parameterLocalAccessRequestedException) {
                throw new ParameterLocalAccessRequestedException("La URL del servicio de guardado no puede ser local: " + parameterLocalAccessRequestedException, parameterLocalAccessRequestedException);
            }
            catch (ParameterException parameterException) {
                throw new ParameterException("Error al validar la URL del servicio de guardado: " + parameterException, parameterException);
            }
            this.setStorageServletUrl(uRL);
        }
        if (!map.containsKey(FORMAT_PARAM)) {
            throw new ParameterException("No se ha recibido el formato de firma");
        }
        String string2 = map.get(FORMAT_PARAM);
        this.setSignFormat(string2);
        if (!map.containsKey(ALGORITHM_PARAM)) {
            throw new ParameterException("No se ha recibido el algoritmo de firma");
        }
        String string3 = map.get(ALGORITHM_PARAM);
        if (!SUPPORTED_SIGNATURE_ALGORITHMS.contains(string3)) {
            throw new ParameterException("Algoritmo de firma no soportado: " + string3);
        }
        this.setSignAlgorithm(string3);
        String string4 = null;
        if (map.containsKey("properties")) {
            string4 = map.get("properties");
        }
        if (string4 != null && !string4.isEmpty()) {
            try {
                this.setExtraParams(AOUtil.base642Properties(string4));
            }
            catch (Exception exception) {
                LOGGER.severe("Las propiedades adicionales indicadas en el parametro 'properties' no se han podido cargar: " + exception);
                this.setExtraParams(new Properties());
            }
        } else {
            this.setExtraParams(new Properties());
        }
        if (map.containsKey(STICKY_PARAM)) {
            this.setSticky(Boolean.parseBoolean(map.get(STICKY_PARAM)));
        } else {
            this.setSticky(false);
        }
        if (map.containsKey(RESET_STICKY_PARAM)) {
            this.setResetSticky(Boolean.parseBoolean(map.get(RESET_STICKY_PARAM)));
        } else {
            this.setResetSticky(false);
        }
        this.setDefaultKeyStore(UrlParameters.getDefaultKeyStoreName(map));
        this.setDefaultKeyStoreLib(UrlParameters.getDefaultKeyStoreLib(map));
        if (!map.containsKey(FILENAME_PARAM)) return;
        String string5 = map.get(FILENAME_PARAM);
        for (char c : "\\/:*?\"<>|".toCharArray()) {
            if (string5.indexOf(c) == -1) continue;
            throw new ParameterException("Se ha indicado un nombre de fichero con el caracter invalido: " + c);
        }
        this.setFilename(map.get(FILENAME_PARAM));
    }

    public void expandExtraParams() throws ExtraParamsProcessor.IncompatiblePolicyException {
        this.setExtraParams(ExtraParamsProcessor.expandProperties(this.getExtraParams(), this.getData(), this.getSignatureFormat()));
    }

    static {
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA1withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA256withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA384withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA512withRSA");
    }

    public static enum Operation {
        SIGN,
        COSIGN,
        COUNTERSIGN;


        public static Operation getOperation(String string) {
            if ("SIGN".equalsIgnoreCase(string)) {
                return SIGN;
            }
            if ("COSIGN".equalsIgnoreCase(string)) {
                return COSIGN;
            }
            if ("COUNTERSIGN".equalsIgnoreCase(string)) {
                return COUNTERSIGN;
            }
            return null;
        }
    }
}

