/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.OfficeAnalizer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;

public final class MimeHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String UNKNOWN_JMIMEMAGIC_VALUE = "???";
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";
    public static final String DEFAULT_CONTENT_DESCRIPTION = "binary";
    public static final String DEFAULT_CONTENT_OID_DATA = "1.2.840.113549.1.7.1";
    private static final String ZIP_MIMETYPE = "application/zip";
    private static final String XML_EXTENSION = "xml";
    private static final String XML_DESCRIPTION = "Documento XML";
    private static final String XML_MIMETYPE = "text/xml";
    private static final String DOC_OFFICE_MIMETYPE = "application/msword";
    private static Properties oidMimetypeProp = null;
    private static Properties mimetypeOidProp = null;
    private MimeInfo mimeInfo = null;
    private final byte[] data;

    public MimeHelper(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han indicado los datos que se desean analizar");
        }
        this.data = byArray;
        this.mimeInfo = new MimeInfo();
        try {
            Method method = Class.forName("net.sf.jmimemagic.Magic").getMethod("getMagicMatch", byte[].class);
            Object object = method.invoke(null, new Object[]{this.data});
            Class<?> clazz = Class.forName("net.sf.jmimemagic.MagicMatch");
            String string = (String)clazz.getMethod("getMimeType", null).invoke(object, (Object[])null);
            if (string != null && UNKNOWN_JMIMEMAGIC_VALUE.equals(string)) {
                string = null;
            }
            this.mimeInfo.setMimeType(string);
            String string2 = (String)clazz.getMethod("getExtension", null).invoke(object, (Object[])null);
            if (string2 != null && UNKNOWN_JMIMEMAGIC_VALUE.equals(string2)) {
                string2 = null;
            }
            this.mimeInfo.setExtension(string2);
            String string3 = (String)clazz.getMethod("getDescription", null).invoke(object, (Object[])null);
            if (string3 != null && UNKNOWN_JMIMEMAGIC_VALUE.equals(string3)) {
                string3 = null;
            }
            this.mimeInfo.setDescription(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.warning("No se encontro la biblioteca JMimeMagic para la deteccion del tipo de dato: " + classNotFoundException);
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName("net.sf.jmimemagic.MagicMatchNotFoundException");
                if (exception.getCause() != null && clazz.isInstance(exception.getCause())) {
                    LOGGER.warning("No se pudo detectar el formato de los datos");
                } else {
                    LOGGER.warning("Error durante el analisis de la cabecera de los datos: " + exception);
                }
            }
            catch (Exception exception2) {
                LOGGER.warning("Error al cargar las bibliotecas de deteccion del tipo de dato: " + exception2);
            }
        }
    }

    public static String transformMimeTypeToOid(String string) throws IOException {
        if (mimetypeOidProp == null) {
            MimeHelper.loadMimetypeOidProperties();
        }
        return string == null ? DEFAULT_CONTENT_OID_DATA : mimetypeOidProp.getProperty(string, DEFAULT_CONTENT_OID_DATA);
    }

    public static String transformOidToMimeType(String string) throws IOException {
        if (oidMimetypeProp == null) {
            MimeHelper.loadOidMimetypeProperties();
        }
        return string == null ? DEFAULT_MIMETYPE : oidMimetypeProp.getProperty(string, DEFAULT_MIMETYPE);
    }

    private static void loadOidMimetypeProperties() throws IOException {
        oidMimetypeProp = new Properties();
        try (InputStream inputStream = MimeHelper.class.getClassLoader().getResourceAsStream("resources/mimetypes_oids.properties");){
            if (inputStream == null) {
                throw new IOException("No se ha encontrado el fichero de recursos para la relacion entre OID y MimeType");
            }
            oidMimetypeProp.load(inputStream);
        }
    }

    private static void loadMimetypeOidProperties() throws IOException {
        if (oidMimetypeProp == null) {
            MimeHelper.loadOidMimetypeProperties();
        }
        mimetypeOidProp = new Properties();
        for (String string : oidMimetypeProp.keySet().toArray(new String[0])) {
            mimetypeOidProp.put(oidMimetypeProp.get(string), string);
        }
    }

    public String getMimeType() throws IOException {
        if (this.mimeInfo.isMimeTypeVerified()) {
            return this.mimeInfo.getMimeType();
        }
        String string = this.mimeInfo.getMimeType();
        if (string == null || XML_MIMETYPE.equals(string)) {
            if (AOFileUtils.isXML(this.data)) {
                this.mimeInfo.setMimeType(XML_MIMETYPE);
                this.mimeInfo.setMimeTypeVerified(true);
            } else {
                string = null;
            }
        }
        if (ZIP_MIMETYPE.equals(string) || DOC_OFFICE_MIMETYPE.equals(string)) {
            this.mimeInfo.setMimeType(OfficeAnalizer.getMimeType(this.data));
            this.mimeInfo.setMimeTypeVerified(true);
        }
        if (string == null) {
            this.mimeInfo.setMimeType(DEFAULT_MIMETYPE);
            this.mimeInfo.setMimeTypeVerified(true);
        }
        return this.mimeInfo.getMimeType();
    }

    public String getExtension() throws IOException {
        if (this.mimeInfo.isExtensionVerified()) {
            return this.mimeInfo.getExtension();
        }
        String string = this.getMimeType();
        String string2 = MimeHelper.verifyExtension(string);
        if (string2 != null) {
            this.mimeInfo.setExtension(string2);
        }
        this.mimeInfo.setExtensionVerified(true);
        return this.mimeInfo.getExtension();
    }

    private static String verifyExtension(String string) {
        String string2;
        if (DEFAULT_MIMETYPE.equals(string)) {
            return null;
        }
        if (XML_MIMETYPE.equals(string)) {
            return XML_EXTENSION;
        }
        if (string != null && (string2 = OfficeAnalizer.getExtension(string)) != null) {
            return string2;
        }
        return null;
    }

    public String getDescription() throws IOException {
        if (this.mimeInfo.isDescriptionVerified()) {
            return this.mimeInfo.getDescription();
        }
        String string = this.getMimeType();
        String string2 = MimeHelper.verifyDescription(string);
        if (string2 == null) {
            string2 = this.mimeInfo.getDescription() != null ? this.mimeInfo.getDescription() : DEFAULT_CONTENT_DESCRIPTION;
        }
        this.mimeInfo.setDescription(string2);
        this.mimeInfo.setDescriptionVerified(true);
        return this.mimeInfo.getDescription();
    }

    private static String verifyDescription(String string) {
        String string2;
        if (XML_MIMETYPE.equals(string)) {
            return XML_DESCRIPTION;
        }
        if (string != null && !string.equals(DEFAULT_MIMETYPE) && (string2 = OfficeAnalizer.getDescription(string)) != null) {
            return string2;
        }
        return null;
    }

    public boolean isZipData() {
        if (this.mimeInfo != null) {
            return ZIP_MIMETYPE.equals(this.mimeInfo.getMimeType());
        }
        if (this.data.length < 4) {
            return false;
        }
        return this.data[0] == 80 && this.data[1] == 75 && (this.data[2] == 3 && this.data[3] == 4 || this.data[2] == 5 && this.data[3] == 6 || this.data[2] == 7 && this.data[3] == 8);
    }

    static class MimeInfo {
        private String mType = null;
        private boolean mTypeVerified = false;
        private String extension = null;
        private boolean extensionVerified = false;
        private String description = null;
        private boolean descriptionVerified = false;

        MimeInfo() {
        }

        String getMimeType() {
            return this.mType;
        }

        void setMimeType(String string) {
            this.mType = string;
        }

        boolean isMimeTypeVerified() {
            return this.mTypeVerified;
        }

        void setMimeTypeVerified(boolean bl) {
            this.mTypeVerified = bl;
        }

        String getExtension() {
            return this.extension;
        }

        void setExtension(String string) {
            this.extension = string;
        }

        boolean isExtensionVerified() {
            return this.extensionVerified;
        }

        void setExtensionVerified(boolean bl) {
            this.extensionVerified = bl;
        }

        String getDescription() {
            return this.description;
        }

        void setDescription(String string) {
            this.description = string;
        }

        boolean isDescriptionVerified() {
            return this.descriptionVerified;
        }

        void setDescriptionVerified(boolean bl) {
            this.descriptionVerified = bl;
        }
    }
}

