/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class BoundedBufferedReader
extends BufferedReader {
    private static final int DEFAULT_MAX_LINES = 4096;
    private static final int DEFAULT_MAX_LINE_LENGTH = 4096;
    private final int readerMaxLines;
    private final int readerMaxLineLen;
    private int currentLine = 1;

    public BoundedBufferedReader(Reader reader, int n, int n2) {
        super(reader);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("BoundedBufferedReader - maxLines and maxLineLen must be greater than 0");
        }
        this.readerMaxLines = n;
        this.readerMaxLineLen = n2;
    }

    public BoundedBufferedReader(Reader reader) {
        super(reader);
        this.readerMaxLines = 4096;
        this.readerMaxLineLen = 4096;
    }

    @Override
    public String readLine() throws IOException {
        if (this.currentLine > this.readerMaxLines) {
            throw new IOException("BoundedBufferedReader - Line read limit has been reached.");
        }
        ++this.currentLine;
        int n = 0;
        char[] cArray = new char[this.readerMaxLineLen];
        int n2 = super.read();
        while (n2 != 13 && n2 != 10 && n2 >= 0) {
            cArray[n++] = (char)n2;
            if (n >= this.readerMaxLineLen) break;
            n2 = super.read();
        }
        if (n2 < 0) {
            if (n > 0) {
                return new String(cArray, 0, n);
            }
            return null;
        }
        if (n2 == 13) {
            super.mark(1);
            if (super.read() != 10) {
                super.reset();
            }
        } else if (n2 != 10) {
            super.mark(1);
            int n3 = super.read();
            if (n3 == 13) {
                super.mark(1);
                if (super.read() != 10) {
                    super.reset();
                }
            } else if (n3 != 10) {
                super.reset();
            }
        }
        return new String(cArray, 0, n);
    }
}

