/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class AOFileUtils {
    private static final String SHORTENER_ELLIPSE = "...";

    private AOFileUtils() {
    }

    public static File createTempFile(byte[] byArray) throws IOException {
        File file = File.createTempFile("afirma", null);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        return file;
    }

    public static String pathLengthShortener(String string, int n) {
        int n2;
        if (string == null) {
            throw new IllegalArgumentException("El numbre de la ruta no puede ser nulo");
        }
        if (string.length() <= n) {
            return string;
        }
        char[] cArray = new char[n];
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = SHORTENER_ELLIPSE.toCharArray();
        int n3 = cArray2.length - 1;
        int n4 = n - 1;
        for (n2 = 0; n2 < n && cArray2[n3 - n2] != '/' && cArray2[n3 - n2] != '\\'; ++n2) {
            cArray[n4 - n2] = cArray2[n3 - n2];
        }
        int n5 = n - n2;
        if (n5 < SHORTENER_ELLIPSE.length()) {
            System.arraycopy(cArray3, 0, cArray, 0, cArray3.length);
        } else {
            int n6 = 0;
            while (n6 + cArray3.length < n5) {
                cArray[n6] = cArray2[n6];
                ++n6;
            }
            int n7 = 0;
            while (n6 + n7 < n5) {
                cArray[n6 + n7] = cArray3[n7];
                ++n7;
            }
        }
        return new String(cArray);
    }

    public static boolean isXML(byte[] byArray) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) {
                    this.log(sAXParseException);
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) {
                    this.log(sAXParseException);
                }

                @Override
                public void error(SAXParseException sAXParseException) {
                    this.log(sAXParseException);
                }

                private void log(Exception exception) {
                    Logger.getLogger("es.gob.afirma").fine("El documento no es un XML: " + exception);
                }
            });
            xMLReader.parse(new InputSource(new ByteArrayInputStream(byArray)));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

