/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.keystores;

import java.security.cert.X509Certificate;

public final class KeyUsage {
    private static final int KEYUSAGE_NBITS = 9;
    private final Boolean[] usage;
    public static final KeyUsage SIGN = new KeyUsage(new Boolean[]{null, Boolean.TRUE, null, null, null, null, null, null, null});
    public static final KeyUsage AUTH = new KeyUsage(new Boolean[]{Boolean.TRUE, null, null, null, null, null, null, null, null});
    public static final KeyUsage CYPH = new KeyUsage(new Boolean[]{null, null, null, Boolean.TRUE, null, null, null, null, null});

    public boolean equals(Object object) {
        Boolean[] booleanArray;
        if (!(object instanceof KeyUsage)) {
            return false;
        }
        KeyUsage keyUsage = (KeyUsage)object;
        Boolean[] booleanArray2 = keyUsage.getUsage();
        if (booleanArray2.length != (booleanArray = this.getUsage()).length) {
            return false;
        }
        for (int i = 0; i < booleanArray.length; ++i) {
            if (booleanArray2[i] == booleanArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean includes(KeyUsage keyUsage) {
        Boolean[] booleanArray;
        if (keyUsage == null) {
            return false;
        }
        Boolean[] booleanArray2 = keyUsage.getUsage();
        if (booleanArray2.length != (booleanArray = this.getUsage()).length) {
            return false;
        }
        for (int i = 0; i < booleanArray.length; ++i) {
            if (booleanArray2[i] == null || booleanArray2[i] == booleanArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.usage != null) {
            for (Boolean bl : this.usage) {
                n += bl.hashCode();
            }
        }
        return n;
    }

    public KeyUsage(Boolean[] booleanArray) {
        if (booleanArray == null || booleanArray.length != 9) {
            throw new IllegalArgumentException("El uso debe proporcionarse como un Boolean[] no nulo de exactamente 9 posiciones");
        }
        this.usage = (Boolean[])booleanArray.clone();
    }

    public KeyUsage(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("El certificado de origen no puede ser nulo");
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null) {
            this.usage = null;
            return;
        }
        if (blArray.length != 9) {
            throw new IllegalArgumentException("El certificado de origen tiene un KeyUsage con un numero de posiciones no soportado: " + blArray.length);
        }
        this.usage = new Boolean[9];
        for (int i = 0; i < 9; ++i) {
            this.usage[i] = blArray[i];
        }
    }

    Boolean[] getUsage() {
        return this.usage == null ? null : (Boolean[])this.usage.clone();
    }

    public String toString() {
        if (this.usage == null) {
            return "Desconocido";
        }
        if (this.includes(SIGN) && this.includes(AUTH) && this.includes(CYPH)) {
            return "Firma, autenticaci\u00f3n y cifrado";
        }
        if (this.includes(AUTH) && this.includes(CYPH)) {
            return "Autenticaci\u00f3n y cifrado";
        }
        if (this.includes(SIGN) && this.includes(AUTH) && this.includes(CYPH)) {
            return "Firma y cifrado";
        }
        if (this.includes(SIGN) && this.includes(AUTH)) {
            return "Firma y autenticaci\u00f3n";
        }
        if (this.includes(AUTH)) {
            return "Autenticaci\u00f3n";
        }
        if (this.includes(SIGN)) {
            return "Firma";
        }
        if (this.includes(CYPH)) {
            return "Cifrado";
        }
        return "Otros";
    }
}

