/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public final class LogManager {
    private static final Logger LOGGER = Logger.getLogger("es.gob");
    private static final String LOG_FILE_NAME = "%a.afirma.log.xml";
    private static final String LOG_FILE_PATH = "%h/.afirma";
    private static final int LOG_MAX_SIZE = 0x200000;
    private static boolean installed = false;
    private static String logFile = null;
    private static App application = App.OTHER;

    private LogManager() {
    }

    public static void install(App app) throws IOException {
        LogManager.install(app, null);
    }

    public static void install(App app, String string) throws IOException {
        application = app == null ? App.OTHER : app;
        logFile = string == null ? LOG_FILE_PATH.replace("%h", Platform.getUserHome()) + "/" + LOG_FILE_NAME.replace("%a", application.toString()) : (string.replace("\\", "/") + (string.endsWith("/") ? "" : "/") + (Object)((Object)application) + ".afirma.log.xml").replace("%h", Platform.getUserHome());
        File file = new File(new File(logFile).getParent());
        if (!file.exists()) {
            LOGGER.info("La ruta para el fichero de registro ('" + file + "') no existe, se creara");
            if (!file.mkdirs()) {
                LOGGER.severe("No se ha podido crear la ruta para el fichero de registro ('" + file + "')");
            }
        }
        LOGGER.addHandler(LogManager.createFileHandler(logFile));
        installed = true;
    }

    private static FileHandler createFileHandler(String string) throws IOException {
        return new FileHandler(string, 0x200000, 1, false);
    }

    public static String getLogFile() throws IOException {
        String string;
        Handler[] handlerArray;
        if (!installed || logFile == null) {
            throw new IOException("No esta instalado el manejador de fichero");
        }
        for (Handler handler : handlerArray = LOGGER.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            handler.close();
            LOGGER.info("Cerrado el manejador de fichero para permitir que sea procesado");
            LOGGER.removeHandler(handler);
        }
        try (FileInputStream fileInputStream = new FileInputStream(new File(logFile.replace("%h", Platform.getUserHome())));){
            string = new String(AOUtil.getDataFromInputStream(fileInputStream));
        }
        LOGGER.addHandler(LogManager.createFileHandler(logFile));
        return string;
    }

    public static enum App {
        MINIAPPLET,
        APPLET,
        AUTOFIRMA,
        AUTOFIRMA_CONFIGURATOR,
        STANDALONE,
        ANDROID,
        HANDWRITTEN,
        DNINB,
        OTHER;

    }
}

