/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.TriphaseData;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public final class TriphaseDataSigner {
    private static final String PROPERTY_NAME_PRESIGN = "PRE";
    private static final String PROPERTY_NAME_PKCS1_SIGN = "PK1";
    private static final String PROPERTY_NAME_NEED_PRE = "NEED_PRE";

    private TriphaseDataSigner() {
    }

    public static TriphaseData doSign(AOPkcs1Signer aOPkcs1Signer, String string, PrivateKey privateKey, Certificate[] certificateArray, TriphaseData triphaseData) throws AOException {
        if (triphaseData.getSignsCount() < 1) {
            throw new AOException("No se han recibido prefirmas que firmar");
        }
        for (int i = 0; i < triphaseData.getSignsCount(); ++i) {
            byte[] byArray;
            TriphaseData.TriSign triSign = triphaseData.getSign(i);
            String string2 = triSign.getProperty(PROPERTY_NAME_PRESIGN);
            if (string2 == null) {
                throw new AOException("El servidor no ha devuelto la prefirma numero " + i);
            }
            try {
                byArray = Base64.decode(string2);
            }
            catch (IOException iOException) {
                throw new AOException("Error decodificando la prefirma: " + iOException, iOException);
            }
            byte[] byArray2 = aOPkcs1Signer.sign(byArray, string, privateKey, certificateArray, null);
            triSign.addProperty(PROPERTY_NAME_PKCS1_SIGN, Base64.encode(byArray2));
            if (triSign.getProperty(PROPERTY_NAME_NEED_PRE) != null && Boolean.parseBoolean(triSign.getProperty(PROPERTY_NAME_NEED_PRE))) continue;
            triSign.deleteProperty(PROPERTY_NAME_PRESIGN);
        }
        return triphaseData;
    }
}

