/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AdESPolicyPropertiesManager;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class ExtraParamsProcessor {
    private static final int SIZE_1MB = 0x100000;
    private static final String ETSI_CADES_DETACHED = "ETSI.CAdES.detached";
    private static final String EXPANDIBLE_POLICY_KEY = "expPolicy";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private ExtraParamsProcessor() {
    }

    public static Properties convertToProperties(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        try {
            properties.load(new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception exception) {
            LOGGER.warning("Se han encontrado entradas no validas en la configuracion de la operacion: " + exception);
        }
        return properties;
    }

    public static Properties expandProperties(Properties properties) throws IncompatiblePolicyException {
        return ExtraParamsProcessor.expandProperties(properties, null, null);
    }

    public static Properties expandProperties(Properties properties, byte[] byArray, String string) throws IncompatiblePolicyException {
        Properties properties2 = new Properties();
        for (String string2 : properties.keySet().toArray(new String[properties.size()])) {
            properties2.setProperty(string2, properties.getProperty(string2));
        }
        ExtraParamsProcessor.expandPolicyKeys(properties2, byArray, string);
        return properties2;
    }

    private static void expandPolicyKeys(Properties properties, byte[] byArray, String string) throws IncompatiblePolicyException {
        if (properties.containsKey(EXPANDIBLE_POLICY_KEY)) {
            String string2 = properties.getProperty(EXPANDIBLE_POLICY_KEY);
            if (!(!"FirmaAGE18".equals(string2) || "XAdES".toLowerCase(Locale.US).startsWith(string.toLowerCase(Locale.US)) || "XAdEStri".equalsIgnoreCase(string) || "CAdES".equalsIgnoreCase(string) || "CAdEStri".equalsIgnoreCase(string))) {
                throw new IncompatiblePolicyException("La politica de firma 1.8 de la AGE solo puede usarse con XAdES o CAdES, y no con " + string);
            }
            if ("FirmaAGE".equals(string2) || "FirmaAGE18".equals(string2)) {
                String string3 = null;
                if (string != null) {
                    if (string.toLowerCase(Locale.US).startsWith("XAdES".toLowerCase(Locale.US)) || string.toLowerCase(Locale.US).startsWith("XAdEStri".toLowerCase(Locale.US))) {
                        string3 = "XAdES";
                        if (!"XAdES Detached".equalsIgnoreCase(properties.getProperty("format")) && !"XAdES Enveloped".equalsIgnoreCase(properties.getProperty("format"))) {
                            if (properties.containsKey("format")) {
                                LOGGER.warning("La siguiente propiedad se ignora en favor del valor derivado de la politica establecida: format");
                            }
                            properties.setProperty("format", "XAdES Detached");
                        }
                    } else if (string.equalsIgnoreCase("CAdES") || string.equalsIgnoreCase("CAdEStri")) {
                        string3 = "CAdES";
                        if (!properties.containsKey("mode") && byArray != null) {
                            properties.setProperty("mode", byArray.length < 0x100000 ? "implicit" : "explicit");
                        }
                    } else if (string.equalsIgnoreCase("Adobe PDF") || string.equalsIgnoreCase("PAdES") || string.equalsIgnoreCase("Adobe PDF TriPhase") || string.equalsIgnoreCase("PAdEStri")) {
                        if (!ETSI_CADES_DETACHED.equals(properties.getProperty("signatureSubFilter", ETSI_CADES_DETACHED))) {
                            throw new IncompatiblePolicyException("En PAdES con politica firma AGE debe usarse siempre el filtro 'ETSI.CAdES.detached'");
                        }
                        properties.setProperty("signatureSubFilter", ETSI_CADES_DETACHED);
                        string3 = "PAdES";
                    }
                }
                AdESPolicyPropertiesManager.setProperties(properties, string2, string3);
            }
            properties.remove(EXPANDIBLE_POLICY_KEY);
        }
    }

    public static void configAutoFormat(AOSigner aOSigner, byte[] byArray, Properties properties) {
        String string = aOSigner.getClass().getName();
        if (string.equals("es.gob.afirma.signers.pades.AOPDFSigner")) {
            try {
                Method method = aOSigner.getClass().getMethod("configureRespectfulProperties", byte[].class, Properties.class);
                method.invoke(null, byArray, properties);
            }
            catch (Exception exception) {
                LOGGER.warning("Error al configurar una firma PAdES igual a las existentes: " + exception);
            }
        }
    }

    public static final class IncompatiblePolicyException
    extends Exception {
        private static final long serialVersionUID = -6420193548487585455L;

        IncompatiblePolicyException(String string) {
            super(string);
        }
    }
}

