/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ParameterLocalAccessRequestedException;
import es.gob.afirma.core.misc.protocol.ProtocolVersion;
import es.gob.afirma.core.misc.protocol.UrlParameters;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class UrlParametersForBatch
extends UrlParameters {
    private static final int MAX_ID_LENGTH = 20;
    private static final String PARAM_ID = "id";
    private static final String PARAM_BATCH_POSTSIGNER = "batchpostsignerurl";
    private static final String PARAM_BATCH_PRESIGNER = "batchpresignerurl";
    private static final String VER_PARAM = "ver";
    private static final String STICKY_PARAM = "sticky";
    private String batchPreSignerUrl = null;
    private String batchPostSignerUrl = null;
    private String minimumVersion;
    private boolean sticky;

    public String getBatchPresignerUrl() {
        return this.batchPreSignerUrl;
    }

    void setBatchPresignerUrl(String string) {
        this.batchPreSignerUrl = string;
    }

    public boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public String getBatchPostSignerUrl() {
        return this.batchPostSignerUrl;
    }

    void setBatchPostsignerUrl(String string) {
        this.batchPostSignerUrl = string;
    }

    void setBatchParameters(Map<String, String> map) throws ParameterException {
        Object object;
        if (map.containsKey(PARAM_ID) || map.containsKey("fileid")) {
            Object object2 = object = map.containsKey(PARAM_ID) ? map.get(PARAM_ID) : map.get("fileid");
            if (((String)object).length() > 20) {
                throw new ParameterException("La longitud del identificador para la firma es mayor de 20 caracteres.");
            }
            for (char c : ((String)object).toLowerCase(Locale.ENGLISH).toCharArray()) {
                if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
                throw new ParameterException("El identificador de la firma debe ser alfanumerico.");
            }
            this.setSessionId((String)object);
        }
        if (map.containsKey(VER_PARAM)) {
            this.setMinimumVersion(map.get(VER_PARAM));
        } else {
            this.setMinimumVersion(Integer.toString(ProtocolVersion.VERSION_0.getVersion()));
        }
        if (this.getFileId() != null) {
            return;
        }
        if (!map.containsKey(PARAM_BATCH_POSTSIGNER)) {
            throw new ParameterException("No se ha recibido la URL del postprocesador de lotes");
        }
        if (!map.containsKey(PARAM_BATCH_PRESIGNER)) {
            throw new ParameterException("No se ha recibido la URL del preprocesador de lotes");
        }
        this.setDefaultKeyStore(UrlParameters.getDefaultKeyStoreName(map));
        this.setDefaultKeyStoreLib(UrlParameters.getDefaultKeyStoreLib(map));
        this.setBatchPostsignerUrl(UrlParametersForBatch.validateURL(map.get(PARAM_BATCH_POSTSIGNER)).toString());
        this.setBatchPresignerUrl(UrlParametersForBatch.validateURL(map.get(PARAM_BATCH_PRESIGNER)).toString());
        if (map.containsKey("stservlet")) {
            try {
                object = UrlParametersForBatch.validateURL(map.get("stservlet"));
            }
            catch (ParameterLocalAccessRequestedException parameterLocalAccessRequestedException) {
                throw new ParameterLocalAccessRequestedException("La URL del servicio de guardado no puede ser local", parameterLocalAccessRequestedException);
            }
            catch (ParameterException parameterException) {
                throw new ParameterException("Error al validar la URL del servicio de guardado: " + parameterException, parameterException);
            }
            this.setStorageServletUrl((URL)object);
        }
        object = null;
        if (map.containsKey("properties")) {
            object = map.get("properties");
        }
        if (object != null && !((String)object).isEmpty()) {
            try {
                this.setExtraParams(AOUtil.base642Properties((String)object));
            }
            catch (Exception exception) {
                LOGGER.severe("Las propiedades adicionales indicadas en el parametro 'properties' no se han podido cargar: " + exception);
                this.setExtraParams(new Properties());
            }
        } else {
            this.setExtraParams(new Properties());
        }
        if (map.containsKey(STICKY_PARAM)) {
            this.setSticky(Boolean.parseBoolean(map.get(STICKY_PARAM)));
        } else {
            this.setSticky(false);
        }
        this.setDefaultKeyStore(UrlParametersForBatch.getDefaultKeyStoreName(map));
        this.setDefaultKeyStoreLib(UrlParametersForBatch.getDefaultKeyStoreLib(map));
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    void setMinimumVersion(String string) {
        this.minimumVersion = string;
    }
}

