/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ProtocolInvocationUriParserUtil;
import es.gob.afirma.core.misc.protocol.UrlParametersForBatch;
import es.gob.afirma.core.misc.protocol.UrlParametersToGetCurrentLog;
import es.gob.afirma.core.misc.protocol.UrlParametersToLoad;
import es.gob.afirma.core.misc.protocol.UrlParametersToSave;
import es.gob.afirma.core.misc.protocol.UrlParametersToSelectCert;
import es.gob.afirma.core.misc.protocol.UrlParametersToSign;
import es.gob.afirma.core.misc.protocol.UrlParametersToSignAndSave;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class ProtocolInvocationUriParser {
    private ProtocolInvocationUriParser() {
    }

    public static UrlParametersToSign getParametersToSign(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSign(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersToSign getParametersToSign(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSign(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    public static UrlParametersToSignAndSave getParametersToSignAndSave(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSignAndSave(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersToSignAndSave getParametersToSignAndSave(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSignAndSave(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    public static UrlParametersToSelectCert getParametersToSelectCert(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSelectCert(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersToSelectCert getParametersToSelectCert(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSelectCert(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    public static UrlParametersToSave getParametersToSave(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSave(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    public static UrlParametersToSave getParametersToSave(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSave(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersForBatch getParametersForBatch(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersForBatch(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersForBatch getParametersForBatch(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersForBatch(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    public static UrlParametersToLoad getParametersToLoad(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToLoad(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersToLoad getParametersToLoad(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToLoad(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    public static UrlParametersToGetCurrentLog getParametersToGetCurrentLog(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToGetCurrentLog(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersToGetCurrentLog getParametersToGetCurrentLog(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToGetCurrentLog(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    private static Map<String, String> parserUri(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.substring(string.indexOf(63) + 1).split("&");
        for (String string2 : stringArray) {
            if (string2.indexOf(61) <= 0) continue;
            try {
                hashMap.put(string2.substring(0, string2.indexOf(61)), string2.indexOf(61) == string2.length() - 1 ? "" : URLDecoder.decode(string2.substring(string2.indexOf(61) + 1), ProtocolInvocationUriParserUtil.DEFAULT_URL_ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                hashMap.put(string2.substring(0, string2.indexOf(61)), string2.indexOf(61) == string2.length() - 1 ? "" : string2.substring(string2.indexOf(61) + 1));
            }
        }
        Logger.getLogger("es.gob.afirma").info("URI recibida: " + string);
        Object object = string.substring(string.indexOf("://") + "://".length(), string.indexOf(63) != -1 ? string.indexOf(63) : string.length());
        if (((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        hashMap.put("op", ((String)object).substring(((String)object).lastIndexOf(47) + 1));
        return hashMap;
    }
}

