/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import java.io.IOException;

public final class HttpError
extends IOException {
    private static final long serialVersionUID = 8997766820804553378L;
    private final int responseCode;
    private final String responseDescription;
    private final byte[] errorStreamBytes;

    HttpError(int n) {
        super("Error en conexion HTTP con codigo de respuesta " + n);
        this.responseCode = n;
        this.responseDescription = null;
        this.errorStreamBytes = null;
    }

    public HttpError(int n, String string, String string2) {
        this(n, string, null, string2);
    }

    public HttpError(int n, String string, byte[] byArray, String string2) {
        super("Error HTTP con codigo  " + n + (byArray != null && byArray.length > 1 ? ", cuerpo '" + new String(byArray) + "'" : "") + " y descripcion '" + string + "' para la direccion: " + string2);
        this.responseCode = n;
        this.responseDescription = string;
        this.errorStreamBytes = byArray;
    }

    public byte[] getErrorStreamBytes() {
        return this.errorStreamBytes != null ? (byte[])this.errorStreamBytes.clone() : null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }
}

