/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.massive;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOFormatFileException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSignerFactory;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.massive.MassiveSignConfiguration;
import es.gob.afirma.massive.MassiveSignMessages;
import es.gob.afirma.massive.MassiveType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public final class MassiveSignatureHelper {
    private static final String CADES_SIGNER = "es.gob.afirma.signers.cades.AOCAdESSigner";
    private static final String XADES_SIGNER = "es.gob.afirma.signers.xades.AOXAdESSigner";
    private static final String XMLDSIG_SIGNER = "es.gob.afirma.signers.xmldsig.AOXMLDSigSigner";
    private static final String REG_FIELD_SEPARATOR = " - ";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String MODE = "mode";
    private static final String FORMAT = "format";
    private static final String MIME_TYPE = "mimeType";
    private static final AOException SIGN_DATA_NOT_GENERATED = new AOException("No se generaron datos de firma");
    private static final String DEFAULT_MESSAGE_DIGEST_ALGORITHM = "SHA1";
    private static MessageDigest md = null;
    private MassiveSignConfiguration massiveConfiguration = null;
    private List<String> log = null;
    private AOSigner defaultSigner = null;
    private AOSigner massiveSignSigner = null;
    private boolean enabled = false;

    public MassiveSignatureHelper(MassiveSignConfiguration massiveSignConfiguration) throws AOException {
        if (massiveSignConfiguration == null) {
            throw new IllegalArgumentException("La configuracion de firma masiva no puede ser nula");
        }
        if (massiveSignConfiguration.getMassiveOperation() == null) {
            throw new IllegalArgumentException("La configuracion indicada no tiene establecida ninguna operacion masiva");
        }
        this.massiveConfiguration = massiveSignConfiguration;
        this.massiveConfiguration.setSignatureFormat(this.massiveConfiguration.getDefaultFormat());
        this.enabled = true;
        this.defaultSigner = AOSignerFactory.getSigner((String)this.massiveConfiguration.getDefaultFormat());
        if (this.defaultSigner == null) {
            throw new AOException("Formato de firma no soportado: " + this.massiveConfiguration.getDefaultFormat());
        }
        this.massiveSignSigner = this.defaultSigner;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.massiveConfiguration = null;
        this.defaultSigner = null;
        this.enabled = false;
    }

    public void setMassiveOperation(MassiveType massiveType) {
        this.massiveConfiguration.setMassiveOperation(massiveType != null ? massiveType : MassiveType.SIGN);
    }

    public void setSignatureFormat(String string) {
        if (this.massiveConfiguration.getSignatureFormat().equals(string)) {
            return;
        }
        this.massiveConfiguration.setSignatureFormat(string);
        this.massiveSignSigner = AOSignerFactory.getSigner((String)this.massiveConfiguration.getSignatureFormat());
        if (this.massiveSignSigner == null) {
            LOGGER.warning("No hay disponible un manejador de firma para el formato " + string + ", se utilizara el formato de firma por defecto: " + this.massiveConfiguration.getDefaultFormat());
            this.massiveConfiguration.setSignatureFormat(this.massiveConfiguration.getDefaultFormat());
            this.massiveSignSigner = this.defaultSigner;
        }
    }

    public byte[] signData(byte[] byArray) {
        if (byArray == null) {
            LOGGER.severe("No se han introducido datos para firmar");
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.0"));
            return null;
        }
        Properties properties = (Properties)this.massiveConfiguration.getExtraParams().clone();
        properties.setProperty("headless", Boolean.toString(true));
        byte[] byArray2 = null;
        try {
            byArray2 = this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.SIGN) ? this.signDataFromData(this.massiveSignSigner, byArray, null, properties) : (this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.COSIGN) ? this.cosign(this.defaultSigner, byArray, properties) : (this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.COUNTERSIGN_ALL) ? this.countersignTree(this.defaultSigner, byArray, properties) : this.countersignLeafs(this.defaultSigner, byArray, properties)));
        }
        catch (AOFormatFileException aOFormatFileException) {
            LOGGER.severe("Los datos introducidos no tienen un formato valido: " + (Object)((Object)aOFormatFileException));
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.1"));
            return null;
        }
        catch (Exception exception) {
            LOGGER.severe("Error durante la operacion " + (Object)((Object)this.massiveConfiguration.getMassiveOperation()) + " sobre los datos introducidos: " + exception.getMessage());
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.2") + REG_FIELD_SEPARATOR + (Object)((Object)this.massiveConfiguration.getMassiveOperation()) + REG_FIELD_SEPARATOR + exception.getMessage());
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOGGER.severe("Error de falta de memoria durante la firma: " + outOfMemoryError);
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.16"));
            return null;
        }
        this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.3"));
        return byArray2;
    }

    public byte[] signHash(byte[] byArray) {
        if (byArray == null) {
            LOGGER.severe("No se ha introducido un hash para firmar");
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.4"));
            return null;
        }
        String string = "sign";
        byte[] byArray2 = null;
        Properties properties = (Properties)this.massiveConfiguration.getExtraParams().clone();
        properties.setProperty("headless", Boolean.toString(true));
        try {
            if (!this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.SIGN)) {
                if (this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.COSIGN)) {
                    string = "cosign";
                    throw new UnsupportedOperationException("La cofirma de un hash no es una operacion valida");
                }
                string = "countersign";
                throw new UnsupportedOperationException("La contrafirma de un hash no es una operacion valida");
            }
            MassiveSignatureHelper.checkvalidSignFormat(this.massiveConfiguration);
            string = "sign";
            byArray2 = this.signDataFromHash(this.massiveSignSigner, byArray, properties);
        }
        catch (Exception exception) {
            LOGGER.severe("Error al operar sobre el hash indicado (" + string + "): " + exception);
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.5") + REG_FIELD_SEPARATOR + string + REG_FIELD_SEPARATOR + exception.getMessage());
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOGGER.severe("Error de falta de memoria durante la firma: " + outOfMemoryError);
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.16"));
            return null;
        }
        this.addLog("Operaci\u00f3n sobre hash: Correcta");
        return byArray2;
    }

    private static void checkvalidSignFormat(MassiveSignConfiguration massiveSignConfiguration) {
        if ("PAdES".equals(massiveSignConfiguration.getSignatureFormat()) || "Adobe PDF".equals(massiveSignConfiguration.getSignatureFormat())) {
            throw new UnsupportedOperationException("El formato de firma PDF/PAdES no puede realizarse sobre un hash");
        }
        if ("ODF (Open Document Format)".equals(massiveSignConfiguration.getSignatureFormat()) || "ODF".equals(massiveSignConfiguration.getSignatureFormat())) {
            throw new UnsupportedOperationException("El formato de firma ODF no puede realizarse sobre un hash");
        }
        if ("OOXML (Office Open XML)".equals(massiveSignConfiguration.getSignatureFormat()) || "OOXML".equals(massiveSignConfiguration.getSignatureFormat())) {
            throw new UnsupportedOperationException("El formato de firma OOXML no puede realizarse sobre un hash");
        }
        if ("FacturaE".equals(massiveSignConfiguration.getSignatureFormat()) || "Factura-e".equals(massiveSignConfiguration.getSignatureFormat())) {
            throw new UnsupportedOperationException("El formato de firma OOXML no puede realizarse sobre un hash");
        }
    }

    public byte[] signFile(String string) {
        byte[] byArray;
        Serializable serializable;
        Object object;
        URI uRI;
        if (string == null) {
            LOGGER.severe("No se ha introducido un fichero para firmar");
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.6"));
            return null;
        }
        try {
            uRI = AOUtil.createURI((String)string);
        }
        catch (Exception exception) {
            LOGGER.severe("La URI '" + string + "' no posee un formato valido: " + exception);
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.7") + REG_FIELD_SEPARATOR + string);
            return null;
        }
        try {
            object = AOUtil.loadFile((URI)uRI);
            serializable = null;
            try {
                byArray = AOUtil.getDataFromInputStream((InputStream)object);
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (serializable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.severe("No ha sido posible encontrar el fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "': " + fileNotFoundException);
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.8") + REG_FIELD_SEPARATOR + LoggerUtil.getCleanUserHomePath((String)string));
            return null;
        }
        catch (Exception exception) {
            LOGGER.severe("No es posible acceder al contenido del fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "': " + exception);
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.9") + REG_FIELD_SEPARATOR + LoggerUtil.getCleanUserHomePath((String)string));
            return null;
        }
        if (byArray == null) {
            LOGGER.severe("El fichero '" + string + "' esta vacio");
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.12") + REG_FIELD_SEPARATOR + string);
            return null;
        }
        serializable = (Properties)this.massiveConfiguration.getExtraParams().clone();
        ((Properties)serializable).setProperty("headless", Boolean.toString(true));
        try {
            object = this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.SIGN) ? (Object)this.signDataFromData(this.massiveSignSigner, byArray, uRI, (Properties)serializable) : (this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.COSIGN) ? (Object)this.cosign(this.defaultSigner, byArray, (Properties)serializable) : (this.massiveConfiguration.getMassiveOperation().equals((Object)MassiveType.COUNTERSIGN_ALL) ? (Object)this.countersignTree(this.defaultSigner, byArray, (Properties)serializable) : (Object)this.countersignLeafs(this.defaultSigner, byArray, (Properties)serializable)));
        }
        catch (AOFormatFileException aOFormatFileException) {
            LOGGER.severe("El fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "' no tiene un formato valido: " + aOFormatFileException.getMessage());
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.13") + REG_FIELD_SEPARATOR + LoggerUtil.getCleanUserHomePath((String)string));
            return null;
        }
        catch (Exception exception) {
            LOGGER.severe("Error al realizar la operacion " + (Object)((Object)this.massiveConfiguration.getMassiveOperation()) + " sobre el fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "': " + exception.getMessage());
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.14") + REG_FIELD_SEPARATOR + exception.getMessage());
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOGGER.severe("Error de falta de memoria durante la firma: " + outOfMemoryError);
            this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.16"));
            return null;
        }
        this.addLog(MassiveSignMessages.getString("MassiveSignatureHelper.15"));
        return object;
    }

    private byte[] signDataFromData(AOSigner aOSigner, byte[] byArray, URI uRI, Properties properties) throws AOException, IOException {
        Object object;
        if (!properties.containsKey(MODE)) {
            properties.setProperty(MODE, this.massiveConfiguration.getMode());
        }
        if (!properties.containsKey(FORMAT)) {
            properties.setProperty(FORMAT, this.massiveConfiguration.getSignatureFormat());
        }
        if (uRI != null) {
            properties.setProperty("uri", uRI.toString());
        }
        byte[] byArray2 = byArray;
        String string = aOSigner.getClass().getName();
        if (CADES_SIGNER.equals(string) || XADES_SIGNER.equals(string) || XMLDSIG_SIGNER.equals(string)) {
            Object object2;
            if (properties.containsKey(MIME_TYPE)) {
                object = properties.getProperty(MIME_TYPE);
            } else if ((XADES_SIGNER.equals(string) || XMLDSIG_SIGNER.equals(string)) && "explicit".equalsIgnoreCase(properties.getProperty(MODE))) {
                byArray2 = MassiveSignatureHelper.digest(byArray2);
                object = "hash/SHA1".toLowerCase();
            } else {
                object2 = new MimeHelper(byArray2);
                object = object2.getMimeType();
            }
            properties.setProperty(MIME_TYPE, (String)object);
            if (!properties.containsKey("contentTypeOid") && (object2 = MimeHelper.transformMimeTypeToOid((String)object)) != null) {
                properties.setProperty("contentTypeOid", (String)object2);
            }
        }
        if ((object = (Object)aOSigner.sign(byArray2, this.massiveConfiguration.getAlgorithm(), this.massiveConfiguration.getKeyEntry().getPrivateKey(), this.massiveConfiguration.getKeyEntry().getCertificateChain(), properties)) == null) {
            throw SIGN_DATA_NOT_GENERATED;
        }
        return object;
    }

    private byte[] signDataFromHash(AOSigner aOSigner, byte[] byArray, Properties properties) throws AOException, IOException {
        Object object;
        if (!properties.containsKey(MODE)) {
            properties.setProperty(MODE, this.massiveConfiguration.getMode());
        }
        if (!properties.containsKey(FORMAT)) {
            properties.setProperty(FORMAT, this.massiveConfiguration.getSignatureFormat());
        }
        properties.setProperty("precalculatedHashAlgorithm", AOSignConstants.getDigestAlgorithmName((String)this.massiveConfiguration.getAlgorithm()));
        if (aOSigner.getClass().getName().equals(XADES_SIGNER) || aOSigner.getClass().getName().equals(XMLDSIG_SIGNER)) {
            object = "hash/" + AOSignConstants.getDigestAlgorithmName((String)this.massiveConfiguration.getAlgorithm()).toLowerCase();
            properties.setProperty(MIME_TYPE, (String)object);
        }
        if ((object = (Object)aOSigner.sign(byArray, this.massiveConfiguration.getAlgorithm(), this.massiveConfiguration.getKeyEntry().getPrivateKey(), this.massiveConfiguration.getKeyEntry().getCertificateChain(), properties)) == null) {
            throw SIGN_DATA_NOT_GENERATED;
        }
        return object;
    }

    private byte[] cosign(AOSigner aOSigner, byte[] byArray, Properties properties) throws AOException, IOException {
        AOSigner aOSigner2;
        byte[] byArray2;
        if (!properties.containsKey(MODE)) {
            properties.setProperty(MODE, this.massiveConfiguration.getMode());
        }
        if ((byArray2 = (aOSigner2 = this.getValidSigner(aOSigner, byArray)).cosign(byArray, this.massiveConfiguration.getAlgorithm(), this.massiveConfiguration.getKeyEntry().getPrivateKey(), this.massiveConfiguration.getKeyEntry().getCertificateChain(), properties)) == null) {
            throw SIGN_DATA_NOT_GENERATED;
        }
        return byArray2;
    }

    private byte[] countersignTree(AOSigner aOSigner, byte[] byArray, Properties properties) throws AOException, IOException {
        return this.countersignOperation(aOSigner, byArray, CounterSignTarget.TREE, properties);
    }

    private byte[] countersignLeafs(AOSigner aOSigner, byte[] byArray, Properties properties) throws AOException, IOException {
        return this.countersignOperation(aOSigner, byArray, CounterSignTarget.LEAFS, properties);
    }

    private byte[] countersignOperation(AOSigner aOSigner, byte[] byArray, CounterSignTarget counterSignTarget, Properties properties) throws AOException, IOException {
        AOSigner aOSigner2 = this.getValidSigner(aOSigner, byArray);
        byte[] byArray2 = aOSigner2.countersign(byArray, this.massiveConfiguration.getAlgorithm(), counterSignTarget, null, this.massiveConfiguration.getKeyEntry().getPrivateKey(), this.massiveConfiguration.getKeyEntry().getCertificateChain(), properties);
        if (byArray2 == null) {
            throw SIGN_DATA_NOT_GENERATED;
        }
        return byArray2;
    }

    private AOSigner getValidSigner(AOSigner aOSigner, byte[] byArray) throws AOException, IOException {
        AOSigner aOSigner2 = aOSigner;
        if (!this.massiveConfiguration.isOriginalFormat()) {
            if (!aOSigner.isSign(byArray)) {
                throw new AOException("La firma introducida no se corresponde con el formato de firma especificado");
            }
        } else {
            aOSigner2 = MassiveSignatureHelper.getSpecificSigner(byArray);
            if (aOSigner2 == null && (aOSigner2 = AOSignerFactory.getSigner((byte[])byArray)) == null) {
                throw new AOException("La firma introducida no se corresponde con ning\u00fan formato soportado");
            }
        }
        return aOSigner2;
    }

    private static AOSigner getSpecificSigner(byte[] byArray) throws IOException {
        String[] stringArray;
        for (String string : stringArray = new String[]{"Adobe PDF", "ODF (Open Document Format)", "OOXML (Office Open XML)"}) {
            AOSigner aOSigner = AOSignerFactory.getSigner((String)string);
            if (aOSigner == null || !aOSigner.isValidDataFile(byArray)) continue;
            return aOSigner;
        }
        return null;
    }

    private void addLog(String string) {
        if (this.log == null) {
            this.log = new ArrayList<String>();
        }
        this.log.add(string);
    }

    public String getCurrentLogEntry() {
        String string = "";
        if (this.log != null) {
            string = this.log.get(this.log.size() - 1);
        }
        return string;
    }

    public String getDefaultSignatureFormat() {
        if (this.massiveConfiguration != null) {
            return this.massiveConfiguration.getDefaultFormat();
        }
        return null;
    }

    public String getAllLogEntries() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.log != null) {
            for (String string : this.log) {
                stringBuilder.append(string).append("\r\n");
            }
        }
        return stringBuilder.toString().trim();
    }

    private static byte[] digest(byte[] byArray) {
        if (md == null) {
            try {
                md = MessageDigest.getInstance(DEFAULT_MESSAGE_DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOGGER.severe("Se ha utilizado internamente un algoritmo de huella digital no soportado: " + noSuchAlgorithmException);
                throw new IllegalArgumentException("Algoritmo no soportado", noSuchAlgorithmException);
            }
        }
        return md.digest(byArray);
    }
}

