/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.massive;

import es.gob.afirma.massive.MassiveType;
import java.security.KeyStore;
import java.util.Properties;

public final class MassiveSignConfiguration {
    private final KeyStore.PrivateKeyEntry keyEntry;
    private MassiveType massiveOperation = MassiveType.SIGN;
    private String algorithm = "SHA512withRSA";
    private String mode = "explicit";
    private String defaultFormat = "CAdES";
    private String signatureFormat = "CAdES";
    private boolean originalFormat = true;
    private Properties extraParams;

    public MassiveSignConfiguration(KeyStore.PrivateKeyEntry privateKeyEntry) {
        this.keyEntry = privateKeyEntry;
        this.extraParams = new Properties();
    }

    public MassiveType getMassiveOperation() {
        return this.massiveOperation;
    }

    public void setMassiveOperation(MassiveType massiveType) {
        this.massiveOperation = massiveType != null ? massiveType : MassiveType.SIGN;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string != null ? string : "SHA512withRSA";
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string != null ? string : "explicit";
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setDefaultFormat(String string) {
        this.signatureFormat = this.defaultFormat = string != null ? string : "CAdES";
    }

    public String getSignatureFormat() {
        return this.signatureFormat;
    }

    public void setSignatureFormat(String string) {
        this.signatureFormat = string != null ? string : this.defaultFormat;
    }

    public boolean isOriginalFormat() {
        return this.originalFormat;
    }

    public void setOriginalFormat(boolean bl) {
        this.originalFormat = bl;
    }

    public KeyStore.PrivateKeyEntry getKeyEntry() {
        return this.keyEntry;
    }

    public void setExtraParams(Properties properties) {
        if (properties != null) {
            this.extraParams = (Properties)properties.clone();
        } else {
            this.extraParams.clear();
        }
    }

    public Properties getExtraParams() {
        return this.extraParams != null ? (Properties)this.extraParams.clone() : null;
    }
}

