/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.massive;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOUnsupportedSignFormatException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSignerFactory;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.massive.DefaultLogHandler;
import es.gob.afirma.massive.LogHandler;
import es.gob.afirma.massive.MassiveSignMessages;
import es.gob.afirma.massive.MassiveType;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectorySignatureHelper {
    private static final String MODE_KEY = "mode";
    private static final String FORMAT_KEY = "format";
    private static final String URI_STR = "uri";
    private static final String CADES_SIGNER = "es.gob.afirma.signers.cades.AOCAdESSigner";
    private static final String XADES_SIGNER = "es.gob.afirma.signers.xades.AOXAdESSigner";
    private static final String XMLDSIG_SIGNER = "es.gob.afirma.signers.xmldsig.AOXMLDSigSigner";
    private static final String PDF_SIGNER = "es.gob.afirma.signers.pades.AOPDFSigner";
    private static final String ODF_SIGNER = "es.gob.afirma.signers.odf.AOODFSSigner";
    private static final String OOXML_SIGNER = "es.gob.afirma.signers.ooxml.AOOOXMLSigner";
    private static final String REG_FIELD_SEPARATOR = " - ";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String DEFAULT_LOG_FILE = "result.log";
    private static final String DEFAULT_MESSAGE_DIGEST_ALGORITHM = "SHA-512";
    private static MessageDigest md = null;
    private String algorithm = null;
    private String format = null;
    private String mode = null;
    private AOSigner defaultSigner = null;
    private FileFilter fileFilter = null;
    private String outputDir = null;
    private boolean overwriteFiles = false;
    private LogHandler logHandler;
    private int errorCount;
    private int warnCount;
    private String inDir = null;
    private List<String> signedFilenames = new ArrayList<String>();
    private boolean activeLog = true;
    private String logPath = null;

    public DirectorySignatureHelper(String string, String string2, String string3) throws AOUnsupportedSignFormatException {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("No se ha indicado una configuracion de algoritmo de firma valida");
        }
        this.algorithm = string;
        this.format = string2;
        this.mode = string3;
        this.defaultSigner = AOSignerFactory.getSigner((String)this.format);
        if (this.defaultSigner == null) {
            throw new AOUnsupportedSignFormatException("El formato de firma '" + string2 + "' seleccionado para la firma masiva no esta soportado");
        }
    }

    public boolean massiveSign(MassiveType massiveType, String string, boolean bl, String string2, boolean bl2, boolean bl3, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) throws AOException, IOException {
        if (properties == null || !properties.containsKey(FORMAT_KEY) || !properties.containsKey(MODE_KEY)) {
            throw new IllegalArgumentException("No se ha establecido el formato y modo de firma");
        }
        if (string == null || string.trim().length() < 1) {
            LOGGER.warning("No se ha indicado un directorio de inicio, se usara el actual");
        }
        File file = new File(string != null && string.trim().length() > 0 ? string.trim() : ".");
        this.inDir = file.getAbsolutePath();
        if (!file.exists() || !file.isDirectory()) {
            throw new AOException("El directorio de entrada no existe");
        }
        if (!file.canRead()) {
            throw new AOException("No se tienen permisos de lectura para el directorio de entrada");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            arrayList2.add(file2);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (((File)arrayList2.get(i)).isFile()) {
                if (this.fileFilter == null) {
                    arrayList.add(((File)arrayList2.get(i)).getPath());
                    continue;
                }
                if (!this.fileFilter.accept((File)arrayList2.get(i))) continue;
                arrayList.add(((File)arrayList2.get(i)).getAbsolutePath());
                continue;
            }
            if (!bl) continue;
            if (((File)arrayList2.get(i)).canRead()) {
                for (File file3 : ((File)arrayList2.get(i)).listFiles()) {
                    arrayList2.add(file3);
                }
                continue;
            }
            LOGGER.warning("Por falta de permisos no se procesaran los ficheros del subdirectorio: " + LoggerUtil.getCleanUserHomePath((String)((File)arrayList2.get(i)).getAbsolutePath()));
        }
        return this.massiveSign(massiveType, arrayList.toArray(new String[arrayList.size()]), string2, bl2, bl3, privateKeyEntry, properties);
    }

    public boolean massiveSign(MassiveType massiveType, String[] stringArray, String string, boolean bl, boolean bl2, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) throws AOException, IOException {
        if (properties == null || !properties.containsKey(FORMAT_KEY) || !properties.containsKey(MODE_KEY)) {
            throw new IllegalArgumentException("No se ha establecido el formato y modo de firma");
        }
        Properties properties2 = (Properties)properties.clone();
        properties2.setProperty("headless", "true");
        if (!properties2.containsKey(MODE_KEY) && this.mode != null) {
            properties2.setProperty(MODE_KEY, this.mode);
        }
        if (!properties2.containsKey(FORMAT_KEY)) {
            properties2.setProperty(FORMAT_KEY, this.format);
        }
        boolean bl3 = true;
        this.signedFilenames = new ArrayList<String>();
        if (stringArray == null || stringArray.length == 0) {
            LOGGER.warning("No se han proporcionado ficheros para firmar");
            return true;
        }
        if (string != null) {
            this.outputDir = string;
        } else {
            LOGGER.warning("No se ha especificado un directorio de salida, se usara el actual");
            this.outputDir = ".";
        }
        File file = new File(this.outputDir);
        if (!file.exists() && bl) {
            file.mkdirs();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("El directorio de salida no existe o existe un fichero con el mismo nombre");
        }
        if (!file.canWrite()) {
            throw new IOException("No se tienen permisos de escritura en el directorio de salida");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.logPath != null ? this.logPath : string + File.separator + DEFAULT_LOG_FILE);){
            if (this.activeLog && this.logHandler == null) {
                this.logHandler = DirectorySignatureHelper.initDefaultLogHandler(fileOutputStream);
            }
            File[] fileArray = this.getFiles(stringArray);
            if (MassiveType.SIGN.equals((Object)massiveType) || massiveType == null) {
                bl3 = this.massiveSignOperation(fileArray, file, privateKeyEntry, properties2);
            } else if (MassiveType.COSIGN.equals((Object)massiveType)) {
                bl3 = this.massiveCosignOperation(fileArray, file, bl2, privateKeyEntry, properties2);
            } else if (MassiveType.COUNTERSIGN_ALL.equals((Object)massiveType) || MassiveType.COUNTERSIGN_LEAFS.equals((Object)massiveType)) {
                bl3 = this.massiveCounterSignOperation(massiveType, fileArray, file, bl2, privateKeyEntry, properties2);
            } else {
                LOGGER.severe("Operacion masiva no reconocida");
            }
            this.closeLogRegistry();
        }
        return bl3;
    }

    public String[] hashesMassiveSign(String[] stringArray, KeyStore.PrivateKeyEntry privateKeyEntry, AOSigner aOSigner, Properties properties) throws AOException {
        Object object;
        AOSigner aOSigner2;
        if (stringArray == null || privateKeyEntry == null) {
            throw new IllegalArgumentException("Las huellas digitales a firmar y la clave privada no pueden ser nulas");
        }
        if (properties == null || !properties.containsKey(FORMAT_KEY) || !properties.containsKey(MODE_KEY)) {
            throw new IllegalArgumentException("No se ha establecido el formato y modo de firma");
        }
        if (aOSigner != null && !aOSigner.getClass().equals(this.defaultSigner.getClass())) {
            throw new ClassCastException("El signer configurado para la multifirma debe ser compatible con el signer del formato indicado en el constructor");
        }
        Properties properties2 = (Properties)properties.clone();
        properties2.setProperty("headless", "true");
        AOSigner aOSigner3 = aOSigner2 = aOSigner != null ? aOSigner : this.defaultSigner;
        if (!properties2.containsKey(MODE_KEY) && this.mode != null) {
            properties2.setProperty(MODE_KEY, this.mode);
        }
        if (!properties2.containsKey(FORMAT_KEY)) {
            properties2.setProperty(FORMAT_KEY, this.format);
        }
        properties2.setProperty("precalculatedHashAlgorithm", AOSignConstants.getDigestAlgorithmName((String)this.algorithm));
        if (aOSigner2.getClass().getName().equals(XADES_SIGNER) || aOSigner2.getClass().getName().equals(XMLDSIG_SIGNER)) {
            object = "hash/" + AOSignConstants.getDigestAlgorithmName((String)this.algorithm).toLowerCase();
            properties2.setProperty("mimeType", (String)object);
        }
        object = new byte[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                object[i] = aOSigner2.sign(Base64.decode((String)stringArray[i]), this.algorithm, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain(), properties2);
                continue;
            }
            catch (IOException iOException) {
                throw new AOException("El hash '" + stringArray[i] + "' no es un Base64 valido", (Throwable)iOException);
            }
        }
        String[] stringArray2 = new String[((byte[][])object).length];
        for (int i = 0; i < ((byte[][])object).length; ++i) {
            stringArray2[i] = Base64.encode((byte[])object[i]);
        }
        return stringArray2;
    }

    private File[] getFiles(String[] stringArray) {
        File file = null;
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (String string : stringArray) {
            file = new File(string);
            if (!file.exists()) {
                LOGGER.severe("El fichero no existe: " + LoggerUtil.getCleanUserHomePath((String)string));
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.0"), LoggerUtil.getCleanUserHomePath((String)string), null);
                continue;
            }
            if (!file.isFile()) {
                LOGGER.severe("El archivo '" + LoggerUtil.getCleanUserHomePath((String)string) + "' es un directorio y no puede firmarse");
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.1"), LoggerUtil.getCleanUserHomePath((String)string), null);
                continue;
            }
            if (!file.canRead()) {
                LOGGER.severe("No se puede leer el fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "'");
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.2"), LoggerUtil.getCleanUserHomePath((String)string), null);
                continue;
            }
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private boolean massiveSignOperation(File[] fileArray, File file, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) throws IOException {
        boolean bl = true;
        byte[] byArray = null;
        AOSigner aOSigner = this.defaultSigner;
        for (File file2 : fileArray) {
            String string;
            Object object;
            Object object2;
            Object object3;
            block30: {
                try {
                    if (!DirectorySignatureHelper.isValidDataFile(aOSigner, file2)) {
                        LOGGER.warning("El fichero no puede ser firmado con la configuracion de firma actual: " + LoggerUtil.getCleanUserHomePath((String)file2.getPath()));
                        this.addLogRegistry(Level.WARNING, MassiveSignMessages.getString("DirectorySignatureHelper.4"), file2.getPath(), null);
                        bl = false;
                    }
                    break block30;
                }
                catch (Exception exception) {
                    LOGGER.warning("No se pudo leer fichero '" + LoggerUtil.getCleanUserHomePath((String)file2.getPath()) + "': " + exception);
                    this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.5"), file2.getPath(), null);
                    bl = false;
                }
                continue;
            }
            properties.setProperty(URI_STR, file2.toURI().toASCIIString());
            try {
                object3 = new FileInputStream(file2);
                object2 = null;
                try {
                    byArray = AOUtil.getDataFromInputStream((InputStream)object3);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object2 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object3).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.warning("No se pudo leer fichero '" + LoggerUtil.getCleanUserHomePath((String)file2.getPath()) + "': " + exception);
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.5"), file2.getPath(), null);
                byArray = null;
                bl = false;
                continue;
            }
            object3 = aOSigner.getClass().getName();
            if (CADES_SIGNER.equals(object3) || XADES_SIGNER.equals(object3) || XMLDSIG_SIGNER.equals(object3)) {
                if ((XADES_SIGNER.equals(object3) || XMLDSIG_SIGNER.equals(object3)) && "explicit".equalsIgnoreCase(this.mode)) {
                    byArray = DirectorySignatureHelper.digest(byArray);
                    object2 = "hash/SHA-512".toLowerCase();
                } else {
                    object = new MimeHelper(byArray);
                    object2 = object.getMimeType();
                }
                if (object2 != null) {
                    properties.setProperty("mimeType", (String)object2);
                    object = MimeHelper.transformMimeTypeToOid((String)object2);
                    if (object != null) {
                        properties.setProperty("contentTypeOid", (String)object);
                    }
                }
            }
            object2 = null;
            try {
                object2 = aOSigner.sign(byArray, this.algorithm, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain(), properties);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOGGER.severe("No ha sido posible firmar el fichero '" + LoggerUtil.getCleanUserHomePath((String)file2.getAbsolutePath()) + "': " + unsupportedOperationException.getMessage());
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.7") + REG_FIELD_SEPARATOR + unsupportedOperationException.getMessage(), LoggerUtil.getCleanUserHomePath((String)file2.getPath()), null);
                bl = false;
                continue;
            }
            catch (Exception exception) {
                if ("es.gob.afirma.signers.xades.EFacturaAlreadySignedException".equals(exception.getClass().getName())) {
                    LOGGER.warning("La factura ya estaba firmada y no admite firmas adicionales '" + LoggerUtil.getCleanUserHomePath((String)file2.getAbsolutePath()) + "': " + exception);
                    this.addLogRegistry(Level.WARNING, MassiveSignMessages.getString("DirectorySignatureHelper.27"), LoggerUtil.getCleanUserHomePath((String)file2.getPath()), null);
                    bl = false;
                    continue;
                }
                LOGGER.severe("No ha sido posible firmar el fichero '" + LoggerUtil.getCleanUserHomePath((String)file2.getAbsolutePath()) + "': " + exception);
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.7"), LoggerUtil.getCleanUserHomePath((String)file2.getPath()), null);
                bl = false;
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LOGGER.severe("Error de falta de memoria durante la firma: " + outOfMemoryError);
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.8"), LoggerUtil.getCleanUserHomePath((String)file2.getPath()), null);
                bl = false;
                continue;
            }
            object = ".signed";
            if ((PDF_SIGNER.equals(object3) || ODF_SIGNER.equals(object3) || OOXML_SIGNER.equals(object3)) && aOSigner.isSign(byArray)) {
                object = ".cosign";
            }
            if ((string = this.saveSignToDirectory(file2.getPath(), (byte[])object2, file, aOSigner, (String)object)) == null) {
                bl = false;
                continue;
            }
            LOGGER.info("El fichero se ha firmado correctamente: " + LoggerUtil.getCleanUserHomePath((String)file2.getPath()));
            this.addLogRegistry(Level.INFO, MassiveSignMessages.getString("DirectorySignatureHelper.3"), file2.getPath(), string);
        }
        return bl;
    }

    private boolean massiveCosignOperation(File[] fileArray, File file, boolean bl, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) throws IOException {
        boolean bl2 = true;
        for (File file2 : fileArray) {
            byte[] byArray;
            String string;
            AOSigner aOSigner;
            boolean bl3;
            byte[] byArray2;
            Object object;
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                object = null;
                try {
                    byArray2 = AOUtil.getDataFromInputStream((InputStream)fileInputStream);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (fileInputStream != null) {
                        if (object != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                bl2 = false;
                continue;
            }
            properties.setProperty(URI_STR, file2.toURI().toASCIIString());
            if (this.defaultSigner.isSign(byArray2)) {
                bl3 = true;
                aOSigner = this.defaultSigner;
            } else if (bl) {
                aOSigner = DirectorySignatureHelper.getSpecificSigner(byArray2);
                if (aOSigner != null) {
                    bl3 = aOSigner.isSign(byArray2);
                } else {
                    aOSigner = AOSignerFactory.getSigner((byte[])byArray2);
                    if (aOSigner != null) {
                        bl3 = true;
                    } else {
                        bl3 = false;
                        aOSigner = this.defaultSigner;
                    }
                }
            } else {
                bl3 = false;
                aOSigner = this.defaultSigner;
            }
            if (bl3) {
                string = "cosign";
                byArray = this.cosign(aOSigner, byArray2, this.algorithm, privateKeyEntry, properties);
            } else {
                string = "sign";
                byArray = this.sign(aOSigner, byArray2, this.algorithm, privateKeyEntry, properties);
            }
            if (byArray == null) {
                bl2 = false;
                continue;
            }
            object = this.saveSignToDirectory(file2.getPath(), byArray, file, aOSigner, "." + string);
            if (object == null) {
                bl2 = false;
                continue;
            }
            LOGGER.info("Se ha operado (" + string + ") correctamente sobre el fichero '" + LoggerUtil.getCleanUserHomePath((String)file2.getPath()) + "'");
            this.addLogRegistry(Level.INFO, MassiveSignMessages.getString("DirectorySignatureHelper.10") + " (" + string + ")", file2.getPath(), (String)object);
        }
        return bl2;
    }

    private byte[] cosign(AOSigner aOSigner, byte[] byArray, String string, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) {
        byte[] byArray2;
        try {
            byArray2 = aOSigner.cosign(byArray, string, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain(), properties);
        }
        catch (Exception exception) {
            LOGGER.severe("No ha sido posible cofirmar el fichero '" + LoggerUtil.getCleanUserHomePath((String)properties.getProperty(URI_STR)) + "': " + exception);
            this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.11") + ": " + exception.getMessage(), LoggerUtil.getCleanUserHomePath((String)properties.getProperty(URI_STR)), null);
            byArray2 = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOGGER.severe("Error de falta de memoria durante la cofirma: " + outOfMemoryError);
            this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.8"), LoggerUtil.getCleanUserHomePath((String)properties.getProperty(URI_STR)), null);
            byArray2 = null;
        }
        return byArray2;
    }

    private byte[] sign(AOSigner aOSigner, byte[] byArray, String string, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) throws IOException {
        byte[] byArray2 = byArray;
        String string2 = aOSigner.getClass().getName();
        if (CADES_SIGNER.equals(string2) || XADES_SIGNER.equals(string2) || XMLDSIG_SIGNER.equals(string2)) {
            Object object;
            String string3;
            if ((XADES_SIGNER.equals(string2) || XMLDSIG_SIGNER.equals(string2)) && "explicit".equalsIgnoreCase(properties.getProperty(MODE_KEY))) {
                byArray2 = DirectorySignatureHelper.digest(byArray2);
                string3 = "hash/SHA-512".toLowerCase();
            } else {
                object = new MimeHelper(byArray2);
                string3 = object.getMimeType();
            }
            if (string3 != null) {
                properties.setProperty("mimeType", string3);
                object = MimeHelper.transformMimeTypeToOid((String)string3);
                if (object != null) {
                    properties.setProperty("contentTypeOid", (String)object);
                }
            }
        }
        try {
            return aOSigner.sign(byArray2, string, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain(), properties);
        }
        catch (Exception exception) {
            LOGGER.severe("No ha sido posible firmar el fichero de datos '" + LoggerUtil.getCleanUserHomePath((String)properties.getProperty(URI_STR)) + "': " + exception);
            this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.13") + ": " + exception.getMessage(), LoggerUtil.getCleanUserHomePath((String)properties.getProperty(URI_STR)), null);
            return null;
        }
    }

    private boolean massiveCounterSignOperation(MassiveType massiveType, File[] fileArray, File file, boolean bl, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) throws IOException {
        boolean bl2 = true;
        CounterSignTarget counterSignTarget = massiveType == MassiveType.COUNTERSIGN_ALL ? CounterSignTarget.TREE : CounterSignTarget.LEAFS;
        AOSigner aOSigner = this.defaultSigner;
        for (File file2 : fileArray) {
            byte[] byArray;
            Object object;
            block22: {
                if (bl) {
                    try {
                        aOSigner = DirectorySignatureHelper.getAppropiatedSigner(file2);
                    }
                    catch (Exception exception) {
                        this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.15") + ": " + exception.getMessage(), file2.getPath(), null);
                        bl2 = false;
                        continue;
                    }
                }
                if (DirectorySignatureHelper.isSign(aOSigner, file2)) {
                    try {
                        object = new FileInputStream(file2);
                        Throwable throwable = null;
                        try {
                            byte[] byArray2 = AOUtil.getDataFromInputStream((InputStream)object);
                            ((InputStream)object).close();
                            byArray = aOSigner.countersign(byArray2, this.algorithm, counterSignTarget, null, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain(), properties);
                            break block22;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)object).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((InputStream)object).close();
                                }
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        LOGGER.severe("No se ha encontrado el fichero '" + LoggerUtil.getCleanUserHomePath((String)file2.getPath()) + "': " + fileNotFoundException);
                        this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.24"), file2.getPath(), null);
                        bl2 = false;
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.severe("No ha sido posible contrafirmar el fichero '" + LoggerUtil.getCleanUserHomePath((String)file2.getPath()) + "': " + exception);
                        this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.15"), LoggerUtil.getCleanUserHomePath((String)file2.getPath()), null);
                        bl2 = false;
                        continue;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        LOGGER.severe("Error de falta de memoria durante la firma: " + outOfMemoryError);
                        this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.8"), LoggerUtil.getCleanUserHomePath((String)file2.getPath()), null);
                        bl2 = false;
                        continue;
                    }
                }
                LOGGER.severe("El fichero '" + file2 + "' no es un fichero de firma en formato '" + properties.getProperty(FORMAT_KEY) + "'");
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.16"), LoggerUtil.getCleanUserHomePath((String)file2.getPath()), null);
                bl2 = false;
                continue;
            }
            object = this.saveSignToDirectory(file2.getPath(), byArray, file, aOSigner, ".countersign");
            if (object == null) {
                bl2 = false;
                continue;
            }
            LOGGER.info("El fichero se ha contrafirmado correctamente: " + LoggerUtil.getCleanUserHomePath((String)file2.getPath()));
            this.addLogRegistry(Level.INFO, MassiveSignMessages.getString("DirectorySignatureHelper.20"), file2.getPath(), (String)object);
        }
        return bl2;
    }

    private String saveSignToDirectory(String string, byte[] byArray, File file, AOSigner aOSigner, String string2) {
        int n;
        String string3 = this.getRelativePath(string);
        String string4 = new File(file, string3).getName();
        File file2 = new File(file, string3).getParentFile();
        if (!file2.exists()) {
            n = 0;
            try {
                n = file2.mkdirs();
            }
            catch (Exception exception) {
                LOGGER.severe("Error al crearse la estructura de directorios del fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "': " + exception);
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.21"), null, string);
                return null;
            }
            if (n == 0) {
                LOGGER.severe("No se pudo crear la estructura de directorios del fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "'");
                this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.22"), null, string);
                return null;
            }
        }
        n = 0;
        File file3 = new File(file2, aOSigner.getSignedName(string4, string2 != null ? string2 : ""));
        while (file3.exists() && !this.overwriteFiles) {
            file3 = new File(file2, aOSigner.getSignedName(string4, (string2 != null ? string2 : "") + "(" + ++n + ")"));
        }
        if (!DirectorySignatureHelper.isParent(file2, file3)) {
            LOGGER.severe("No se pudo verificar que se fuese a guardar en un subdirectorio del directorio padre el fichero " + LoggerUtil.getCleanUserHomePath((String)string));
            this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.23"), null, string);
            return null;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            LOGGER.severe("No se pudo crear la estructura de directorios del fichero '" + LoggerUtil.getCleanUserHomePath((String)string) + "': " + exception);
            this.addLogRegistry(Level.SEVERE, MassiveSignMessages.getString("DirectorySignatureHelper.22"), null, file3.getPath());
        }
        this.signedFilenames.add(file3.getAbsolutePath());
        return file3.getAbsolutePath();
    }

    private static boolean isParent(File file, File file2) {
        File file3;
        File file4;
        try {
            file4 = file.getCanonicalFile();
        }
        catch (Exception exception) {
            return false;
        }
        for (file3 = file2.getCanonicalFile(); file3 != null && !file3.equals(file4); file3 = file3.getParentFile()) {
        }
        return file3 != null;
    }

    private static AOSigner getAppropiatedSigner(File file) throws IOException {
        AOSigner aOSigner = DirectorySignatureHelper.determineType(file);
        if (aOSigner == null) {
            throw new IllegalArgumentException("No se ha encontrado un manejador de firma valido para el fichero '" + file.getName() + "'");
        }
        return aOSigner;
    }

    private static boolean isSign(AOSigner aOSigner, File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            boolean bl = aOSigner.isSign(AOUtil.getDataFromInputStream((InputStream)fileInputStream));
            return bl;
        }
    }

    private static boolean isValidDataFile(AOSigner aOSigner, File file) throws IOException {
        byte[] byArray;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byArray = AOUtil.getDataFromInputStream((InputStream)fileInputStream);
        }
        try {
            return aOSigner.isValidDataFile(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("El fichero es demasiado grande: " + outOfMemoryError, outOfMemoryError);
        }
    }

    public void setActiveLog(boolean bl) {
        this.activeLog = bl;
    }

    public void setLogPath(String string) {
        this.logPath = string == null || string.trim().length() == 0 ? null : string;
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public boolean isActiveLog() {
        return this.activeLog;
    }

    private String getRelativePath(String string) {
        if (this.inDir != null) {
            return string.substring(this.inDir.length());
        }
        int n = string.indexOf(File.separator);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public AOSigner getDefaultSigner() {
        return this.defaultSigner;
    }

    public void setOverwritePreviuosFileSigns(boolean bl) {
        this.overwriteFiles = bl;
    }

    private void addLogRegistry(Level level, String string, String string2, String string3) {
        if (this.activeLog) {
            if (string == null) {
                LOGGER.warning("Se ha intentado insertar un registro nulo en el log");
                return;
            }
            if (this.logHandler != null) {
                try {
                    this.logHandler.addLog(level.intValue(), string, string2, string3);
                }
                catch (IOException iOException) {
                    LOGGER.warning("No se ha podido insertar un registro en el log de la operacion: " + string + ": " + iOException.toString());
                }
            }
            if (level == Level.WARNING) {
                ++this.warnCount;
            }
            if (level == Level.SEVERE) {
                ++this.errorCount;
            }
        }
    }

    protected static LogHandler initDefaultLogHandler(OutputStream outputStream) {
        return new DefaultLogHandler(outputStream);
    }

    private void closeLogRegistry() {
        if (this.logHandler != null) {
            Properties properties = new Properties();
            properties.setProperty("warningsCount", Integer.toString(this.warnCount));
            properties.setProperty("errorsCount", Integer.toString(this.errorCount));
            try {
                this.logHandler.close(properties);
            }
            catch (Exception exception) {
                LOGGER.warning("El fichero de log no se ha cerrado correctamente: " + exception);
            }
        }
        this.warnCount = 0;
        this.errorCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AOSigner determineType(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Se ha introducido un fichero de firma nulo");
        }
        if (!file.exists()) throw new FileNotFoundException("El archivo indicado no existe o no es un fichero de datos");
        if (!file.isFile()) {
            throw new FileNotFoundException("El archivo indicado no existe o no es un fichero de datos");
        }
        if (!file.canRead()) {
            throw new IOException("No tiene permisos de lectura sobre el fichero indicado");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            AOSigner aOSigner = AOSignerFactory.getSigner((byte[])AOUtil.getDataFromInputStream((InputStream)fileInputStream));
            return aOSigner;
        }
        catch (Exception exception) {
            throw new IOException("Error al leer el fichero: " + exception, exception);
        }
    }

    public String[] getSignedFilenames() {
        return this.signedFilenames.toArray(new String[0]);
    }

    private static AOSigner getSpecificSigner(byte[] byArray) throws IOException {
        String[] stringArray;
        for (String string : stringArray = new String[]{"Adobe PDF", "ODF (Open Document Format)", "OOXML (Office Open XML)"}) {
            AOSigner aOSigner = AOSignerFactory.getSigner((String)string);
            if (aOSigner == null || !aOSigner.isValidDataFile(byArray)) continue;
            return aOSigner;
        }
        return null;
    }

    private static byte[] digest(byte[] byArray) {
        if (md == null) {
            try {
                md = MessageDigest.getInstance(DEFAULT_MESSAGE_DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOGGER.severe("Se ha utilizado internamente un algoritmo de huella digital no soportado: " + noSuchAlgorithmException);
                throw new IllegalArgumentException("Algoritmo no soportado", noSuchAlgorithmException);
            }
        }
        return md.digest(byArray);
    }
}

