/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.massive;

import es.gob.afirma.massive.LogHandler;
import es.gob.afirma.massive.MassiveSignMessages;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DefaultLogHandler
extends LogHandler {
    private final OutputStream os;

    DefaultLogHandler(OutputStream outputStream) {
        this.os = outputStream;
    }

    @Override
    public void addLog(int n, String string, String string2, String string3) {
        try {
            this.os.write(("\r\n" + DefaultLogHandler.getLevel(n) + ": " + string + " - " + (string3 != null ? string3 : (string2 != null ? string2 : ""))).getBytes());
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.afirma").warning("No se pudo insertar una entrada en el log de la operacion masiva: " + exception);
        }
    }

    @Override
    public void close(Properties properties) throws IOException {
        String string = properties != null ? properties.getProperty("warningsCount", "0") : "0";
        String string2 = properties != null ? properties.getProperty("errorsCount", "0") : "0";
        this.os.write(("\r\n\r\n" + MassiveSignMessages.getString("DirectorySignatureHelper.25") + ": " + string).getBytes());
        this.os.write(("\r\n" + MassiveSignMessages.getString("DirectorySignatureHelper.26") + ": " + string2).getBytes());
    }

    private static String getLevel(int n) {
        if (n == Level.INFO.intValue()) {
            return Level.INFO.getName();
        }
        if (n == Level.WARNING.intValue()) {
            return Level.WARNING.getName();
        }
        return Level.SEVERE.getName();
    }
}

