/*
 * Decompiled with CFR 0.152.
 */
package eo.view.bluetoothstate.util;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u0004*\u00020\u00022\b\b\u0001\u0010\u0006\u001a\u00020\u0004H\u0001\u001a\u0016\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\b"}, d2={"getAvdWithAnimationCallback", "Landroid/graphics/drawable/Drawable;", "Landroid/content/Context;", "drawableRes", "", "getColorFromAttr", "attrRes", "getDrawableCompat", "bluetoothstate_release"})
public final class ContextUtilsKt {
    @NotNull
    public static final Drawable getDrawableCompat(@NotNull Context $receiver, @DrawableRes int drawableRes) {
        Drawable drawable2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Drawable drawable3 = drawable2 = AppCompatResources.getDrawable((Context)$receiver, (int)drawableRes);
        if (drawable3 == null) {
            throw (Throwable)new IllegalArgumentException("Cannot get drawable!");
        }
        return drawable3;
    }

    @NotNull
    public static final Drawable getAvdWithAnimationCallback(@NotNull Context $receiver, @DrawableRes int drawableRes) {
        Drawable drawable2;
        Drawable drawable3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        switch (Build.VERSION.SDK_INT) {
            case 21: 
            case 23: {
                drawable3 = (Drawable)AnimatedVectorDrawableCompat.create((Context)$receiver, (int)drawableRes);
                break;
            }
            default: {
                drawable3 = AppCompatResources.getDrawable((Context)$receiver, (int)drawableRes);
            }
        }
        Drawable drawable4 = drawable2 = drawable3;
        if (drawable4 == null) {
            throw (Throwable)new IllegalArgumentException("Cannot get drawable with animation callback!");
        }
        return drawable4;
    }

    @ColorInt
    public static final int getColorFromAttr(@NotNull Context $receiver, @AttrRes int attrRes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        TypedValue typedValue = new TypedValue();
        $receiver.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.resourceId == 0 ? typedValue.data : ContextCompat.getColor((Context)$receiver, (int)typedValue.resourceId);
    }
}

