/*
 * Decompiled with CFR 0.152.
 */
package eo.view.bluetoothstate.util;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a8\u0006\u0006"}, d2={"scaleToFit", "", "Landroid/graphics/drawable/Drawable;", "destRect", "Landroid/graphics/Rect;", "padding", "bluetoothstate_release"})
public final class DrawableUtilsKt {
    public static final void scaleToFit(@NotNull Drawable $receiver, @NotNull Rect destRect, @NotNull Rect padding) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)destRect, (String)"destRect");
        Intrinsics.checkParameterIsNotNull((Object)padding, (String)"padding");
        if (destRect.isEmpty() || destRect.height() == 0) {
            $receiver.setBounds(destRect);
        }
        int availableWidth = destRect.width() - padding.left - padding.right;
        int availableHeight = destRect.height() - padding.top - padding.bottom;
        float availableAspectRatio = (float)availableWidth / (float)availableHeight;
        float drawableAspectRatio = (float)$receiver.getIntrinsicWidth() / (float)$receiver.getIntrinsicHeight();
        int drawableWidth = availableWidth;
        int drawableHeight = availableHeight;
        if (availableAspectRatio > drawableAspectRatio) {
            drawableWidth = (int)((float)availableHeight * drawableAspectRatio);
        } else {
            drawableHeight = (int)((float)availableWidth / drawableAspectRatio);
        }
        int drawableOffsetX = padding.left + (availableWidth - drawableWidth) / 2;
        int drawableOffsetY = padding.top + (availableHeight - drawableHeight) / 2;
        $receiver.setBounds(drawableOffsetX, drawableOffsetY, drawableOffsetX + drawableWidth, drawableOffsetY + drawableHeight);
    }
}

