/*
 * Decompiled with CFR 0.152.
 */
package eo.view.bluetoothstate;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import eo.view.bluetoothstate.BluetoothState;
import eo.view.bluetoothstate.BluetoothStateDrawable;
import eo.view.bluetoothstate.BluetoothStateDrawable$WhenMappings;
import eo.view.bluetoothstate.R;
import eo.view.bluetoothstate.util.ContextUtilsKt;
import eo.view.bluetoothstate.util.DrawableUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0012*\u0001\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000fH\u0016J\b\u0010*\u001a\u00020\u000fH\u0016J\b\u0010+\u001a\u00020\u000fH\u0016J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u001aH\u0016J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u001aH\u0014J\u0010\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\u0001H\u0002J\u0010\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020\u000fH\u0016J\u0012\u00104\u001a\u00020&2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u00020&H\u0002J\b\u00108\u001a\u00020&H\u0002J\u0012\u00109\u001a\u00020&2\b\b\u0001\u0010:\u001a\u00020\u000fH\u0002J\b\u0010;\u001a\u00020&H\u0002J\b\u0010<\u001a\u00020&H\u0002J\u0012\u0010=\u001a\u00020&2\b\b\u0001\u0010:\u001a\u00020\u000fH\u0002J&\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000fJ\b\u0010C\u001a\u00020&H\u0002J\b\u0010D\u001a\u00020&H\u0002J\u0012\u0010E\u001a\u00020&2\b\b\u0001\u0010F\u001a\u00020\u000fH\u0002J\b\u0010G\u001a\u00020&H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR&\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u001b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006H"}, d2={"Leo/view/bluetoothstate/BluetoothStateDrawable;", "Landroid/graphics/drawable/Drawable;", "Leo/view/bluetoothstate/BluetoothState;", "context", "Landroid/content/Context;", "theme", "Leo/view/bluetoothstate/BluetoothState$Theme;", "(Landroid/content/Context;Leo/view/bluetoothstate/BluetoothState$Theme;)V", "animateStateChanges", "", "getAnimateStateChanges", "()Z", "setAnimateStateChanges", "(Z)V", "value", "", "color", "getColor", "()I", "setColor", "(I)V", "drawable", "drawableCallback", "eo/view/bluetoothstate/BluetoothStateDrawable$drawableCallback$1", "Leo/view/bluetoothstate/BluetoothStateDrawable$drawableCallback$1;", "padding", "Landroid/graphics/Rect;", "Leo/view/bluetoothstate/BluetoothState$State;", "state", "getState", "()Leo/view/bluetoothstate/BluetoothState$State;", "setState", "(Leo/view/bluetoothstate/BluetoothState$State;)V", "getTheme", "()Leo/view/bluetoothstate/BluetoothState$Theme;", "setTheme", "(Leo/view/bluetoothstate/BluetoothState$Theme;)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "getPadding", "paddingOut", "onBoundsChange", "bounds", "replaceDrawable", "newDrawable", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setConnectedStateDrawable", "setConnectingStateDrawable", "setInfiniteAnimatedVectorDrawable", "avdRes", "setOffStateDrawable", "setOnStateDrawable", "setOneShotAnimatedVectorDrawable", "setPadding", "left", "top", "right", "bottom", "setSearchStateDrawable", "setSearchingStateDrawable", "setVectorDrawable", "vdRes", "updateDrawableForCurrentStateAndTheme", "bluetoothstate_release"})
public final class BluetoothStateDrawable
extends Drawable
implements BluetoothState {
    private Drawable drawable;
    private final Rect padding;
    private final drawableCallback.1 drawableCallback;
    @NotNull
    private BluetoothState.Theme theme;
    @ColorInt
    private int color;
    @NotNull
    private BluetoothState.State state;
    private boolean animateStateChanges;
    private final Context context;

    @Override
    @NotNull
    public BluetoothState.Theme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(@NotNull BluetoothState.Theme value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (this.theme != value) {
            this.theme = value;
            this.updateDrawableForCurrentStateAndTheme();
        }
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int value) {
        this.color = value;
        DrawableCompat.setTint((Drawable)this.drawable, (int)value);
        this.invalidateSelf();
    }

    @Override
    @NotNull
    public BluetoothState.State getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull BluetoothState.State value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.state = value;
        this.updateDrawableForCurrentStateAndTheme();
    }

    @Override
    public boolean getAnimateStateChanges() {
        return this.animateStateChanges;
    }

    @Override
    public void setAnimateStateChanges(boolean bl) {
        this.animateStateChanges = bl;
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        DrawableUtilsKt.scaleToFit(this.drawable, bounds, this.padding);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawable.draw(canvas);
    }

    public int getIntrinsicHeight() {
        return this.drawable.getIntrinsicHeight();
    }

    public int getIntrinsicWidth() {
        return this.drawable.getIntrinsicWidth();
    }

    public void setAlpha(int alpha) {
        this.drawable.setAlpha(alpha);
    }

    public int getOpacity() {
        return this.drawable.getOpacity();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.drawable.setColorFilter(colorFilter);
    }

    public boolean getPadding(@NotNull Rect paddingOut) {
        Intrinsics.checkParameterIsNotNull((Object)paddingOut, (String)"paddingOut");
        if (this.padding.left == 0 && this.padding.top == 0 && this.padding.right == 0 && this.padding.bottom == 0) {
            return super.getPadding(this.padding);
        }
        paddingOut.set(this.padding);
        return true;
    }

    public final void setPadding(int left, int top, int right, int bottom) {
        this.padding.set(left, top, right, bottom);
        Rect rect = this.getBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
        DrawableUtilsKt.scaleToFit(this.drawable, rect, this.padding);
    }

    private final void updateDrawableForCurrentStateAndTheme() {
        switch (BluetoothStateDrawable$WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
            case 1: {
                this.setOnStateDrawable();
                break;
            }
            case 2: {
                this.setOffStateDrawable();
                break;
            }
            case 3: {
                this.setSearchStateDrawable();
                break;
            }
            case 4: {
                this.setSearchingStateDrawable();
                break;
            }
            case 5: {
                this.setConnectingStateDrawable();
                break;
            }
            case 6: {
                this.setConnectedStateDrawable();
            }
        }
    }

    private final void setOnStateDrawable() {
        if (this.getAnimateStateChanges()) {
            this.setOneShotAnimatedVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.avd_bluetooth_turning_on_rounded : R.drawable.avd_bluetooth_turning_on_sharp);
        } else {
            this.setVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.vd_bluetooth_on_rounded : R.drawable.vd_bluetooth_on_sharp);
        }
    }

    private final void setOffStateDrawable() {
        if (this.getAnimateStateChanges()) {
            this.setOneShotAnimatedVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.avd_bluetooth_turning_off_rounded : R.drawable.avd_bluetooth_turning_off_sharp);
        } else {
            this.setVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.vd_bluetooth_off_rounded : R.drawable.vd_bluetooth_off_sharp);
        }
    }

    private final void setSearchStateDrawable() {
        this.setVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.vd_bluetooth_search_rounded : R.drawable.vd_bluetooth_search_sharp);
    }

    private final void setSearchingStateDrawable() {
        this.setInfiniteAnimatedVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.avd_bluetooth_searching_rounded : R.drawable.avd_bluetooth_searching_sharp);
    }

    private final void setConnectingStateDrawable() {
        this.setInfiniteAnimatedVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.avd_bluetooth_connecting_rounded : R.drawable.avd_bluetooth_connecting_sharp);
    }

    private final void setConnectedStateDrawable() {
        this.setVectorDrawable(this.getTheme() == BluetoothState.Theme.ROUNDED ? R.drawable.vd_bluetooth_connected_rounded : R.drawable.vd_bluetooth_connected_sharp);
    }

    private final void setVectorDrawable(@DrawableRes int vdRes) {
        VectorDrawableCompat vd = ContextUtilsKt.createVectorDrawable(this.context, vdRes);
        Drawable drawable2 = (Drawable)vd;
        Rect rect = this.getBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
        DrawableUtilsKt.scaleToFit(drawable2, rect, this.padding);
        this.replaceDrawable((Drawable)vd);
        this.invalidateSelf();
    }

    private final void setOneShotAnimatedVectorDrawable(@DrawableRes int avdRes) {
        AnimatedVectorDrawableCompat avd = ContextUtilsKt.createAnimatedVectorDrawable(this.context, avdRes);
        Drawable drawable2 = (Drawable)avd;
        Rect rect = this.getBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
        DrawableUtilsKt.scaleToFit(drawable2, rect, this.padding);
        this.replaceDrawable((Drawable)avd);
        avd.start();
        this.invalidateSelf();
    }

    private final void setInfiniteAnimatedVectorDrawable(@DrawableRes int avdRes) {
        AnimatedVectorDrawableCompat avd = ContextUtilsKt.createAnimatedVectorDrawable(this.context, avdRes);
        Drawable drawable2 = (Drawable)avd;
        Rect rect = this.getBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
        DrawableUtilsKt.scaleToFit(drawable2, rect, this.padding);
        avd.registerAnimationCallback(new Animatable2Compat.AnimationCallback(this, avd){
            final /* synthetic */ BluetoothStateDrawable this$0;
            final /* synthetic */ AnimatedVectorDrawableCompat $avd;

            public void onAnimationEnd(@Nullable Drawable drawable2) {
                this.this$0.scheduleSelf(new Runnable(this){
                    final /* synthetic */ setInfiniteAnimatedVectorDrawable.1 this$0;

                    public final void run() {
                        this.this$0.$avd.start();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, 0L);
            }
            {
                this.this$0 = $outer;
                this.$avd = $captured_local_variable$1;
            }
        });
        this.replaceDrawable((Drawable)avd);
        avd.start();
        this.invalidateSelf();
    }

    private final void replaceDrawable(Drawable newDrawable) {
        if (Build.VERSION.SDK_INT >= 21) {
            newDrawable.setColorFilter(this.drawable.getColorFilter());
        }
        DrawableCompat.setTint((Drawable)newDrawable, (int)this.getColor());
        newDrawable.setAlpha(this.drawable.getAlpha());
        this.drawable.setCallback((Drawable.Callback)null);
        this.drawable = newDrawable;
        this.drawable.setCallback((Drawable.Callback)this.drawableCallback);
    }

    public BluetoothStateDrawable(@NotNull Context context, @NotNull BluetoothState.Theme theme) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)theme), (String)"theme");
        this.context = context;
        this.padding = new Rect();
        this.drawableCallback = new Drawable.Callback(this){
            final /* synthetic */ BluetoothStateDrawable this$0;

            public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
                Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
                Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
                this.this$0.unscheduleSelf(what);
            }

            public void invalidateDrawable(@NotNull Drawable who) {
                Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
                this.this$0.invalidateSelf();
            }

            public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
                Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
                Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
                this.this$0.scheduleSelf(what, when);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.theme = theme;
        this.color = -16777216;
        this.state = BluetoothState.State.ON;
        this.animateStateChanges = true;
        this.drawable = (Drawable)ContextUtilsKt.createVectorDrawable(this.context, theme == BluetoothState.Theme.ROUNDED ? R.drawable.vd_bluetooth_on_rounded : R.drawable.vd_bluetooth_on_sharp);
        this.setColor(ContextUtilsKt.getColorFromAttr(this.context, R.attr.colorControlNormal));
    }

    public /* synthetic */ BluetoothStateDrawable(Context context, BluetoothState.Theme theme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            theme = BluetoothState.Theme.ROUNDED;
        }
        this(context, theme);
    }
}

