/*
 * Decompiled with CFR 0.152.
 */
package eo.view.batterymeter;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import eo.view.batterymeter.BatteryMeter;
import eo.view.batterymeter.BatteryMeterDrawable$WhenMappings;
import eo.view.batterymeter.R;
import eo.view.batterymeter.util.CanvasUtilsKt;
import eo.view.batterymeter.util.ColorUtilsKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 h2\u00020\u00012\u00020\u0002:\u0001hB\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020\u0016H\u0016J\b\u0010L\u001a\u00020\u0016H\u0016J\b\u0010M\u001a\u00020\u0016H\u0016J\u0010\u0010N\u001a\u0002052\u0006\u0010:\u001a\u00020\u0014H\u0016J\b\u0010O\u001a\u00020HH\u0002J\u0010\u0010P\u001a\u00020H2\u0006\u0010Q\u001a\u00020\u0014H\u0014J\u0018\u0010R\u001a\u00020H2\u0006\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020\u0012H\u0002J\u0010\u0010U\u001a\u00020H2\u0006\u0010V\u001a\u00020\u0016H\u0016J\u0012\u0010W\u001a\u00020H2\b\u0010X\u001a\u0004\u0018\u00010YH\u0016J&\u0010Z\u001a\u00020H2\u0006\u0010[\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\u00162\u0006\u0010]\u001a\u00020\u00162\u0006\u0010^\u001a\u00020\u0016J\b\u0010_\u001a\u00020HH\u0002J\b\u0010`\u001a\u00020HH\u0002J\b\u0010a\u001a\u00020HH\u0002J\b\u0010b\u001a\u00020HH\u0002J\b\u0010c\u001a\u00020HH\u0002J\u0010\u0010d\u001a\u00020\u000b2\u0006\u0010e\u001a\u00020\u000bH\u0002J\u0010\u0010f\u001a\u00020\u000b2\u0006\u0010g\u001a\u00020\u000bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u0016@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010 \u001a\u0004\u0018\u00010\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u0016@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b!\u0010\u0019\"\u0004\b\"\u0010\u001bR\u000e\u0010#\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0016@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010)\u001a\u0004\u0018\u00010\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u0016@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b*\u0010\u0019\"\u0004\b+\u0010\u001bR*\u0010,\u001a\u0004\u0018\u00010\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u0016@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b-\u0010\u0019\"\u0004\b.\u0010\u001bR$\u0010/\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010&\"\u0004\b1\u0010(R\u000e\u00102\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u0002052\u0006\u0010\n\u001a\u000205@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010:\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R*\u0010?\u001a\u0004\u0018\u00010\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u0016@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b@\u0010\u0019\"\u0004\bA\u0010\u001bR\u000e\u0010B\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Leo/view/batterymeter/BatteryMeterDrawable;", "Landroid/graphics/drawable/Drawable;", "Leo/view/batterymeter/BatteryMeter;", "context", "Landroid/content/Context;", "theme", "Leo/view/batterymeter/BatteryMeter$Theme;", "(Landroid/content/Context;Leo/view/batterymeter/BatteryMeter$Theme;)V", "alertIndicatorDataStream", "Ljava/io/DataInputStream;", "value", "", "aspectRatio", "setAspectRatio", "(F)V", "batteryPaint", "Landroid/graphics/Paint;", "batteryPath", "Landroid/graphics/Path;", "batteryShapeBounds", "Landroid/graphics/Rect;", "batteryShapeDataStream", "", "chargeLevel", "getChargeLevel", "()Ljava/lang/Integer;", "setChargeLevel", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "chargeLevelClipRect", "Landroid/graphics/RectF;", "chargeLevelPaint", "chargingColor", "getChargingColor", "setChargingColor", "chargingIndicatorDataStream", "color", "getColor", "()I", "setColor", "(I)V", "criticalChargeLevel", "getCriticalChargeLevel", "setCriticalChargeLevel", "criticalColor", "getCriticalColor", "setCriticalColor", "indicatorColor", "getIndicatorColor", "setIndicatorColor", "indicatorPaint", "indicatorPath", "intrinsicSize", "", "isCharging", "()Z", "setCharging", "(Z)V", "padding", "getTheme", "()Leo/view/batterymeter/BatteryMeter$Theme;", "setTheme", "(Leo/view/batterymeter/BatteryMeter$Theme;)V", "unknownColor", "getUnknownColor", "setUnknownColor", "unknownIndicatorDataStream", "createShapeDataInputStream", "input", "rawBytes", "", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "getPadding", "loadThemeShapes", "onBoundsChange", "bounds", "performPathCommands", "pathDataStream", "path", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setPadding", "left", "top", "right", "bottom", "updateBatteryPath", "updateBatteryShapeBounds", "updateChargeLevelClipRect", "updateIndicatorPath", "updatePaintColors", "xRatioToCoordinate", "xRatio", "yRatioToCoordinate", "yRatio", "Companion", "batterymeter_release"})
public final class BatteryMeterDrawable
extends Drawable
implements BatteryMeter {
    private final Rect padding;
    private final Rect batteryShapeBounds;
    private final Path batteryPath;
    private final Path indicatorPath;
    private final RectF chargeLevelClipRect;
    private final int intrinsicSize;
    private float aspectRatio;
    private DataInputStream batteryShapeDataStream;
    private DataInputStream alertIndicatorDataStream;
    private DataInputStream chargingIndicatorDataStream;
    private DataInputStream unknownIndicatorDataStream;
    private final Paint batteryPaint;
    private final Paint chargeLevelPaint;
    private final Paint indicatorPaint;
    @NotNull
    private BatteryMeter.Theme theme;
    @Nullable
    private Integer chargeLevel;
    private boolean isCharging;
    @Nullable
    private Integer criticalChargeLevel;
    private int color;
    @Nullable
    private Integer chargingColor;
    @Nullable
    private Integer criticalColor;
    @Nullable
    private Integer unknownColor;
    private final Context context;
    public static final int MINIMUM_CHARGE_LEVEL = 0;
    public static final int MAXIMUM_CHARGE_LEVEL = 100;
    public static final float BATTERY_COLOR_ALPHA = 0.3f;
    public static final int CRITICAL_CHARGE_LEVEL = 10;
    public static final Companion Companion = new Companion(null);

    private final void setAspectRatio(float value) {
        if (this.aspectRatio != value) {
            this.aspectRatio = value;
            this.updateBatteryShapeBounds();
        }
    }

    @Override
    @NotNull
    public BatteryMeter.Theme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(@NotNull BatteryMeter.Theme value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (this.theme != value) {
            this.theme = value;
            this.loadThemeShapes();
            this.updateBatteryPath();
            this.updateIndicatorPath();
            this.invalidateSelf();
        }
    }

    @Override
    @Nullable
    public Integer getChargeLevel() {
        return this.chargeLevel;
    }

    @Override
    public void setChargeLevel(@Nullable Integer value) {
        Integer newChargeLevel;
        Integer n = value;
        Integer n2 = newChargeLevel = n != null ? Integer.valueOf(RangesKt.coerceIn((int)n, (int)0, (int)100)) : null;
        if (Intrinsics.areEqual((Object)this.chargeLevel, (Object)newChargeLevel) ^ true) {
            this.chargeLevel = newChargeLevel;
            this.updateIndicatorPath();
            this.updateChargeLevelClipRect();
            this.updatePaintColors();
            this.invalidateSelf();
        }
    }

    @Override
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public void setCharging(boolean value) {
        if (this.isCharging != value) {
            this.isCharging = value;
            this.updateIndicatorPath();
            this.updatePaintColors();
            this.invalidateSelf();
        }
    }

    @Override
    @Nullable
    public Integer getCriticalChargeLevel() {
        return this.criticalChargeLevel;
    }

    @Override
    public void setCriticalChargeLevel(@Nullable Integer value) {
        Integer newCriticalChargeLevel;
        Integer n = value;
        Integer n2 = newCriticalChargeLevel = n != null ? Integer.valueOf(RangesKt.coerceIn((int)n, (int)0, (int)100)) : null;
        if (Intrinsics.areEqual((Object)this.criticalChargeLevel, (Object)newCriticalChargeLevel) ^ true) {
            this.criticalChargeLevel = newCriticalChargeLevel;
            this.updateIndicatorPath();
            this.updatePaintColors();
            this.invalidateSelf();
        }
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int value) {
        if (this.color != value) {
            this.color = value;
            this.updatePaintColors();
            this.invalidateSelf();
        }
    }

    @Override
    @Nullable
    public Integer getChargingColor() {
        return this.chargingColor;
    }

    @Override
    public void setChargingColor(@Nullable Integer value) {
        if (Intrinsics.areEqual((Object)this.chargingColor, (Object)value) ^ true) {
            this.chargingColor = value;
            this.updatePaintColors();
            this.invalidateSelf();
        }
    }

    @Override
    @Nullable
    public Integer getCriticalColor() {
        return this.criticalColor;
    }

    @Override
    public void setCriticalColor(@Nullable Integer value) {
        if (Intrinsics.areEqual((Object)this.criticalColor, (Object)value) ^ true) {
            this.criticalColor = value;
            this.updatePaintColors();
            this.invalidateSelf();
        }
    }

    @Override
    @Nullable
    public Integer getUnknownColor() {
        return this.unknownColor;
    }

    @Override
    public void setUnknownColor(@Nullable Integer value) {
        if (Intrinsics.areEqual((Object)this.unknownColor, (Object)value) ^ true) {
            this.unknownColor = value;
            this.updatePaintColors();
            this.invalidateSelf();
        }
    }

    @Override
    public int getIndicatorColor() {
        return this.indicatorPaint.getColor();
    }

    @Override
    public void setIndicatorColor(int value) {
        this.indicatorPaint.setColor(value);
        this.invalidateSelf();
    }

    public int getIntrinsicWidth() {
        return (this.aspectRatio < 1.0f ? (int)((float)this.intrinsicSize * this.aspectRatio) : this.intrinsicSize) + this.padding.left + this.padding.right;
    }

    public int getIntrinsicHeight() {
        return (this.aspectRatio < 1.0f ? this.intrinsicSize : (int)((float)this.intrinsicSize / this.aspectRatio)) + this.padding.top + this.padding.bottom;
    }

    public boolean getPadding(@NotNull Rect padding) {
        Intrinsics.checkParameterIsNotNull((Object)padding, (String)"padding");
        if (padding.left == 0 && padding.top == 0 && padding.right == 0 && padding.bottom == 0) {
            return super.getPadding(padding);
        }
        padding.set(this.padding);
        return true;
    }

    public final void setPadding(int left, int top, int right, int bottom) {
        this.padding.set(left, top, right, bottom);
        this.updateBatteryShapeBounds();
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        this.updateBatteryShapeBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Canvas $receiver$iv = canvas;
        int checkpoint$iv = $receiver$iv.save();
        try {
            Canvas $receiver = $receiver$iv;
            if (!this.indicatorPath.isEmpty()) {
                $receiver.drawPath(this.indicatorPath, this.indicatorPaint);
                CanvasUtilsKt.clipOutPathCompat($receiver, this.indicatorPath);
            }
            $receiver.drawPath(this.batteryPath, this.batteryPaint);
            if (!this.chargeLevelClipRect.isEmpty()) {
                $receiver.clipRect(this.chargeLevelClipRect);
                $receiver.drawPath(this.batteryPath, this.chargeLevelPaint);
            }
        }
        finally {
            $receiver$iv.restoreToCount(checkpoint$iv);
        }
    }

    public void setAlpha(int alpha) {
    }

    public int getOpacity() {
        return -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.batteryPaint.setColorFilter(colorFilter);
        this.chargeLevelPaint.setColorFilter(colorFilter);
        this.indicatorPaint.setColorFilter(colorFilter);
    }

    private final void updateBatteryShapeBounds() {
        int availableHeight;
        Rect rect = this.getBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
        if (rect.isEmpty()) {
            return;
        }
        int availableWidth = this.getBounds().width() - this.padding.left - this.padding.right;
        float availableAspectRatio = (float)availableWidth / (float)(availableHeight = this.getBounds().height() - this.padding.top - this.padding.bottom);
        if (availableAspectRatio > this.aspectRatio) {
            this.batteryShapeBounds.set(0, 0, (int)((float)availableHeight * this.aspectRatio), availableHeight);
        } else {
            this.batteryShapeBounds.set(0, 0, availableWidth, (int)((float)availableWidth / this.aspectRatio));
        }
        this.batteryShapeBounds.offset(this.padding.left + (availableWidth - this.batteryShapeBounds.width()) / 2, this.padding.top + (availableHeight - this.batteryShapeBounds.height()) / 2);
        this.updateBatteryPath();
        this.updateIndicatorPath();
        this.updateChargeLevelClipRect();
    }

    private final void updateBatteryPath() {
        DataInputStream dataInputStream = this.batteryShapeDataStream;
        if (dataInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"batteryShapeDataStream");
        }
        this.performPathCommands(dataInputStream, this.batteryPath);
    }

    private final void updateIndicatorPath() {
        Integer currentLevel = this.getChargeLevel();
        Integer currentCriticalLevel = this.getCriticalChargeLevel();
        if (currentLevel == null) {
            DataInputStream dataInputStream = this.unknownIndicatorDataStream;
            if (dataInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"unknownIndicatorDataStream");
            }
            this.performPathCommands(dataInputStream, this.indicatorPath);
        } else if (this.isCharging()) {
            DataInputStream dataInputStream = this.chargingIndicatorDataStream;
            if (dataInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chargingIndicatorDataStream");
            }
            this.performPathCommands(dataInputStream, this.indicatorPath);
        } else if (currentCriticalLevel != null && Intrinsics.compare((int)currentLevel, (int)currentCriticalLevel) <= 0) {
            DataInputStream dataInputStream = this.alertIndicatorDataStream;
            if (dataInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndicatorDataStream");
            }
            this.performPathCommands(dataInputStream, this.indicatorPath);
        } else {
            this.indicatorPath.reset();
        }
    }

    private final void updateChargeLevelClipRect() {
        Integer n = this.getChargeLevel();
        int level = n != null ? n : 0;
        this.chargeLevelClipRect.set(this.batteryShapeBounds);
        this.chargeLevelClipRect.top += this.chargeLevelClipRect.height() * (1.0f - (float)level / (float)100);
    }

    private final void updatePaintColors() {
        block2: {
            Integer currentCriticalLevel;
            Integer currentLevel;
            block3: {
                block1: {
                    currentLevel = this.getChargeLevel();
                    currentCriticalLevel = this.getCriticalChargeLevel();
                    this.chargeLevelPaint.setColor(this.getColor());
                    this.batteryPaint.setColor(ColorUtilsKt.colorWithAlpha(this.getColor(), 0.3f));
                    if (currentLevel != null) break block1;
                    Integer n = this.getUnknownColor();
                    this.batteryPaint.setColor(n != null ? n.intValue() : this.getColor());
                    break block2;
                }
                if (!this.isCharging()) break block3;
                Integer n = this.getChargingColor();
                if (n == null) break block2;
                Integer n2 = n;
                int it = ((Number)n2).intValue();
                this.chargeLevelPaint.setColor(it);
                this.batteryPaint.setColor(ColorUtilsKt.colorWithAlpha(it, 0.3f));
                break block2;
            }
            if (currentCriticalLevel == null || Intrinsics.compare((int)currentLevel, (int)currentCriticalLevel) > 0) break block2;
            Integer n = this.getCriticalColor();
            if (n != null) {
                Integer n3 = n;
                int it = ((Number)n3).intValue();
                this.chargeLevelPaint.setColor(it);
                this.batteryPaint.setColor(ColorUtilsKt.colorWithAlpha(it, 0.3f));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadThemeShapes() {
        int n;
        switch (BatteryMeterDrawable$WhenMappings.$EnumSwitchMapping$0[this.getTheme().ordinal()]) {
            case 1: {
                n = R.raw.battery_shapes_sharp;
                break;
            }
            case 2: {
                n = R.raw.battery_shapes_rounded;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int rawResourceId = n;
        InputStream inputStream = this.context.getResources().openRawResource(rawResourceId);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.resources.openRawResource(rawResourceId)");
        byte[] rawBytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        Closeable closeable = new DataInputStream(new ByteArrayInputStream(rawBytes));
        Throwable throwable = null;
        try {
            DataInputStream input = (DataInputStream)closeable;
            float newAspectRatio = input.readFloat();
            this.batteryShapeDataStream = this.createShapeDataInputStream(input, rawBytes);
            this.alertIndicatorDataStream = this.createShapeDataInputStream(input, rawBytes);
            this.chargingIndicatorDataStream = this.createShapeDataInputStream(input, rawBytes);
            this.unknownIndicatorDataStream = this.createShapeDataInputStream(input, rawBytes);
            this.setAspectRatio(newAspectRatio);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final DataInputStream createShapeDataInputStream(DataInputStream input, byte[] rawBytes) {
        int shapeBytesCount = input.readInt();
        int shapeBytesOffset = rawBytes.length - input.available();
        DataInputStream shapeDataInputStream = new DataInputStream(new ByteArrayInputStream(rawBytes, shapeBytesOffset, shapeBytesCount));
        input.skipBytes(shapeBytesCount);
        return shapeDataInputStream;
    }

    private final void performPathCommands(DataInputStream pathDataStream, Path path) {
        path.reset();
        pathDataStream.reset();
        while (pathDataStream.available() > 0) {
            char command = pathDataStream.readChar();
            switch (command) {
                case 'C': {
                    path.cubicTo(this.xRatioToCoordinate(pathDataStream.readFloat()), this.yRatioToCoordinate(pathDataStream.readFloat()), this.xRatioToCoordinate(pathDataStream.readFloat()), this.yRatioToCoordinate(pathDataStream.readFloat()), this.xRatioToCoordinate(pathDataStream.readFloat()), this.yRatioToCoordinate(pathDataStream.readFloat()));
                    break;
                }
                case 'L': {
                    path.lineTo(this.xRatioToCoordinate(pathDataStream.readFloat()), this.yRatioToCoordinate(pathDataStream.readFloat()));
                    break;
                }
                case 'M': {
                    path.moveTo(this.xRatioToCoordinate(pathDataStream.readFloat()), this.yRatioToCoordinate(pathDataStream.readFloat()));
                    break;
                }
                case 'Z': {
                    path.close();
                }
            }
        }
    }

    private final float xRatioToCoordinate(float xRatio) {
        return (float)this.batteryShapeBounds.left + xRatio * (float)this.batteryShapeBounds.width();
    }

    private final float yRatioToCoordinate(float yRatio) {
        return (float)this.batteryShapeBounds.top + yRatio * (float)this.batteryShapeBounds.height();
    }

    @JvmOverloads
    public BatteryMeterDrawable(@NotNull Context context, @NotNull BatteryMeter.Theme theme) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)theme), (String)"theme");
        this.context = context;
        this.padding = new Rect();
        this.batteryShapeBounds = new Rect();
        this.batteryPath = new Path();
        this.indicatorPath = new Path();
        this.chargeLevelClipRect = new RectF();
        this.intrinsicSize = this.context.getResources().getDimensionPixelSize(R.dimen.battery_meter_intrinsic_size);
        this.aspectRatio = 1.0f;
        Paint paint2 = new Paint(1);
        BatteryMeterDrawable batteryMeterDrawable = this;
        Paint $receiver = paint2;
        $receiver.setStyle(Paint.Style.FILL);
        batteryMeterDrawable.batteryPaint = paint = paint2;
        paint2 = new Paint(1);
        batteryMeterDrawable = this;
        $receiver = paint2;
        $receiver.setStyle(Paint.Style.FILL);
        batteryMeterDrawable.chargeLevelPaint = paint = paint2;
        paint2 = new Paint();
        batteryMeterDrawable = this;
        $receiver = paint2;
        $receiver.setAntiAlias(true);
        $receiver.setStyle(Paint.Style.FILL);
        $receiver.setColor(0);
        batteryMeterDrawable.indicatorPaint = paint = paint2;
        this.theme = theme;
        this.criticalChargeLevel = 10;
        this.color = ColorUtilsKt.getColorAttr(this.context, 0x1010030);
        this.loadThemeShapes();
    }

    @JvmOverloads
    public /* synthetic */ BatteryMeterDrawable(Context context, BatteryMeter.Theme theme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            theme = BatteryMeter.Theme.SHARP;
        }
        this(context, theme);
    }

    @JvmOverloads
    public BatteryMeterDrawable(@NotNull Context context) {
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Leo/view/batterymeter/BatteryMeterDrawable$Companion;", "", "()V", "BATTERY_COLOR_ALPHA", "", "CRITICAL_CHARGE_LEVEL", "", "MAXIMUM_CHARGE_LEVEL", "MINIMUM_CHARGE_LEVEL", "batterymeter_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

