/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceExceptionService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NativeCrashData;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.NetworkConnectivityService;
import io.embrace.android.embracesdk.OrientationService;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.StartupEventInfo;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class EmbraceSessionService
implements SessionService,
ActivityListener {
    public static final String APPLICATION_STATE_ACTIVE = "active";
    public static final String APPLICATION_STATE_BACKGROUND = "background";
    static Long minSessionTime = 5000L;
    private static final String SESSION_START_TYPE = "st";
    private static final String SESSION_END_TYPE = "en";
    private static final String SESSION_FILE_NAME = "last_session.json";
    private static final String PREVIOUS_SESSION_FILE_NAME = "previous_session.json";
    private static final int SESSION_CACHING_INTERVAL = 2;
    private static final int SEND_SESSION_API_CLIENT_TIMEOUT = 2;
    private final Object lock = new Object();
    private long sdkStartupDuration = 0L;
    private final PreferencesService preferencesService;
    private final PerformanceInfoService performanceInfoService;
    private final MetadataService metadataService;
    private final NetworkConnectivityService networkConnectivityService;
    private final BreadcrumbService breadcrumbService;
    private final PowerService powerService;
    private final ActivityService activityService;
    private final ApiClient apiClient;
    private final EventService eventService;
    private final EmbraceRemoteLogger remoteLogger;
    private final UserService userService;
    private final ConfigService configService;
    private final CacheService cacheService;
    private final EmbraceExceptionService exceptionService;
    private final LocalConfig localConfig;
    private final MemoryCleanerService memoryCleanerService;
    private final OrientationService orientationService;
    private final NdkService ndkService;
    private final BackgroundWorker sessionBackgroundWorker;
    private final BackgroundWorker nativeCrashSendBackgroundWorker;
    private final BackgroundWorker nativeCrashSearchBackgroundWorker;
    private volatile ScheduledWorker sessionCacheWorker;
    private volatile ScheduledWorker automaticSessionCloser;
    private volatile Session activeSession;
    private final EmbraceSessionProperties sessionProperties;
    private boolean isLookingForNativeCrash;
    private final Lock nativeCrashSearchLock = new ReentrantLock();
    private final Condition searchEndedCondition = this.nativeCrashSearchLock.newCondition();

    EmbraceSessionService(PreferencesService preferencesService, PerformanceInfoService performanceInfoService, MetadataService metadataService, NetworkConnectivityService networkConnectivityService, BreadcrumbService breadcrumbService, PowerService powerService, ActivityService activityService, ApiClient apiClient, EventService eventService, EmbraceRemoteLogger remoteLogger, UserService userService, ConfigService configService, CacheService cacheService, EmbraceExceptionService exceptionService, LocalConfig localConfig, MemoryCleanerService memoryCleanerService, OrientationService orientationService, NdkService ndkService, EmbraceSessionProperties sessionProperties) {
        this.preferencesService = (PreferencesService)Preconditions.checkNotNull((Object)preferencesService);
        this.performanceInfoService = (PerformanceInfoService)Preconditions.checkNotNull((Object)performanceInfoService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.networkConnectivityService = (NetworkConnectivityService)Preconditions.checkNotNull((Object)networkConnectivityService);
        this.breadcrumbService = (BreadcrumbService)Preconditions.checkNotNull((Object)breadcrumbService);
        this.powerService = (PowerService)Preconditions.checkNotNull((Object)powerService);
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.eventService = (EventService)Preconditions.checkNotNull((Object)eventService);
        this.remoteLogger = (EmbraceRemoteLogger)Preconditions.checkNotNull((Object)remoteLogger);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService);
        this.exceptionService = (EmbraceExceptionService)Preconditions.checkNotNull((Object)exceptionService);
        this.activityService.addListener(this, true);
        this.sessionBackgroundWorker = BackgroundWorker.ofSingleThread("Session");
        this.nativeCrashSendBackgroundWorker = BackgroundWorker.ofSingleThread("Native Crash Send");
        this.nativeCrashSearchBackgroundWorker = BackgroundWorker.ofSingleThread("Native Crash Search");
        this.localConfig = (LocalConfig)Preconditions.checkNotNull((Object)localConfig);
        this.memoryCleanerService = (MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService);
        this.orientationService = (OrientationService)Preconditions.checkNotNull((Object)orientationService);
        this.ndkService = (NdkService)Preconditions.checkNotNull((Object)ndkService);
        this.sessionProperties = (EmbraceSessionProperties)Preconditions.checkNotNull((Object)sessionProperties);
        this.isLookingForNativeCrash = localConfig.isNdkEnabled();
        if (!this.activityService.isInBackground()) {
            this.startSessionSynchronized(true);
        }
    }

    private int incrementAndGetSessionNumber() {
        if (this.preferencesService.getSessionNumber().isPresent()) {
            this.preferencesService.setSessionNumber((Integer)this.preferencesService.getSessionNumber().get() + 1);
        } else {
            this.preferencesService.setSessionNumber(1);
        }
        return (Integer)this.preferencesService.getSessionNumber().get();
    }

    public void setSdkStartupDuration(long sdkStartupDuration) {
        this.sdkStartupDuration = sdkStartupDuration;
    }

    private void startCaching() {
        this.sessionCacheWorker = ScheduledWorker.ofSingleThread("Session Caching Service");
        this.sessionCacheWorker.scheduleAtFixedRate(this::cacheActiveSession, 0L, 2L, TimeUnit.SECONDS);
    }

    private void stopCaching() {
        if (this.sessionCacheWorker != null) {
            this.sessionCacheWorker.close();
        }
    }

    private void startSessionCloser(int maxSessionSeconds) {
        if (this.localConfig.getConfigurations().getSessionConfig().getAsyncEnd().booleanValue() || this.configService.getConfig().endSessionInBackgroundThread().booleanValue()) {
            EmbraceLogger.logWarning("Can't close the session. Automatic session closing disabled since async session send is enabled.");
            return;
        }
        this.automaticSessionCloser = ScheduledWorker.ofSingleThread("Session Closer Service");
        this.automaticSessionCloser.scheduleAtFixedRate(() -> {
            try {
                Object object = this.lock;
                synchronized (object) {
                    EmbraceLogger.logInfo("Automatic session closing triggered.");
                    this.triggerStatelessSessionEnd(Session.SessionLifeEventType.TIMED);
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Error while trying to close the session automatically", ex);
            }
        }, maxSessionSeconds, maxSessionSeconds, TimeUnit.SECONDS);
    }

    private void stopSessionCloser() {
        if (this.automaticSessionCloser != null) {
            this.automaticSessionCloser.close();
        }
    }

    @Override
    public void startSession(boolean coldStart, Session.SessionLifeEventType startType) {
        if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
            EmbraceLogger.logWarning("Session messages disabled. Ignoring all sessions.");
            return;
        }
        String sessionId = Uuid.getEmbUuid();
        SessionMessage message = this.sessionStartMessage(coldStart, sessionId, startType);
        this.activeSession = message.getSession();
        this.metadataService.setActiveSessionId(sessionId);
        this.apiClient.sendSession(message);
        LocalConfig.SdkConfigs.SessionConfig sessionConfig = this.localConfig.getConfigurations().getSessionConfig();
        if (sessionConfig.getMaxSessionSeconds().isPresent()) {
            this.startSessionCloser((Integer)sessionConfig.getMaxSessionSeconds().get());
        }
        this.addViewBreadcrumbForResumedSession();
        this.startCaching();
        if (this.localConfig.isNdkEnabled().booleanValue()) {
            this.ndkService.updateSessionId(this.activeSession.getSessionId());
        }
    }

    @Override
    public boolean sdkStartupFailedLastSession() {
        Optional<String> lastSessionStartupProgress = this.preferencesService.getSDKStartupStatus();
        return lastSessionStartupProgress.isPresent() && !((String)lastSessionStartupProgress.get()).equals("startup_completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCrash(String crashId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeSession != null) {
                SessionMessage sessionMessage = this.sessionEndMessage(this.activeSession, false, false, crashId, Session.SessionLifeEventType.STATE);
                Unchecked.wrap(() -> this.apiClient.sendSession(sessionMessage).get());
                this.cacheService.deleteObject(SESSION_FILE_NAME);
            }
        }
    }

    private SessionMessage sessionStartMessage(boolean coldStart, String id, Session.SessionLifeEventType startType) {
        Session.Builder builder = Session.newBuilder().withSessionId(id).withStartTime(System.currentTimeMillis()).withNumber(this.incrementAndGetSessionNumber()).withColdStart(coldStart).withStartType(startType).withOrientations(this.orientationService.getOrientations()).withProperties(this.sessionProperties).withSessionType(SESSION_START_TYPE).withStartingBatteryLevel(this.powerService.getLatestBatteryLevel()).withUserInfo(this.userService.loadUserInfoFromDisk());
        Session session = builder.build();
        this.networkConnectivityService.networkStatusOnSessionStarted(session.getStartTime());
        return SessionMessage.newBuilder().withSession(session).withDeviceInfo(this.metadataService.getDeviceInfo()).withAppInfo(this.metadataService.getAppInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheActiveSession() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.activeSession != null) {
                    this.cacheSessionMessage(this.sessionEndMessage(this.activeSession, false, true, Session.SessionLifeEventType.STATE));
                }
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Error while caching active session", ex);
        }
    }

    private SessionMessage sessionEndMessage(Session session, boolean endedCleanly, boolean forceQuit, Session.SessionLifeEventType endType) {
        return this.sessionEndMessage(session, endedCleanly, forceQuit, null, endType);
    }

    private SessionMessage sessionEndMessage(Session session, boolean endedCleanly, boolean forceQuit, String crashId, Session.SessionLifeEventType endType) {
        Long startTime = session.getStartTime();
        long endTime = System.currentTimeMillis();
        Session.Builder builder = Session.newBuilder(session).withEndedCleanly(endedCleanly).withLastState(this.getApplicationState()).withSessionType(SESSION_END_TYPE).withEventIds(this.eventService.findEventIdsForSession(startTime, endTime)).withInfoLogIds(this.remoteLogger.findInfoLogIds(startTime, endTime)).withWarningLogIds(this.remoteLogger.findWarningLogIds(startTime, endTime)).withErrorLogIds(this.remoteLogger.findErrorLogIds(startTime, endTime)).withInfoLogsAttemptedToSend(this.remoteLogger.getInfoLogsAttemptedToSend()).withWarnLogsAttemptedToSend(this.remoteLogger.getWarnLogsAttemptedToSend()).withErrorLogsAttemptedToSend(this.remoteLogger.getErrorLogsAttemptedToSend()).withExceptionErrors(this.exceptionService.getCurrentExceptionError()).withLastHeartbeatTime(System.currentTimeMillis()).withOrientations(this.orientationService.getOrientations()).withProperties(this.sessionProperties).withEndType(endType);
        if (crashId != null && !crashId.isEmpty()) {
            builder.withCrashReportId(crashId);
        }
        if (forceQuit) {
            builder.withTerminationTime(System.currentTimeMillis()).withReceivedTermination(true);
        } else {
            builder.withEndTime(endTime);
        }
        StartupEventInfo startupEventInfo = this.eventService.getStartupMomentInfo();
        if (session.isColdStart().booleanValue()) {
            builder.withSdkStartupDuration(this.sdkStartupDuration);
            if (startupEventInfo != null) {
                builder.withStartupDuration(startupEventInfo.getDuration());
                builder.withStartupThreshold(startupEventInfo.getThreshold());
            }
        }
        Session currentSession = builder.build();
        return SessionMessage.newBuilder().withUserInfo(currentSession.getUser()).withAppInfo(this.metadataService.getAppInfo()).withDeviceInfo(this.metadataService.getDeviceInfo()).withPerformanceInfo(this.performanceInfoService.getSessionPerformanceInfo(startTime, endTime)).withBreadcrumbs(this.breadcrumbService.getBreadcrumbs(startTime, endTime)).withSession(currentSession).build();
    }

    private String getApplicationState() {
        return this.activityService.isInBackground() ? APPLICATION_STATE_BACKGROUND : APPLICATION_STATE_ACTIVE;
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        this.startSessionSynchronized(coldStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSessionSynchronized(boolean coldStart) {
        Object object = this.lock;
        synchronized (object) {
            if (coldStart) {
                this.sendCachedSession();
            }
            this.startSession(coldStart, Session.SessionLifeEventType.STATE);
        }
    }

    @Override
    public void onBackground() {
        this.endSession(Session.SessionLifeEventType.STATE);
    }

    @Override
    public void triggerStatelessSessionEnd(Session.SessionLifeEventType endType) {
        if (!this.configService.isSessionControlEnabled()) {
            EmbraceLogger.logWarning("Session control disabled from remote configuration.");
            return;
        }
        if (this.activeSession == null) {
            EmbraceLogger.logError("There's no active session to end.");
            return;
        }
        if (System.currentTimeMillis() - this.activeSession.getStartTime() < minSessionTime) {
            EmbraceLogger.logError("The session has to be of at least 5 seconds to be ended manually.");
            return;
        }
        this.endSession(endType);
        if (!this.activityService.isInBackground()) {
            this.startSession(false, endType);
        }
        EmbraceLogger.logInfo("Session successfully closed.");
    }

    private synchronized void endSession(Session.SessionLifeEventType endType) {
        this.stopCaching();
        this.stopSessionCloser();
        if (this.localConfig.getConfigurations().getSessionConfig().getAsyncEnd().booleanValue() || this.configService.getConfig().endSessionInBackgroundThread().booleanValue()) {
            this.sessionBackgroundWorker.submit(() -> {
                this.runEndSession(endType);
                return null;
            });
        } else {
            this.runEndSession(endType);
        }
    }

    private void runEndSession(Session.SessionLifeEventType endType) {
        if (this.activeSession != null) {
            if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
                EmbraceLogger.logWarning("Session messages disabled. Ignoring all Sessions.");
                return;
            }
            SessionMessage sessionMessage = this.sessionEndMessage(this.activeSession, true, false, endType);
            this.cacheSessionMessage(sessionMessage);
            this.activeSession = null;
            this.memoryCleanerService.cleanServicesCollections();
            try {
                this.apiClient.sendSession(sessionMessage).get(2L, TimeUnit.SECONDS);
                this.cacheService.deleteObject(SESSION_FILE_NAME);
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to send session end message", ex);
            }
        }
        this.clearProperties();
    }

    private void cacheSessionMessage(SessionMessage sessionMessage) {
        if (this.isLookingForNativeCrash) {
            return;
        }
        try {
            this.cacheService.cacheObject(SESSION_FILE_NAME, sessionMessage, SessionMessage.class);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to cache session");
        }
    }

    private void addViewBreadcrumbForResumedSession() {
        Optional<String> screen = this.breadcrumbService.getLastViewBreadcrumbScreenName();
        if (screen.isPresent()) {
            this.breadcrumbService.forceLogView((String)screen.orNull(), System.currentTimeMillis());
        } else {
            Optional<Activity> foregroundActivity = this.activityService.getForegroundActivity();
            if (foregroundActivity.isPresent()) {
                this.breadcrumbService.forceLogView(((Activity)foregroundActivity.get()).getLocalClassName(), System.currentTimeMillis());
            }
        }
    }

    private void sendCachedSession() {
        if (!this.localConfig.isNdkEnabled().booleanValue()) {
            this.sendPreviousSessionMessage();
            return;
        }
        try {
            this.nativeCrashSendBackgroundWorker.submit(() -> {
                this.nativeCrashSearchLock.tryLock(1000L, TimeUnit.MILLISECONDS);
                while (this.isLookingForNativeCrash) {
                    this.searchEndedCondition.await();
                }
                this.sendPreviousSessionMessage();
                this.nativeCrashSearchLock.unlock();
                return null;
            });
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to create background worker to send cached session during resume", ex);
        }
    }

    private void sendPreviousSessionMessage() {
        try {
            Optional<SessionMessage> previousSession = this.getPreviousSessionMessage();
            if (previousSession.isPresent()) {
                this.apiClient.sendSession((SessionMessage)previousSession.get());
                this.cacheService.deleteObject(PREVIOUS_SESSION_FILE_NAME);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to send cached session message on resume", ex);
        }
    }

    @Override
    public void close() {
        EmbraceLogger.logInfo("Shutting down EmbraceSessionService");
        this.stopCaching();
        this.stopSessionCloser();
        this.sessionBackgroundWorker.close();
    }

    Optional<SessionMessage> getPreviousSessionMessage() {
        try {
            return this.cacheService.loadObject(PREVIOUS_SESSION_FILE_NAME, SessionMessage.class);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to send previous cached session message on resume", ex);
            return Optional.absent();
        }
    }

    Session getActiveSession() {
        return this.activeSession;
    }

    @Override
    public boolean addProperty(String key, String value, boolean permanent) {
        boolean added = this.sessionProperties.add(key, value, permanent);
        if (added) {
            this.ndkService.onSessionPropertiesUpdate(this.sessionProperties.get());
        }
        return added;
    }

    @Override
    public boolean removeProperty(String key) {
        boolean removed = this.sessionProperties.remove(key);
        if (removed) {
            this.ndkService.onSessionPropertiesUpdate(this.sessionProperties.get());
        }
        return removed;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.sessionProperties.get();
    }

    @Override
    public void handleNativeCrash(Optional<NativeCrashData> nativeCrashData) {
        try {
            this.nativeCrashSearchBackgroundWorker.submit(() -> {
                this.nativeCrashSearchLock.tryLock(1000L, TimeUnit.MILLISECONDS);
                try {
                    if (nativeCrashData.isPresent()) {
                        Optional<SessionMessage> previousSessionMessage = this.getPreviousSessionMessage();
                        if (previousSessionMessage.isPresent()) {
                            SessionMessage sessionMessage = (SessionMessage)previousSessionMessage.get();
                            NativeCrashData crash = (NativeCrashData)nativeCrashData.get();
                            Session session = sessionMessage.getSession();
                            if (session.getSessionId().equals(crash.getSessionId())) {
                                SessionMessage.Builder messageBuilder = SessionMessage.newBuilder(sessionMessage);
                                Session.Builder sessionBuilder = Session.newBuilder(session);
                                sessionBuilder.withCrashReportId(crash.getNativeCrashId());
                                messageBuilder.withSession(sessionBuilder.build());
                                this.cacheService.cacheObject(PREVIOUS_SESSION_FILE_NAME, messageBuilder.build(), SessionMessage.class);
                            } else {
                                EmbraceLogger.logDebug(String.format("Crash report ID %s did not match session ID %s. Not updating cached session.", ((NativeCrashData)nativeCrashData.get()).getNativeCrashId(), session.getSessionId()));
                            }
                        } else {
                            EmbraceLogger.logInfo(String.format("Could not find session to try to match native crash with report ID %s", ((NativeCrashData)nativeCrashData.get()).getNativeCrashId()));
                        }
                    }
                    this.isLookingForNativeCrash = false;
                    this.searchEndedCondition.signal();
                }
                catch (Exception ex) {
                    EmbraceLogger.logDebug("Failed to update cached session message with native crash report id.", ex);
                }
                finally {
                    this.nativeCrashSearchLock.unlock();
                }
                return null;
            });
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to create background worker to update pending session with the native crash report id.", ex);
        }
    }

    void clearProperties() {
        this.sessionProperties.clearTemporary();
    }

    public static boolean stashPreviousSession(CacheService cacheService) {
        return cacheService.moveObject(SESSION_FILE_NAME, PREVIOUS_SESSION_FILE_NAME);
    }
}

