/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Pair;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.Breadcrumbs;
import io.embrace.android.embracesdk.Clock;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.CustomBreadcrumb;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FragmentBreadcrumb;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.ViewBreadcrumb;
import io.embrace.android.embracesdk.WebViewBreadcrumb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

class EmbraceBreadcrumbService
implements BreadcrumbService,
ActivityListener,
MemoryCleanerListener {
    private static final String QUERY_PARAMETER_DELIMITER = "?";
    private final Clock clock;
    private static final Integer DEFAULT_FRAGMENT_STACK_SIZE = 20;
    private final ConfigService configService;
    private final LocalConfig localConfig;
    private final LinkedBlockingDeque<ViewBreadcrumb> viewBreadcrumbs = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<TapBreadcrumb> tapBreadcrumbs = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<CustomBreadcrumb> customBreadcrumbs = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<WebViewBreadcrumb> webViewBreadcrumbs = new LinkedBlockingDeque();
    final LinkedBlockingDeque<FragmentBreadcrumb> fragmentBreadcrumbs = new LinkedBlockingDeque();
    final List<FragmentBreadcrumb> fragmentStack = Collections.synchronizedList(new ArrayList());

    EmbraceBreadcrumbService(Clock clock, ConfigService configService, LocalConfig localConfig, ActivityService activityService, MemoryCleanerService memoryCleanerService) {
        this.clock = clock;
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService, (Object)"configService must not be null");
        this.localConfig = (LocalConfig)Preconditions.checkNotNull((Object)localConfig, (Object)"localConfig must not be null");
        Preconditions.checkNotNull((Object)activityService, (Object)"activityService must not be null");
        activityService.addListener(this);
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
    }

    @Override
    public void logView(String screen, long timestamp) {
        this.addToViewLogsQueue(screen, timestamp, false);
    }

    @Override
    public void forceLogView(String screen, long timestamp) {
        this.addToViewLogsQueue(screen, timestamp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startFragment(String name) {
        EmbraceBreadcrumbService embraceBreadcrumbService = this;
        synchronized (embraceBreadcrumbService) {
            if (this.fragmentStack.size() >= DEFAULT_FRAGMENT_STACK_SIZE) {
                return false;
            }
            return this.fragmentStack.add(new FragmentBreadcrumb(name, this.clock.now(), 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean endFragment(String name) {
        FragmentBreadcrumb start;
        FragmentBreadcrumb end = new FragmentBreadcrumb(name, 0L, this.clock.now());
        EmbraceBreadcrumbService embraceBreadcrumbService = this;
        synchronized (embraceBreadcrumbService) {
            int index = this.fragmentStack.lastIndexOf(end);
            if (index < 0) {
                return false;
            }
            start = this.fragmentStack.remove(index);
        }
        end.setStartTime(start.getStartTime());
        this.tryAddBreadcrumb(this.fragmentBreadcrumbs, end);
        return true;
    }

    @Override
    public void logTap(Pair<Float, Float> point, String element, long timestamp, TapBreadcrumb.TapBreadcrumbType type) {
        try {
            if (!this.localConfig.getConfigurations().getTaps().getCaptureCoordinates().booleanValue()) {
                point = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            }
            this.tryAddBreadcrumb(this.tapBreadcrumbs, new TapBreadcrumb((Pair<Float, Float>)point, element, timestamp, type));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to log tap breadcrumb for element " + element);
        }
    }

    @Override
    public void logCustom(String message, long timestamp) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            EmbraceLogger.logWarning("Breadcrumb message must not be blank");
            return;
        }
        try {
            this.tryAddBreadcrumb(this.customBreadcrumbs, new CustomBreadcrumb(message, timestamp));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to log custom breadcrumb with message " + message, ex);
        }
    }

    @Override
    public void logWebView(String url, long startTime) {
        if (!this.localConfig.getConfigurations().getWebViewConfig().isWebViewsCaptureEnabled().booleanValue()) {
            return;
        }
        if (url == null) {
            return;
        }
        try {
            int queryOffset;
            String parsedUrl = url;
            if (!this.localConfig.getConfigurations().getWebViewConfig().isQueryParamsCaptureEnabled().booleanValue() && (queryOffset = url.indexOf(QUERY_PARAMETER_DELIMITER)) > 0) {
                parsedUrl = url.substring(0, queryOffset);
            }
            this.tryAddBreadcrumb(this.webViewBreadcrumbs, new WebViewBreadcrumb(parsedUrl, startTime));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to log WebView breadcrumb for url " + url);
        }
    }

    @Override
    public List<ViewBreadcrumb> getViewBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.viewBreadcrumbs, startTime, endTime);
    }

    @Override
    public List<TapBreadcrumb> getTapBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.tapBreadcrumbs, startTime, endTime);
    }

    @Override
    public List<CustomBreadcrumb> getCustomBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.customBreadcrumbs, startTime, endTime);
    }

    @Override
    public List<WebViewBreadcrumb> getWebViewBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.webViewBreadcrumbs, startTime, endTime);
    }

    @Override
    public List<FragmentBreadcrumb> getFragmentBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.fragmentBreadcrumbs, startTime, endTime);
    }

    @Override
    public Breadcrumbs getBreadcrumbs(long start, long end) {
        return Breadcrumbs.newBuilder().withCustomBreadcrumbs(this.getCustomBreadcrumbsForSession(start, end)).withTapBreadcrumbs(this.getTapBreadcrumbsForSession(start, end)).withViewBreadcrumbs(this.getViewBreadcrumbsForSession(start, end)).withWebViewBreadcrumbs(this.getWebViewBreadcrumbsForSession(start, end)).withFragmentBreadcrumbs(this.getFragmentBreadcrumbsForSession(start, end)).build();
    }

    @Override
    public Optional<String> getLastViewBreadcrumbScreenName() {
        if (this.viewBreadcrumbs.isEmpty()) {
            return Optional.absent();
        }
        return this.viewBreadcrumbs.peek().getScreen();
    }

    @Override
    public void onView(Activity activity) {
        this.logView(activity.getClass().getName(), this.clock.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onViewClose(Activity activity) {
        try {
            ViewBreadcrumb lastViewBreadcrumb = this.viewBreadcrumbs.peek();
            if (lastViewBreadcrumb != null) {
                lastViewBreadcrumb.setEnd(this.clock.now());
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to add set end time for breadcrumb", ex);
        }
        if (this.fragmentStack.size() == 0) {
            return;
        }
        long ts = this.clock.now();
        List<FragmentBreadcrumb> list = this.fragmentStack;
        synchronized (list) {
            for (FragmentBreadcrumb fragment : this.fragmentStack) {
                fragment.setEndTime(ts);
                this.tryAddBreadcrumb(this.fragmentBreadcrumbs, fragment);
            }
            this.fragmentStack.clear();
        }
    }

    @Override
    public void cleanCollections() {
        this.viewBreadcrumbs.clear();
        this.tapBreadcrumbs.clear();
        this.customBreadcrumbs.clear();
        this.webViewBreadcrumbs.clear();
        this.fragmentBreadcrumbs.clear();
        this.fragmentStack.clear();
    }

    private synchronized void addToViewLogsQueue(String screen, long timestamp, boolean force) {
        try {
            ViewBreadcrumb lastViewBreadcrumb = this.viewBreadcrumbs.peek();
            if (force || lastViewBreadcrumb == null || !((String)lastViewBreadcrumb.getScreen().or((Object)"")).equalsIgnoreCase(String.valueOf(screen))) {
                if (lastViewBreadcrumb != null) {
                    lastViewBreadcrumb.setEnd(timestamp);
                }
                this.tryAddBreadcrumb(this.viewBreadcrumbs, new ViewBreadcrumb(screen, timestamp));
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to add view breadcrumb for " + screen, ex);
        }
    }

    private <T extends Breadcrumb> List<T> filterBreadcrumbsForTimeWindow(Deque<T> breadcrumbs, long startTime, long endTime) {
        return (List)StreamSupport.stream(breadcrumbs).filter(breadcrumb -> breadcrumb.getStartTime() >= startTime).filter(breadcrumb -> endTime <= 0L || breadcrumb.getStartTime() <= endTime).collect(Collectors.toList());
    }

    private <T> void tryAddBreadcrumb(LinkedBlockingDeque<T> breadcrumbs, T breadcrumb) {
        int limit = this.configService.getConfig().getCustomBreadcrumbLimit();
        if (!breadcrumbs.isEmpty() && breadcrumbs.size() == limit) {
            breadcrumbs.removeLast();
        }
        breadcrumbs.push(breadcrumb);
    }
}

