/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.AnrInterval;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.AnrStacktraces;
import io.embrace.android.embracesdk.AnrTick;
import io.embrace.android.embracesdk.Clock;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Pattern;

final class EmbraceAnrService
implements AnrService,
MemoryCleanerListener,
ActivityListener {
    private static final long ANR_THRESHOLD_INTERVAL = 1000L;
    private static final int HEALTHCHECK_EXECUTE = 34592;
    private static final int HEALTHCHECK_REQUEST = 34593;
    private static final int HEALTHCHECK_RESPONSE = 34594;
    private static final long BACKGROUND_ANR_SAFE_INTERVAL_MS = 10L;
    private final Clock clock;
    private final ConfigService configService;
    private final NavigableMap<Long, AnrInterval> anrIntervals = new ConcurrentSkipListMap<Long, AnrInterval>();
    private int anrIntervalsStackTraceCount = 0;
    private final MainThreadHandler mainThreadHandler = new MainThreadHandler(Looper.getMainLooper());
    private final MonitoringThreadHandler monitoringThreadHandler;
    private final HandlerThread monitoringThread = new HandlerThread("Embrace ANR Healthcheck");
    private final HashMap<Long, Integer> currentStacktraceStates = new HashMap();
    private volatile long lastTimeThreadUnblocked;
    private volatile boolean anrInProgress;
    private volatile boolean isMainThreadCrashing = false;
    private AnrStacktraces stacktraces = new AnrStacktraces();

    EmbraceAnrService(Clock clock, MemoryCleanerService memoryCleanerService, ConfigService configService, EmbraceActivityService activityService) {
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
        ((EmbraceActivityService)Preconditions.checkNotNull((Object)activityService)).addListener(this, true);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.monitoringThread.start();
        Looper callingThreadLooper = this.monitoringThread.getLooper();
        this.monitoringThreadHandler = new MonitoringThreadHandler(callingThreadLooper);
        this.monitoringThreadHandler.runHealthCheck();
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        if (!coldStart) {
            this.forceHealthCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnrInterval> getAnrIntervals(long startTime, long endTime) {
        EmbraceAnrService embraceAnrService = this;
        synchronized (embraceAnrService) {
            ArrayList<AnrInterval> results;
            long safeStartTime = startTime + 10L;
            if (safeStartTime < endTime) {
                Collection<AnrInterval> intervals = this.anrIntervals.subMap(safeStartTime, endTime).values();
                results = new ArrayList<AnrInterval>(intervals);
            } else {
                results = new ArrayList<AnrInterval>();
            }
            if (this.anrInProgress && !this.isMainThreadCrashing) {
                long intervalEndTime = this.clock.now();
                long duration = intervalEndTime - this.lastTimeThreadUnblocked;
                AnrInterval.Builder anrIntervalBuilder = AnrInterval.newBuilder();
                anrIntervalBuilder.withStartTime(this.lastTimeThreadUnblocked).withLastKnownTime(intervalEndTime).withEndTime(null).withType(AnrInterval.Type.UI);
                if (this.configService.isAnrCaptureEnabled() && this.isMinimumCaptureDurationExceeded(duration)) {
                    anrIntervalBuilder.withStacktraces(this.stacktraces);
                }
                results.add(anrIntervalBuilder.build());
            }
            return results;
        }
    }

    @Override
    public void forceANRTrackingStopOnCrash() {
        this.isMainThreadCrashing = true;
        this.close();
    }

    @Override
    public void close() {
        try {
            this.monitoringThread.quit();
            this.monitoringThread.join();
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to cleanly shut down EmbraceAnrService");
        }
    }

    @Override
    public void cleanCollections() {
        this.anrIntervals.clear();
        this.anrIntervalsStackTraceCount = 0;
    }

    private void forceHealthCheck() {
        this.monitoringThreadHandler.handleHealthCheckResponse(this.clock.now());
    }

    private boolean isMinimumCaptureDurationExceeded(long duration) {
        return duration >= (long)this.configService.getConfig().getAnrStacktraceMinimumDuration();
    }

    class MainThreadHandler
    extends Handler {
        public MainThreadHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            try {
                if (msg.what == 34593) {
                    EmbraceAnrService.this.monitoringThreadHandler.sendMessage(this.obtainMessage(34594));
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("ANR healthcheck failed in main (monitored) thread", ex);
            }
            super.handleMessage(msg);
        }
    }

    class MonitoringThreadHandler
    extends Handler {
        public MonitoringThreadHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            try {
                long timestamp = EmbraceAnrService.this.clock.now();
                if (msg.what == 34594) {
                    this.handleHealthCheckResponse(timestamp);
                } else if (msg.what == 34592) {
                    if (this.isAnrDurationThresholdExceeded(timestamp) && !EmbraceAnrService.this.anrInProgress) {
                        EmbraceLogger.logDebug("Main thread not responding for > 1s");
                        EmbraceAnrService.this.currentStacktraceStates.clear();
                        EmbraceAnrService.this.anrInProgress = true;
                    }
                    if (EmbraceAnrService.this.anrInProgress) {
                        this.processAnrTick();
                    }
                    this.runHealthCheck();
                }
            }
            catch (OutOfMemoryError timestamp) {
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("ANR healthcheck failed in monitoring thread", ex);
            }
        }

        void runHealthCheck() {
            EmbraceAnrService.this.mainThreadHandler.sendMessage(this.obtainMessage(34593));
            EmbraceAnrService.this.monitoringThreadHandler.sendMessageDelayed(this.obtainMessage(34592), EmbraceAnrService.this.configService.getConfig().getCaptureAnrIntervalMs());
        }

        public synchronized void handleHealthCheckResponse(long timestamp) {
            if (this.isAnrDurationThresholdExceeded(timestamp)) {
                boolean shouldCaptureStacktrace;
                EmbraceLogger.logDebug("Main thread recovered from not responding for > 1s");
                AnrInterval.Builder anrIntervalBuilder = AnrInterval.newBuilder();
                anrIntervalBuilder.withStartTime(EmbraceAnrService.this.lastTimeThreadUnblocked).withLastKnownTime(timestamp).withEndTime(timestamp).withType(AnrInterval.Type.UI);
                long duration = timestamp - EmbraceAnrService.this.lastTimeThreadUnblocked;
                boolean bl = shouldCaptureStacktrace = EmbraceAnrService.this.configService.isAnrCaptureEnabled() && EmbraceAnrService.this.isMinimumCaptureDurationExceeded(duration);
                if (shouldCaptureStacktrace) {
                    anrIntervalBuilder.withStacktraces(EmbraceAnrService.this.stacktraces);
                    if (this.reachedAnrCaptureLimit()) {
                        ((AnrInterval)EmbraceAnrService.this.anrIntervals.lastEntry().getValue()).removeStacktraces();
                    } else {
                        EmbraceAnrService.this.anrIntervalsStackTraceCount = EmbraceAnrService.this.anrIntervalsStackTraceCount + 1;
                    }
                }
                EmbraceAnrService.this.anrIntervals.put(timestamp, anrIntervalBuilder.build());
                EmbraceAnrService.this.stacktraces = new AnrStacktraces();
                EmbraceAnrService.this.currentStacktraceStates.clear();
            }
            EmbraceAnrService.this.lastTimeThreadUnblocked = timestamp;
            EmbraceAnrService.this.anrInProgress = false;
        }

        private synchronized void processAnrTick() {
            if (!EmbraceAnrService.this.configService.isAnrCaptureEnabled()) {
                return;
            }
            if (EmbraceAnrService.this.stacktraces.size() >= EmbraceAnrService.this.configService.getConfig().getStacktracesPerInterval()) {
                EmbraceLogger.logDebug("ANR stacktrace not captured. Maximum allowed ticks per ANR interval reached.");
                return;
            }
            AnrTick anrTick = new AnrTick(EmbraceAnrService.this.clock.now());
            for (ThreadInfo threadInfo : this.getAllowedThreads()) {
                Integer threadHash = (Integer)EmbraceAnrService.this.currentStacktraceStates.get(threadInfo.getThreadId());
                if (threadHash != null) {
                    if (threadHash.intValue() == threadInfo.hashCode()) continue;
                    this.updateThread(threadInfo, anrTick);
                    continue;
                }
                this.updateThread(threadInfo, anrTick);
            }
            EmbraceAnrService.this.stacktraces.add(anrTick);
        }

        private void updateThread(ThreadInfo threadInfo, AnrTick anrTick) {
            EmbraceAnrService.this.currentStacktraceStates.put(threadInfo.getThreadId(), threadInfo.hashCode());
            anrTick.add(threadInfo);
        }

        private Set<ThreadInfo> getAllowedThreads() {
            HashSet<ThreadInfo> allowed = new HashSet<ThreadInfo>();
            List<Pattern> blockList = EmbraceAnrService.this.configService.getConfig().getAnrBlockPatternList();
            List<Pattern> allowList = EmbraceAnrService.this.configService.getConfig().getAnrAllowPatternList();
            int anrStacktracesMaxLength = EmbraceAnrService.this.configService.getConfig().getAnrStacktracesMaxDepth();
            int priority = EmbraceAnrService.this.configService.getConfig().getAnrThreadCapturePriority();
            if (EmbraceAnrService.this.configService.getConfig().captureMainThreadOnly()) {
                Thread mainThread = Looper.getMainLooper().getThread();
                ThreadInfo threadInfo = ThreadInfo.ofThread(mainThread, mainThread.getStackTrace(), anrStacktracesMaxLength);
                allowed.add(threadInfo);
            } else {
                for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                    ThreadInfo threadInfo = ThreadInfo.ofThread(entry.getKey(), entry.getValue(), anrStacktracesMaxLength);
                    if (allowList != null && !allowList.isEmpty()) {
                        if (!this.isAllowedByList(allowList, threadInfo) || !this.isAllowedByPriority(priority, threadInfo)) continue;
                        allowed.add(threadInfo);
                        continue;
                    }
                    if (blockList != null && !blockList.isEmpty()) {
                        if (this.isAllowedByList(blockList, threadInfo) || !this.isAllowedByPriority(priority, threadInfo)) continue;
                        allowed.add(threadInfo);
                        continue;
                    }
                    if (!this.isAllowedByPriority(priority, threadInfo)) continue;
                    allowed.add(threadInfo);
                }
            }
            return allowed;
        }

        private boolean isAllowedByList(List<Pattern> allowed, ThreadInfo threadInfo) {
            for (Pattern pattern : allowed) {
                if (!pattern.matcher(threadInfo.getName()).find()) continue;
                return true;
            }
            return false;
        }

        private boolean isAllowedByPriority(int priority, ThreadInfo threadInfo) {
            if (priority != 0) {
                return threadInfo.getPriority() >= priority;
            }
            return true;
        }

        private boolean reachedAnrCaptureLimit() {
            return EmbraceAnrService.this.anrIntervalsStackTraceCount >= EmbraceAnrService.this.configService.getConfig().getMaxAnrCapturedIntervalsPerSession();
        }

        private boolean isAnrDurationThresholdExceeded(long timestamp) {
            return EmbraceAnrService.this.lastTimeThreadUnblocked > 0L && timestamp - EmbraceAnrService.this.lastTimeThreadUnblocked > 1000L;
        }
    }
}

