package io.embrace.android.embracesdk;

import java.io.Closeable;
import java.util.List;

/**
 * Service which detects when the application is not responding.
 */
interface AnrService extends Closeable {
    /**
     * Gets the intervals during which the application was not responding (ANR).
     *
     * @param startTime the time to search from
     * @param endTime the time to search until
     * @return the list of ANR intervals
     */
    List<AnrInterval> getAnrIntervals(long startTime, long endTime);

    /**
     * Forces ANR tracking stop by closing the monitoring thread when a crash is
     * handled by the {@link EmbraceCrashService}.
     */
    void forceANRTrackingStopOnCrash();
}
