/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import com.fernandocejas.arrow.checks.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import java9.util.function.Consumer;

final class CountingInputStreamWithCallback
extends FilterInputStream {
    private volatile AtomicLong count = new AtomicLong(0L);
    private volatile long mark = -1L;
    private final Consumer<Long> callback;
    private volatile boolean callbackCompleted;

    public CountingInputStreamWithCallback(InputStream in, Consumer<Long> callback) {
        super((InputStream)Preconditions.checkNotNull((Object)in));
        this.callback = (Consumer)Preconditions.checkNotNull(callback);
    }

    public long getCount() {
        return this.count.longValue();
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            this.count.incrementAndGet();
        } else if (!this.callbackCompleted) {
            this.callbackCompleted = true;
            this.callback.accept((Object)this.count.longValue());
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.count.addAndGet(result);
        } else if (!this.callbackCompleted) {
            this.callbackCompleted = true;
            this.callback.accept((Object)this.count.longValue());
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.count.addAndGet(result);
        return result;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count.longValue();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count.set(this.mark);
        this.callbackCompleted = false;
    }
}

