/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import com.fernandocejas.arrow.checks.Preconditions;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public abstract class EmbraceUrlStreamHandler
extends URLStreamHandler {
    protected static final String METHOD_NAME_OPEN_CONNECTION = "openConnection";
    protected static final String MSG_ERROR_OPEN_CONNECTION = "An exception was thrown while attempting to open a connection";
    protected final URLStreamHandler handler;
    private Method methodOpenConnection1;
    private Method methodOpenConnection2;
    protected static Boolean enableRequestSizeCapture = false;

    public EmbraceUrlStreamHandler(URLStreamHandler handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"Handler is null.");
        this.handler = handler;
        try {
            this.methodOpenConnection1 = this.getMethodOpenConnection(URL.class);
            this.methodOpenConnection2 = this.getMethodOpenConnection(URL.class, Proxy.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to initialize EmbraceUrlStreamHandler instance.", e);
        }
    }

    @Override
    public abstract int getDefaultPort();

    public static void setEnableRequestSizeCapture(Boolean value) {
        enableRequestSizeCapture = value;
    }

    protected abstract Method getMethodOpenConnection(Class<URL> var1) throws NoSuchMethodException;

    protected abstract Method getMethodOpenConnection(Class<URL> var1, Class<Proxy> var2) throws NoSuchMethodException;

    protected abstract URLConnection newEmbraceUrlConnection(URLConnection var1);

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        try {
            return this.newEmbraceUrlConnection((URLConnection)this.methodOpenConnection1.invoke((Object)this.handler, url));
        }
        catch (Exception e) {
            throw new IOException(MSG_ERROR_OPEN_CONNECTION, e);
        }
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        try {
            return this.newEmbraceUrlConnection((URLConnection)this.methodOpenConnection2.invoke((Object)this.handler, url, proxy));
        }
        catch (Exception e) {
            throw new IOException(MSG_ERROR_OPEN_CONNECTION, e);
        }
    }
}

