/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;

class NativeSymbols {
    private static final String ARM_ABI_V7_NAME = "armeabi-v7a";
    private static final String ARM_64_NAME = "arm64-v8a";
    private static final String ARCH_X86_NAME = "x86";
    private static final String ARCH_X86_64_NAME = "x86_64";
    @SerializedName(value="symbols")
    private Map<String, Map<String, String>> symbols;

    NativeSymbols(Map<String, Map<String, String>> symbols) {
        this.symbols = symbols;
    }

    Map<String, String> getSymbolByArchitecture(String arch) {
        Map<String, String> symbols = new HashMap<String, String>();
        if (arch == null) {
            return symbols;
        }
        if (this.symbols.containsKey(arch)) {
            symbols = this.symbols.get(arch);
        } else if (arch.equals(ARM_64_NAME)) {
            symbols = this.symbols.get(ARM_ABI_V7_NAME);
        } else if (arch.equals(ARCH_X86_64_NAME)) {
            symbols = this.symbols.get(ARCH_X86_NAME);
        }
        return symbols;
    }
}

