/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.AppInfo;
import io.embrace.android.embracesdk.DeviceInfo;
import io.embrace.android.embracesdk.MessageUtils;
import io.embrace.android.embracesdk.NativeCrash;
import io.embrace.android.embracesdk.UserInfo;
import java.util.Map;

class NativeCrashData {
    @SerializedName(value="report_id")
    private final String id;
    @SerializedName(value="sid")
    private final String sessionId;
    @SerializedName(value="ts")
    private final Long timestamp;
    @SerializedName(value="state")
    private final String appState;
    @SerializedName(value="meta")
    private final NativeCrashMetadata metadata;
    @SerializedName(value="crash")
    private final String crash;
    @SerializedName(value="symbols")
    private Map<String, String> symbols;

    public NativeCrashData(String id, String sessionId, Long timestamp, String appState, NativeCrashMetadata metadata, String crash, Map<String, String> symbols) {
        this.id = id;
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.appState = appState;
        this.metadata = metadata;
        this.crash = crash;
        this.symbols = symbols;
    }

    public void setSymbols(Map<String, String> symbols) {
        this.symbols = symbols;
    }

    public String getNativeCrashId() {
        return this.id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getAppState() {
        return this.appState;
    }

    public NativeCrashMetadata getMetadata() {
        return this.metadata;
    }

    public NativeCrash getCrash() {
        return new NativeCrash(this.id, this.crash, this.symbols);
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public static class NativeCrashMetadata {
        @SerializedName(value="a")
        private final AppInfo appInfo;
        @SerializedName(value="d")
        private final DeviceInfo deviceInfo;
        @SerializedName(value="u")
        private final UserInfo userInfo;
        @SerializedName(value="sp")
        private final Map<String, String> sessionProperties;

        NativeCrashMetadata(AppInfo appInfo, DeviceInfo deviceInfo, UserInfo userInfo, Map<String, String> sessionProperties) {
            this.appInfo = appInfo;
            this.deviceInfo = deviceInfo;
            this.userInfo = userInfo;
            this.sessionProperties = sessionProperties;
        }

        public DeviceInfo getDeviceInfo() {
            return this.deviceInfo;
        }

        public AppInfo getAppInfo() {
            return this.appInfo;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public Map<String, String> getSessionProperties() {
            return this.sessionProperties;
        }

        public String toJson() {
            StringBuilder sb = new StringBuilder();
            sb.append("{\"a\":");
            sb.append(this.appInfo.toJson());
            sb.append(",\"d\":");
            sb.append(this.deviceInfo.toJson());
            sb.append(",\"u\":");
            sb.append(this.userInfo.toJson());
            sb.append(",\"sp\":");
            sb.append(MessageUtils.withMap(this.sessionProperties));
            sb.append("}");
            return sb.toString();
        }
    }
}

