/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import java.util.Locale;
import java.util.Map;
import java.util.Set;

final class MessageUtils {
    MessageUtils() {
    }

    public static String boolToStr(boolean value) {
        return value ? "true" : "false";
    }

    public static String withNull(Integer value) {
        if (value == null) {
            return "null";
        }
        return String.format((Locale)null, "\"%d\"", value);
    }

    public static String withNull(Long value) {
        if (value == null) {
            return "null";
        }
        return String.format((Locale)null, "\"%d\"", value);
    }

    public static String withNull(String value) {
        if (value == null) {
            return "null";
        }
        return String.format("\"%s\"", value);
    }

    public static String withSet(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String v : set) {
            sb.append(MessageUtils.withNull(v));
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String withMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(String.format("%s: %s,", MessageUtils.withNull(entry.getKey()), MessageUtils.withNull(entry.getValue())));
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }
}

