/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.res.Resources;
import android.util.Base64;
import com.fernandocejas.arrow.optional.Optional;
import com.google.gson.annotations.SerializedName;
import com.jsoniter.JsonIterator;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java9.util.stream.StreamSupport;

public final class LocalConfig {
    private static final String APP_CONFIG_KEY = "app";
    private static final String APP_DISK_USAGE_CONFIG_KEY = "report_disk_usage";
    private static final String BASE_URL_KEY = "base_urls";
    private static final String BASE_URL_DATA_CONFIG_KEY = "data";
    private static final String BASE_URL_DATA_DEV_CONFIG_KEY = "data_dev";
    private static final String BASE_URL_CONFIG_KEY = "config";
    private static final String BASE_URL_IMAGES_CONFIG_KEY = "images";
    private static final String CRASH_HANDLER_CONFIG_KEY = "crash_handler";
    private static final String CRASH_HANDLER_ENABLED_CONFIG_KEY = "enabled";
    private static final String STARTUP_MOMENT_CONFIG_KEY = "startup_moment";
    private static final String STARTUP_MOMENT_AUTOMATICALLY_END_CONFIG_KEY = "automatically_end";
    private static final String STARTUP_MOMENT_TAKE_SCREENSHOT_CONFIG_KEY = "take_screenshot";
    private static final String NETWORKING_CONFIG_KEY = "networking";
    private static final String NETWORKING_CAPTURE_REQUEST_LENGTH_CONFIG_KEY = "capture_request_content_length";
    private static final String NETWORKING_DEFAULT_CAPTURE_LIMIT_CONFIG_KEY = "default_capture_limit";
    private static final String NETWORKING_DOMAINS_CONFIG_KEY = "domains";
    private static final String NETWORKING_DOMAIN_NAME_CONFIG_KEY = "domain_name";
    private static final String NETWORKING_DOMAIN_LIMIT_CONFIG_KEY = "domain_limit";
    private static final String NETWORKING_TRACE_ID_CONFIG_KEY = "trace_id_header";
    private static final String NETWORKING_DISABLE_URL_PATTERNS_CONFIG_KEY = "disabled_url_patterns";
    private static final String NETWORKING_ENABLE_MONITORING_CONFIG_KEY = "enable_native_monitoring";
    private static final String SESSION_CONFIG_KEY = "session";
    private static final String SESSION_ASYNC_END_CONFIG_KEY = "async_end";
    private static final String SESSION_MAX_SESSION_SEC_CONFIG_KEY = "max_session_seconds";
    private static final String TAPS_CONFIG_KEY = "taps";
    private static final String TAPS_CAPTURE_COORDINATES_CONFIG_KEY = "capture_coordinates";
    private static final String WEBVIEW_CONFIG_KEY = "webview";
    private static final String WEBVIEW_CAPTURE_QUERY_PARAMS_CONFIG_KEY = "capture_query_params";
    private static final String WEBVIEW_ENABLE_CAPTURE_CONFIG_KEY = "enable";
    static final String BUILD_INFO_APP_ID = "emb_app_id";
    static final String BUILD_INFO_SDK_CONFIG = "emb_sdk_config";
    private static final String BUILD_INFO_NDK_ENABLED = "emb_ndk_enabled";
    private static final Boolean NDK_ENABLED_DEFAULT = false;
    private final String appId;
    private final SdkConfigs configs;
    @SerializedName(value="ndk_enabled")
    private Boolean ndkEnabled;

    LocalConfig(String appId, Boolean ndkEnabled, SdkConfigs configs) {
        this.appId = appId;
        this.ndkEnabled = ndkEnabled;
        this.configs = (SdkConfigs)Optional.fromNullable((Object)configs).orNull();
    }

    static LocalConfig fromResources(Context context) {
        try {
            String appId = context.getResources().getString(LocalConfig.getResourcesIdentifier(context, BUILD_INFO_APP_ID, "string"));
            boolean ndkEnabled = NDK_ENABLED_DEFAULT;
            int ndkEnabledJsonId = LocalConfig.getResourcesIdentifier(context, BUILD_INFO_NDK_ENABLED, "string");
            if (ndkEnabledJsonId != 0) {
                ndkEnabled = Boolean.parseBoolean(context.getResources().getString(ndkEnabledJsonId));
            }
            String sdkConfigJson = null;
            int sdkConfigJsonId = LocalConfig.getResourcesIdentifier(context, BUILD_INFO_SDK_CONFIG, "string");
            if (sdkConfigJsonId != 0) {
                String encodedConfig = context.getResources().getString(sdkConfigJsonId);
                sdkConfigJson = new String(Base64.decode((String)encodedConfig, (int)0));
            }
            return LocalConfig.buildConfig(appId, ndkEnabled, sdkConfigJson);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load local config from resources.", ex);
        }
    }

    static LocalConfig buildConfig(String appId, boolean ndkEnabled, String sdkConfigs) {
        if (appId == null || appId.isEmpty()) {
            throw new IllegalArgumentException("Embrace AppId cannot be null or empty.");
        }
        EmbraceLogger.logInfo(String.format("Native crash capture is %s", ndkEnabled ? CRASH_HANDLER_ENABLED_CONFIG_KEY : "disabled"));
        SdkConfigs configs = new SdkConfigs();
        if (sdkConfigs != null && !sdkConfigs.isEmpty()) {
            JsonIterator iter = JsonIterator.parse((String)sdkConfigs);
            try {
                String field = iter.readObject();
                while (field != null) {
                    switch (field) {
                        case "app": {
                            configs.app = new SdkConfigs.App();
                            String appField = iter.readObject();
                            while (appField != null) {
                                if (APP_DISK_USAGE_CONFIG_KEY.equals(appField)) {
                                    configs.app.reportDiskUsage = iter.readBoolean();
                                } else {
                                    iter.skip();
                                }
                                appField = iter.readObject();
                            }
                            break;
                        }
                        case "base_urls": {
                            configs.baseUrls = new SdkConfigs.BaseUrls();
                            String baseUrlField = iter.readObject();
                            while (baseUrlField != null) {
                                switch (baseUrlField) {
                                    case "data": {
                                        configs.baseUrls.data = iter.readString();
                                        break;
                                    }
                                    case "data_dev": {
                                        configs.baseUrls.dataDev = iter.readString();
                                        break;
                                    }
                                    case "config": {
                                        configs.baseUrls.config = iter.readString();
                                        break;
                                    }
                                    case "images": {
                                        configs.baseUrls.images = iter.readString();
                                        break;
                                    }
                                    default: {
                                        iter.skip();
                                    }
                                }
                                baseUrlField = iter.readObject();
                            }
                            break;
                        }
                        case "crash_handler": {
                            configs.crashHandler = new SdkConfigs.CrashHandler();
                            String crashHandlerField = iter.readObject();
                            while (crashHandlerField != null) {
                                if (CRASH_HANDLER_ENABLED_CONFIG_KEY.equals(crashHandlerField)) {
                                    configs.crashHandler.enabled = iter.readBoolean();
                                } else {
                                    iter.skip();
                                }
                                crashHandlerField = iter.readObject();
                            }
                            break;
                        }
                        case "startup_moment": {
                            configs.startupMoment = new SdkConfigs.StartupMoment();
                            String startupMomentField = iter.readObject();
                            while (startupMomentField != null) {
                                switch (startupMomentField) {
                                    case "automatically_end": {
                                        configs.startupMoment.automaticallyEnd = iter.readBoolean();
                                        break;
                                    }
                                    case "take_screenshot": {
                                        configs.startupMoment.takeScreenshot = iter.readBoolean();
                                        break;
                                    }
                                    default: {
                                        iter.skip();
                                    }
                                }
                                startupMomentField = iter.readObject();
                            }
                            break;
                        }
                        case "networking": {
                            configs.networking = new SdkConfigs.Networking();
                            String networkingField = iter.readObject();
                            while (networkingField != null) {
                                switch (networkingField) {
                                    case "capture_request_content_length": {
                                        configs.networking.captureRequestContentLength = iter.readBoolean();
                                        break;
                                    }
                                    case "default_capture_limit": {
                                        if (iter.readNull()) break;
                                        configs.networking.defaultCaptureLimit = iter.readInt();
                                        break;
                                    }
                                    case "domains": {
                                        ArrayList domains = new ArrayList();
                                        iter.readArrayCB((domainObject, attachment) -> {
                                            String obj;
                                            String domainField = obj = domainObject.readObject();
                                            while (domainField != null) {
                                                SdkConfigs.Networking.Domain domain = new SdkConfigs.Networking.Domain();
                                                switch (domainField) {
                                                    case "domain_name": {
                                                        domain.domain = domainObject.readString();
                                                        break;
                                                    }
                                                    case "domain_limit": {
                                                        if (iter.readNull()) break;
                                                        domain.limit = domainObject.readInt();
                                                        break;
                                                    }
                                                    default: {
                                                        domainObject.skip();
                                                    }
                                                }
                                                if (domain.getDomain() != null) {
                                                    domains.add(domain);
                                                }
                                                domainField = domainObject.readObject();
                                            }
                                            return true;
                                        }, String.class);
                                        configs.networking.domains = domains;
                                        break;
                                    }
                                    case "trace_id_header": {
                                        configs.networking.traceIdHeader = iter.readString();
                                        break;
                                    }
                                    case "disabled_url_patterns": {
                                        ArrayList disabledUrls = new ArrayList();
                                        iter.readArrayCB((patter, attachment) -> {
                                            String urlPattern = patter.readString();
                                            if (urlPattern != null) {
                                                disabledUrls.add(urlPattern);
                                                return true;
                                            }
                                            return false;
                                        }, String.class);
                                        configs.networking.disabledUrlPatterns = disabledUrls;
                                        break;
                                    }
                                    case "enable_native_monitoring": {
                                        configs.networking.enableNativeMonitoring = iter.readBoolean();
                                        break;
                                    }
                                    default: {
                                        iter.skip();
                                    }
                                }
                                networkingField = iter.readObject();
                            }
                            break;
                        }
                        case "session": {
                            configs.sessionConfig = new SdkConfigs.SessionConfig();
                            String sessionConfigField = iter.readObject();
                            while (sessionConfigField != null) {
                                switch (sessionConfigField) {
                                    case "async_end": {
                                        configs.sessionConfig.asyncEnd = iter.readBoolean();
                                        break;
                                    }
                                    case "max_session_seconds": {
                                        if (iter.readNull()) break;
                                        configs.sessionConfig.maxSessionSeconds = iter.readInt();
                                        break;
                                    }
                                    default: {
                                        iter.skip();
                                    }
                                }
                                sessionConfigField = iter.readObject();
                            }
                            break;
                        }
                        case "taps": {
                            configs.taps = new SdkConfigs.Taps();
                            String tapsField = iter.readObject();
                            while (tapsField != null) {
                                if (TAPS_CAPTURE_COORDINATES_CONFIG_KEY.equals(tapsField)) {
                                    configs.taps.captureCoordinates = iter.readBoolean();
                                } else {
                                    iter.skip();
                                }
                                tapsField = iter.readObject();
                            }
                            break;
                        }
                        case "webview": {
                            configs.webView = new SdkConfigs.WebView();
                            String webviewField = iter.readObject();
                            while (webviewField != null) {
                                switch (webviewField) {
                                    case "capture_query_params": {
                                        configs.webView.captureQueryParams = iter.readBoolean();
                                        break;
                                    }
                                    case "enable": {
                                        configs.webView.captureWebViews = iter.readBoolean();
                                        break;
                                    }
                                    default: {
                                        iter.skip();
                                    }
                                }
                                webviewField = iter.readObject();
                            }
                            break;
                        }
                        default: {
                            iter.skip();
                        }
                    }
                    field = iter.readObject();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logError("Failed to parse Embrace config from config json file.", ex);
            }
        } else {
            configs = new SdkConfigs();
        }
        List<String> nonDefaultValues = configs.getNonDefaultValues();
        for (String nonDefaultValue : nonDefaultValues) {
            EmbraceLogger.logInfo("Custom config value " + nonDefaultValue);
        }
        return new LocalConfig(appId, ndkEnabled, configs);
    }

    private static int getResourcesIdentifier(Context context, String configProperty, String type) {
        Resources resources = context.getResources();
        return resources.getIdentifier(configProperty, type, context.getPackageName());
    }

    String getAppId() {
        return this.appId;
    }

    Boolean isNdkEnabled() {
        return this.ndkEnabled;
    }

    public SdkConfigs getConfigurations() {
        return this.configs;
    }

    boolean isUrlDisabled(String url) {
        Set<Pattern> patterns = this.getConfigurations().getNetworking().getDisabledUrlRegexPatterns();
        return StreamSupport.stream(patterns).anyMatch(p -> p.matcher(url).find());
    }

    static class SdkConfigs {
        @SerializedName(value="app")
        private App app;
        @SerializedName(value="base_urls")
        private BaseUrls baseUrls;
        @SerializedName(value="crash_handler")
        private CrashHandler crashHandler;
        @SerializedName(value="startup_moment")
        private StartupMoment startupMoment;
        @SerializedName(value="networking")
        private Networking networking;
        @SerializedName(value="session")
        private SessionConfig sessionConfig;
        @SerializedName(value="taps")
        private Taps taps;
        @SerializedName(value="webview")
        private WebView webView;

        SdkConfigs() {
            this(null, null, null, null, null, null, null, null);
        }

        SdkConfigs(App app, BaseUrls baseUrls, CrashHandler crashHandler, StartupMoment startupMoment, Networking networking, SessionConfig sessionConfig, Taps taps, WebView webView) {
            this.app = (App)Optional.fromNullable((Object)app).or((Object)new App());
            this.baseUrls = (BaseUrls)Optional.fromNullable((Object)baseUrls).or((Object)new BaseUrls());
            this.crashHandler = (CrashHandler)Optional.fromNullable((Object)crashHandler).or((Object)new CrashHandler());
            this.startupMoment = (StartupMoment)Optional.fromNullable((Object)startupMoment).or((Object)new StartupMoment());
            this.networking = (Networking)Optional.fromNullable((Object)networking).or((Object)new Networking());
            this.sessionConfig = (SessionConfig)Optional.fromNullable((Object)sessionConfig).or((Object)new SessionConfig());
            this.taps = (Taps)Optional.fromNullable((Object)taps).or((Object)new Taps());
            this.webView = (WebView)Optional.fromNullable((Object)webView).or((Object)new WebView());
        }

        App getApp() {
            return this.app;
        }

        BaseUrls getBaseUrls() {
            return this.baseUrls;
        }

        CrashHandler getCrashHandler() {
            return this.crashHandler;
        }

        StartupMoment getStartupMoment() {
            return this.startupMoment;
        }

        Networking getNetworking() {
            return this.networking;
        }

        SessionConfig getSessionConfig() {
            return this.sessionConfig;
        }

        Taps getTaps() {
            return this.taps;
        }

        public WebView getWebViewConfig() {
            return this.webView;
        }

        List<String> getNonDefaultValues() {
            ArrayList<String> nonDefaultValues = new ArrayList<String>();
            List<ConfigElement> elements = Arrays.asList(this.app, this.baseUrls, this.crashHandler, this.networking, this.sessionConfig, this.startupMoment, this.taps, this.webView);
            for (ConfigElement element : elements) {
                if (element.getNonDefaultValues().isEmpty()) continue;
                nonDefaultValues.addAll(element.getNonDefaultValues());
            }
            return nonDefaultValues;
        }

        static class WebView
        implements ConfigElement {
            static final Boolean WEB_VIEW_CAPTURE_DEFAULT = true;
            static final Boolean WEB_VIEW_QUERY_PARAMS_CAPTURE_DEFAULT = true;
            @SerializedName(value="enable")
            private Boolean captureWebViews;
            @SerializedName(value="capture_query_params")
            private Boolean captureQueryParams;

            WebView() {
                this(null, null);
            }

            public WebView(Boolean captureWebViews, Boolean captureQueryParams) {
                this.captureWebViews = (Boolean)Optional.fromNullable((Object)captureWebViews).or((Object)WEB_VIEW_CAPTURE_DEFAULT);
                this.captureQueryParams = (Boolean)Optional.fromNullable((Object)captureQueryParams).or((Object)WEB_VIEW_QUERY_PARAMS_CAPTURE_DEFAULT);
            }

            public Boolean isWebViewsCaptureEnabled() {
                return this.captureWebViews;
            }

            public Boolean isQueryParamsCaptureEnabled() {
                return this.captureQueryParams;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.captureWebViews.equals(WEB_VIEW_CAPTURE_DEFAULT)) {
                    nonDefaultValues.add("web_view.enabled: " + this.captureWebViews);
                }
                if (!this.captureQueryParams.equals(WEB_VIEW_QUERY_PARAMS_CAPTURE_DEFAULT)) {
                    nonDefaultValues.add("web_view.capture_query_params: " + this.captureQueryParams);
                }
                return nonDefaultValues;
            }
        }

        static class Taps
        implements ConfigElement {
            static final Boolean CAPTURE_COORDINATES_DEFAULT = true;
            @SerializedName(value="capture_coordinates")
            private Boolean captureCoordinates;

            Taps() {
                this(null);
            }

            Taps(Boolean captureCoordinates) {
                this.captureCoordinates = (Boolean)Optional.fromNullable((Object)captureCoordinates).or((Object)CAPTURE_COORDINATES_DEFAULT);
            }

            Boolean getCaptureCoordinates() {
                return this.captureCoordinates;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.captureCoordinates.equals(CAPTURE_COORDINATES_DEFAULT)) {
                    nonDefaultValues.add("taps.capture_coordinates: " + this.captureCoordinates);
                }
                return nonDefaultValues;
            }
        }

        static class SessionConfig
        implements ConfigElement {
            static final int MINIMUM_SESSION_SECONDS_DEFAULT = 60;
            static final boolean ASYNC_END_DEFAULT = false;
            @SerializedName(value="max_session_seconds")
            private Integer maxSessionSeconds;
            @SerializedName(value="async_end")
            private Boolean asyncEnd;

            SessionConfig() {
                this(null, null);
            }

            SessionConfig(Integer maxSessionSeconds, Boolean asyncEnd) {
                this.maxSessionSeconds = maxSessionSeconds;
                this.asyncEnd = asyncEnd;
            }

            Optional<Integer> getMaxSessionSeconds() {
                if (this.maxSessionSeconds != null) {
                    if (this.maxSessionSeconds >= 60) {
                        return Optional.of((Object)this.maxSessionSeconds);
                    }
                    EmbraceLogger.logWarning("Automatic end session disabled. Config max_session_seconds should be more than 60 seconds.");
                    return Optional.absent();
                }
                return Optional.absent();
            }

            Boolean getAsyncEnd() {
                return this.asyncEnd != null ? this.asyncEnd : false;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (this.maxSessionSeconds != null) {
                    nonDefaultValues.add("session.max_session_seconds: " + this.maxSessionSeconds);
                }
                if (this.getAsyncEnd().booleanValue()) {
                    nonDefaultValues.add("session.async_end: " + this.getAsyncEnd());
                }
                return nonDefaultValues;
            }
        }

        static class Networking
        implements ConfigElement {
            static final String CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE = "x-emb-trace-id";
            static final Boolean CAPTURE_REQUEST_CONTENT_LENGTH = false;
            static final Boolean ENABLE_NATIVE_MONITORING_DEFAULT = true;
            @SerializedName(value="default_capture_limit")
            private Integer defaultCaptureLimit;
            @SerializedName(value="domains")
            private List<Domain> domains;
            @SerializedName(value="trace_id_header")
            private String traceIdHeader;
            @SerializedName(value="capture_request_content_length")
            private Boolean captureRequestContentLength;
            @SerializedName(value="disabled_url_patterns")
            private List<String> disabledUrlPatterns;
            @SerializedName(value="enable_native_monitoring")
            private Boolean enableNativeMonitoring;
            private Set<Pattern> disabledUrlRegexPatterns;
            private ArrayList<String> nonDefaultValues;

            Networking() {
                this(null, null, null, null, null, null);
            }

            Networking(String traceIdHeader, Integer defaultCaptureLimit, List<Domain> domains, Boolean captureRequestContentLength, List<String> disabledUrlPatterns, Boolean enableNativeMonitoring) {
                this.traceIdHeader = (String)Optional.fromNullable((Object)traceIdHeader).or((Object)CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE);
                this.defaultCaptureLimit = defaultCaptureLimit;
                this.domains = domains;
                this.captureRequestContentLength = (Boolean)Optional.fromNullable((Object)captureRequestContentLength).or((Object)CAPTURE_REQUEST_CONTENT_LENGTH);
                this.disabledUrlPatterns = disabledUrlPatterns;
                this.enableNativeMonitoring = (Boolean)Optional.fromNullable((Object)enableNativeMonitoring).or((Object)ENABLE_NATIVE_MONITORING_DEFAULT);
            }

            String getTraceIdHeader() {
                return this.traceIdHeader;
            }

            synchronized Set<Pattern> getDisabledUrlRegexPatterns() {
                if (this.disabledUrlRegexPatterns == null) {
                    if (this.disabledUrlPatterns != null) {
                        this.disabledUrlRegexPatterns = new HashSet<Pattern>();
                        for (String url : this.disabledUrlPatterns) {
                            try {
                                this.disabledUrlRegexPatterns.add(Pattern.compile(url));
                            }
                            catch (PatternSyntaxException e) {
                                EmbraceLogger.logError("Skipping invalid blocked URL: " + url, e);
                            }
                        }
                    } else {
                        this.disabledUrlRegexPatterns = Collections.emptySet();
                    }
                }
                return this.disabledUrlRegexPatterns;
            }

            Boolean getCaptureRequestContentLength() {
                return this.captureRequestContentLength;
            }

            public Optional<Integer> getDefaultCaptureLimit() {
                return Optional.fromNullable((Object)this.defaultCaptureLimit);
            }

            public List<Domain> getDomains() {
                return this.domains != null ? this.domains : Collections.emptyList();
            }

            public Boolean isNativeNetworkingMonitoringEnabled() {
                return this.enableNativeMonitoring;
            }

            @Override
            public synchronized List<String> getNonDefaultValues() {
                if (this.nonDefaultValues == null) {
                    this.nonDefaultValues = new ArrayList();
                    if (!this.traceIdHeader.equals(CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE)) {
                        this.nonDefaultValues.add("networking.trace_id_header: " + this.traceIdHeader);
                    }
                    if (!this.captureRequestContentLength.equals(CAPTURE_REQUEST_CONTENT_LENGTH)) {
                        this.nonDefaultValues.add("networking.capture_request_content_length: " + this.captureRequestContentLength);
                    }
                    if (!this.enableNativeMonitoring.equals(ENABLE_NATIVE_MONITORING_DEFAULT)) {
                        this.nonDefaultValues.add("networking.enable_native_monitoring: " + this.enableNativeMonitoring);
                    }
                    if (this.disabledUrlPatterns != null) {
                        for (String pattern : this.disabledUrlPatterns) {
                            this.nonDefaultValues.add("networking.disabled_url_pattern: " + pattern);
                        }
                    }
                }
                return this.nonDefaultValues;
            }

            public static class Domain {
                @SerializedName(value="domain_name")
                private String domain;
                @SerializedName(value="domain_limit")
                private Integer limit;

                Domain() {
                    this(null, null);
                }

                Domain(String domain, Integer limit) {
                    this.domain = domain;
                    this.limit = limit;
                }

                String getDomain() {
                    return this.domain;
                }

                Optional<Integer> getLimit() {
                    return Optional.of((Object)this.limit);
                }
            }
        }

        static class StartupMoment
        implements ConfigElement {
            static final Boolean AUTOMATICALLY_END_DEFAULT = true;
            static final Boolean TAKE_SCREENSHOT_DEFAULT = true;
            @SerializedName(value="automatically_end")
            private Boolean automaticallyEnd;
            @SerializedName(value="take_screenshot")
            private Boolean takeScreenshot;

            StartupMoment() {
                this(null, null);
            }

            StartupMoment(Boolean automaticallyEnd, Boolean takeScreenshot) {
                this.automaticallyEnd = (Boolean)Optional.fromNullable((Object)automaticallyEnd).or((Object)AUTOMATICALLY_END_DEFAULT);
                this.takeScreenshot = (Boolean)Optional.fromNullable((Object)takeScreenshot).or((Object)TAKE_SCREENSHOT_DEFAULT);
            }

            Boolean getAutomaticallyEnd() {
                return this.automaticallyEnd;
            }

            Boolean getTakeScreenshot() {
                return this.takeScreenshot;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.automaticallyEnd.equals(AUTOMATICALLY_END_DEFAULT)) {
                    nonDefaultValues.add("startup_moment.automatically_end: " + this.automaticallyEnd);
                }
                if (!this.takeScreenshot.equals(TAKE_SCREENSHOT_DEFAULT)) {
                    nonDefaultValues.add("startup_moment.take_screenshot: " + this.takeScreenshot);
                }
                return nonDefaultValues;
            }
        }

        static class CrashHandler
        implements ConfigElement {
            static final Boolean ENABLED_DEFAULT = true;
            @SerializedName(value="enabled")
            private Boolean enabled;

            CrashHandler() {
                this(null);
            }

            CrashHandler(Boolean enabled) {
                this.enabled = (Boolean)Optional.fromNullable((Object)enabled).or((Object)ENABLED_DEFAULT);
            }

            Boolean getEnabled() {
                return this.enabled;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.enabled.equals(ENABLED_DEFAULT)) {
                    nonDefaultValues.add("crash_handler.enabled: " + this.enabled);
                }
                return nonDefaultValues;
            }
        }

        static class BaseUrls
        implements ConfigElement {
            static final String CONFIG_DEFAULT = "https://config.emb-api.com";
            static final String DATA_DEFAULT = "https://data.emb-api.com";
            static final String DATA_DEV_DEFAULT = "https://data-dev.emb-api.com";
            static final String IMAGES_DEFAULT = "https://images.emb-api.com";
            @SerializedName(value="data")
            private String data;
            @SerializedName(value="data_dev")
            private String dataDev;
            @SerializedName(value="config")
            private String config;
            @SerializedName(value="images")
            private String images;

            BaseUrls() {
                this(null, null, null, null);
            }

            BaseUrls(String config, String data, String dataDev, String images) {
                this.config = (String)Optional.fromNullable((Object)config).or((Object)CONFIG_DEFAULT);
                this.data = (String)Optional.fromNullable((Object)data).or((Object)DATA_DEFAULT);
                this.dataDev = (String)Optional.fromNullable((Object)dataDev).or((Object)DATA_DEV_DEFAULT);
                this.images = (String)Optional.fromNullable((Object)images).or((Object)IMAGES_DEFAULT);
            }

            String getConfig() {
                return this.config;
            }

            String getData() {
                return this.data;
            }

            String getDataDev() {
                return this.dataDev;
            }

            String getImages() {
                return this.images;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.config.equals(CONFIG_DEFAULT)) {
                    nonDefaultValues.add("base_urls.config: " + this.config);
                }
                if (!this.data.equals(DATA_DEFAULT)) {
                    nonDefaultValues.add("base_urls.data: " + this.data);
                }
                if (!this.dataDev.equals(DATA_DEV_DEFAULT)) {
                    nonDefaultValues.add("base_urls.data_dev: " + this.dataDev);
                }
                if (!this.images.equals(IMAGES_DEFAULT)) {
                    nonDefaultValues.add("base_urls.images: " + this.images);
                }
                return nonDefaultValues;
            }
        }

        static class App
        implements ConfigElement {
            static final boolean REPORT_DISK_USAGE_DEFAULT = true;
            @SerializedName(value="report_disk_usage")
            private boolean reportDiskUsage;

            App() {
                this(null);
            }

            App(Boolean reportDiskUsage) {
                this.reportDiskUsage = (Boolean)Optional.fromNullable((Object)reportDiskUsage).or((Object)true);
            }

            boolean getReportDiskUsage() {
                return this.reportDiskUsage;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.reportDiskUsage) {
                    nonDefaultValues.add("app.report_disk_usage: " + this.reportDiskUsage);
                }
                return nonDefaultValues;
            }
        }

        static interface ConfigElement {
            public List<String> getNonDefaultValues();
        }
    }
}

