/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.Uuid;
import java.util.List;
import java.util.Map;

public final class Event {
    @SerializedName(value="n")
    private final String name;
    @SerializedName(value="li")
    private final String messageId;
    @SerializedName(value="id")
    private final String eventId;
    @SerializedName(value="si")
    private final String sessionId;
    @SerializedName(value="t")
    private final EmbraceEvent.Type type;
    @SerializedName(value="ts")
    private final Long timestamp;
    @SerializedName(value="th")
    private final Long lateThreshold;
    @SerializedName(value="sc")
    private final boolean screenshotTaken;
    @SerializedName(value="du")
    private final Long duration;
    @SerializedName(value="st")
    private final String appState;
    @SerializedName(value="he")
    private final Boolean isException;
    @SerializedName(value="pr")
    private final Map<String, Object> customProperties;
    @SerializedName(value="sp")
    private final Map<String, String> sessionProperties;
    private final transient List<String> activeEventIds;

    private Event(Builder builder) {
        this.name = builder.name;
        this.eventId = builder.eventId;
        this.messageId = builder.messageId;
        this.sessionId = builder.sessionId;
        this.type = builder.type;
        this.timestamp = builder.timestamp;
        this.lateThreshold = builder.lateThreshold;
        this.screenshotTaken = builder.screenshotTaken;
        this.duration = builder.duration;
        this.appState = builder.appState;
        this.customProperties = builder.customProperties;
        this.activeEventIds = builder.activeEventIds;
        this.isException = builder.isException;
        this.sessionProperties = builder.sessionProperties;
    }

    public String getName() {
        return this.name;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public EmbraceEvent.Type getType() {
        return this.type;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Long getLateThreshold() {
        return this.lateThreshold;
    }

    public boolean isScreenshotTaken() {
        return this.screenshotTaken;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getAppState() {
        return this.appState;
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<String> getActiveEventIds() {
        return this.activeEventIds;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String eventId = Uuid.getEmbUuid();
        private String messageId;
        private String sessionId;
        private EmbraceEvent.Type type;
        private Long timestamp = System.currentTimeMillis();
        private Long lateThreshold;
        private boolean screenshotTaken;
        private Long duration;
        private String appState;
        private Boolean isException;
        private Map<String, Object> customProperties;
        private Map<String, String> sessionProperties;
        private List<String> activeEventIds;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withType(EmbraceEvent.Type type) {
            this.type = type;
            return this;
        }

        public Builder withTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withLateThreshold(Long lateThreshold) {
            this.lateThreshold = lateThreshold;
            return this;
        }

        public Builder withScreenshotTaken(boolean screenshotTaken) {
            this.screenshotTaken = screenshotTaken;
            return this;
        }

        public Builder withDuration(Long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withAppState(String appState) {
            this.appState = appState;
            return this;
        }

        public Builder withIsException(Boolean isException) {
            this.isException = isException;
            return this;
        }

        public Builder withCustomProperties(Map<String, Object> customProperties) {
            this.customProperties = customProperties;
            return this;
        }

        public Builder withSessionProperties(Map<String, String> sessionProperties) {
            this.sessionProperties = sessionProperties;
            return this;
        }

        public Builder withActiveEventIds(List<String> activeEventIds) {
            this.activeEventIds = activeEventIds;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

