/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.ExceptionError;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

final class EmbraceExceptionService {
    private final EmbraceActivityService activityService;
    private ConfigService configService;
    private ExceptionError exceptionError;
    private static final Class[] ignoredExceptionClasses = new Class[]{BindException.class, ConnectException.class, HttpRetryException.class, NoRouteToHostException.class, PortUnreachableException.class, ProtocolException.class, SocketException.class, SocketTimeoutException.class, UnknownHostException.class, UnknownServiceException.class};
    private HashSet ignoredExceptions;
    private HashSet ignoredExceptionStrings;

    EmbraceExceptionService(EmbraceActivityService activityService) {
        this.activityService = (EmbraceActivityService)Preconditions.checkNotNull((Object)activityService);
        this.configService = null;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    synchronized void handleExceptionError(Throwable throwable) {
        if (this.ignoredExceptions == null) {
            this.ignoredExceptions = new HashSet<Class>(Arrays.asList(ignoredExceptionClasses));
        }
        if (this.ignoredExceptions.contains(throwable.getClass())) {
            return;
        }
        String message = throwable.getMessage();
        if (this.ignoredExceptionStrings == null) {
            this.ignoredExceptionStrings = new HashSet((Collection)StreamSupport.stream(Arrays.asList(ignoredExceptionClasses)).map(c -> c.getName()).collect(Collectors.toList()));
        }
        if (message != null && this.ignoredExceptionStrings.contains(message.split(":")[0])) {
            return;
        }
        if (this.exceptionError == null) {
            this.exceptionError = new ExceptionError();
        }
        if (this.configService == null || this.configService.isInternalExceptionCaptureEnabled()) {
            this.exceptionError.addException(throwable, this.getApplicationState());
        }
    }

    private String getApplicationState() {
        if (this.activityService.isInBackground()) {
            return "background";
        }
        return "active";
    }

    ExceptionError getCurrentExceptionError() {
        return this.exceptionError;
    }

    synchronized void resetExceptionErrorObject() {
        this.exceptionError = null;
    }
}

