/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.MessageUtils;

final class DeviceInfo {
    @SerializedName(value="dm")
    private final String manufacturer;
    @SerializedName(value="do")
    private final String model;
    @SerializedName(value="da")
    private final String architecture;
    @SerializedName(value="jb")
    private final Boolean jailbroken;
    @SerializedName(value="lc")
    private final String locale;
    @SerializedName(value="ms")
    private final Long internalStorageTotalCapacity;
    @SerializedName(value="os")
    private final String operatingSystemType;
    @SerializedName(value="ov")
    private final String operatingSystemVersion;
    @SerializedName(value="oc")
    private final Integer operatingSystemVersionCode;
    @SerializedName(value="sr")
    private final String screenResolution;
    @SerializedName(value="tz")
    private final String timezoneDescription;
    @SerializedName(value="up")
    private final Long uptime;

    private DeviceInfo(Builder builder) {
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.architecture = builder.architecture;
        this.jailbroken = builder.jailbroken;
        this.locale = builder.locale;
        this.internalStorageTotalCapacity = builder.internalStorageTotalCapacity;
        this.operatingSystemType = builder.operatingSystemType;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.operatingSystemVersionCode = builder.operatingSystemVersionCode;
        this.screenResolution = builder.screenResolution;
        this.timezoneDescription = builder.timezoneDescription;
        this.uptime = builder.uptime;
    }

    public String toJson() {
        return String.format("{\"dm\": %s,\"do\": %s,\"da\":%s,\"jb\":%s,\"lc\":%s,\"ms\":%s,\"os\":%s,\"ov\":%s,\"oc\":%s,\"sr\":%s,\"tz\":%s,\"up\":%s}", MessageUtils.withNull(this.manufacturer), MessageUtils.withNull(this.model), MessageUtils.withNull(this.architecture), MessageUtils.boolToStr(this.jailbroken), MessageUtils.withNull(this.locale), MessageUtils.withNull(this.internalStorageTotalCapacity), MessageUtils.withNull(this.operatingSystemType), MessageUtils.withNull(this.operatingSystemVersion), MessageUtils.withNull(this.operatingSystemVersionCode), MessageUtils.withNull(this.screenResolution), MessageUtils.withNull(this.timezoneDescription), MessageUtils.withNull(this.uptime));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String manufacturer;
        private String model;
        private String architecture;
        private Boolean jailbroken;
        private String locale;
        private Long internalStorageTotalCapacity;
        private String operatingSystemType;
        private String operatingSystemVersion;
        private Integer operatingSystemVersionCode;
        private String screenResolution;
        private String timezoneDescription;
        private Long uptime;

        private Builder() {
        }

        public Builder withManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withArchitecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public Builder withJailbroken(Boolean jailbroken) {
            this.jailbroken = jailbroken;
            return this;
        }

        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder withInternalStorageTotalCapacity(Long internalStorageTotalCapacity) {
            this.internalStorageTotalCapacity = internalStorageTotalCapacity;
            return this;
        }

        public Builder withOperatingSystemType(String operatingSystemType) {
            this.operatingSystemType = operatingSystemType;
            return this;
        }

        public Builder withOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public Builder withOperatingSystemVersionCode(Integer operatingSystemVersionCode) {
            this.operatingSystemVersionCode = operatingSystemVersionCode;
            return this;
        }

        public Builder withScreenResolution(String screenResolution) {
            this.screenResolution = screenResolution;
            return this;
        }

        public Builder withTimezoneDescription(String timezoneDescription) {
            this.timezoneDescription = timezoneDescription;
            return this;
        }

        public Builder withUptime(Long uptime) {
            this.uptime = uptime;
            return this;
        }

        public DeviceInfo build() {
            return new DeviceInfo(this);
        }
    }
}

