/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.res.Resources;
import com.fernandocejas.arrow.optional.Optional;

public final class BuildInfo {
    static final String BUILD_INFO_BUILD_ID = "emb_build_id";
    static final String BUILD_INFO_BUILD_TYPE = "emb_build_type";
    static final String BUILD_INFO_BUILD_FLAVOR = "emb_build_flavor";
    private static final String RES_TYPE_STRING = "string";
    private final String buildId;
    private final String buildType;
    private final String buildFlavor;

    private BuildInfo(String buildId, String buildType, String buildFlavor) {
        this.buildId = buildId;
        this.buildType = buildType;
        this.buildFlavor = (String)Optional.fromNullable((Object)buildFlavor).orNull();
    }

    static BuildInfo fromResources(Context context) {
        return new BuildInfo(BuildInfo.getBuildResource(context, BUILD_INFO_BUILD_ID, RES_TYPE_STRING), BuildInfo.getBuildResource(context, BUILD_INFO_BUILD_TYPE, RES_TYPE_STRING), BuildInfo.getBuildResource(context, BUILD_INFO_BUILD_FLAVOR, RES_TYPE_STRING));
    }

    private static String getBuildResource(Context context, String buildProperty, String type) {
        try {
            Resources resources = context.getResources();
            int resourceId = resources.getIdentifier(buildProperty, type, context.getPackageName());
            if (buildProperty.equals(BUILD_INFO_BUILD_FLAVOR) && resourceId == 0) {
                return null;
            }
            return resources.getString(resourceId);
        }
        catch (Resources.NotFoundException | NullPointerException ex) {
            throw new IllegalArgumentException(String.format("No resource found for %s property. Failed to create build info.", buildProperty), ex);
        }
    }

    String getBuildId() {
        return this.buildId;
    }

    String getBuildType() {
        return this.buildType;
    }

    String getBuildFlavor() {
        return this.buildFlavor;
    }
}

