/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.MessageUtils;

final class AppInfo {
    @SerializedName(value="v")
    private final String appVersion;
    @SerializedName(value="f")
    private final Integer appFramework;
    @SerializedName(value="bi")
    private final String buildId;
    @SerializedName(value="bt")
    private final String buildType;
    @SerializedName(value="fl")
    private final String buildFlavor;
    @SerializedName(value="e")
    private final String environment;
    @SerializedName(value="vu")
    private final boolean appUpdated;
    @SerializedName(value="vul")
    private final boolean appUpdatedThisLaunch;
    @SerializedName(value="bv")
    private final String bundleVersion;
    @SerializedName(value="ou")
    private final boolean osUpdated;
    @SerializedName(value="oul")
    private final boolean osUpdatedThisLaunch;
    @SerializedName(value="sdk")
    private final String sdkVersion;
    @SerializedName(value="sdc")
    private final String sdkSimpleVersion;
    @SerializedName(value="rn")
    private final String reactNativeBundlePath;
    @SerializedName(value="jsp")
    private final String javaScriptPatchNumber;
    @SerializedName(value="rnv")
    private final String reactNativeVersion;
    @SerializedName(value="unv")
    private final String unityVersion;
    @SerializedName(value="ubg")
    private final String buildGUID;

    private AppInfo(Builder builder) {
        this.appFramework = builder.appFramework;
        this.appVersion = builder.appVersion;
        this.buildId = builder.buildId;
        this.buildType = builder.buildType;
        this.buildFlavor = builder.buildFlavor;
        this.environment = builder.environment;
        this.appUpdated = builder.appUpdated;
        this.appUpdatedThisLaunch = builder.appUpdatedThisLaunch;
        this.bundleVersion = builder.bundleVersion;
        this.osUpdated = builder.osUpdated;
        this.osUpdatedThisLaunch = builder.osUpdatedThisLaunch;
        this.sdkVersion = builder.sdkVersion;
        this.sdkSimpleVersion = builder.sdkSimpleVersion;
        this.reactNativeBundlePath = builder.reactNativeBundlePath;
        this.javaScriptPatchNumber = builder.javaScriptPatch;
        this.reactNativeVersion = builder.reactNativeVersion;
        this.unityVersion = builder.unityVersion;
        this.buildGUID = builder.buildGUID;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    public String toJson() {
        return String.format("{\"v\": %s,\"f\": %s,\"bi\":%s,\"bt\":%s,\"fl\":%s,\"e\":%s,\"vu\":%s,\"vul\":%s,\"bv\":%s,\"ou\":%s,\"oul\":%s,\"sdk\":%s,\"sdc\":%s,\"rn\":%s,\"jsp\":%s,\"rnv\":%s,\"unv\":%s,\"ubg\":%s}", MessageUtils.withNull(this.appVersion), this.appFramework, MessageUtils.withNull(this.buildId), MessageUtils.withNull(this.buildType), MessageUtils.withNull(this.buildFlavor), MessageUtils.withNull(this.environment), MessageUtils.boolToStr(this.appUpdated), MessageUtils.boolToStr(this.appUpdatedThisLaunch), MessageUtils.withNull(this.bundleVersion), MessageUtils.boolToStr(this.osUpdated), MessageUtils.boolToStr(this.osUpdatedThisLaunch), MessageUtils.withNull(this.sdkVersion), MessageUtils.withNull(this.sdkSimpleVersion), MessageUtils.withNull(this.reactNativeBundlePath), MessageUtils.withNull(this.javaScriptPatchNumber), MessageUtils.withNull(this.reactNativeVersion), MessageUtils.withNull(this.unityVersion), MessageUtils.withNull(this.buildGUID));
    }

    static final class Builder {
        private Integer appFramework;
        private String appVersion;
        private String buildId;
        private String buildType;
        private String buildFlavor;
        private String environment;
        private boolean appUpdated;
        private boolean appUpdatedThisLaunch;
        private String bundleVersion;
        private boolean osUpdated;
        private boolean osUpdatedThisLaunch;
        private String sdkVersion;
        private String sdkSimpleVersion;
        private String reactNativeBundlePath;
        private String javaScriptPatch;
        private String reactNativeVersion;
        private String unityVersion;
        private String buildGUID;

        private Builder() {
        }

        Builder withAppFramework(Embrace.AppFramework appFramework) {
            this.appFramework = appFramework.getValue();
            return this;
        }

        Builder withAppVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        Builder withBuildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        Builder withBuildType(String buildType) {
            this.buildType = buildType;
            return this;
        }

        Builder withBuildFlavor(String buildFlavor) {
            this.buildFlavor = buildFlavor;
            return this;
        }

        Builder withEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        Builder withAppUpdated(boolean appUpdated) {
            this.appUpdated = appUpdated;
            return this;
        }

        Builder withAppUpdatedThisLaunch(boolean appUpdatedThisLaunch) {
            this.appUpdatedThisLaunch = appUpdatedThisLaunch;
            return this;
        }

        Builder withBundleVersion(String bundleVersion) {
            this.bundleVersion = bundleVersion;
            return this;
        }

        Builder withOsUpdated(boolean osUpdated) {
            this.osUpdated = osUpdated;
            return this;
        }

        Builder withOsUpdatedThisLaunch(boolean osUpdatedThisLaunch) {
            this.osUpdatedThisLaunch = osUpdatedThisLaunch;
            return this;
        }

        Builder withSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        Builder withSdkSimpleVersion(String sdkSimpleVersion) {
            this.sdkSimpleVersion = sdkSimpleVersion;
            return this;
        }

        Builder withReactNativeBundlePath(String reactNativeBundlePath) {
            this.reactNativeBundlePath = reactNativeBundlePath;
            return this;
        }

        Builder withJavaScriptPatchNumber(String number) {
            this.javaScriptPatch = number;
            return this;
        }

        Builder withReactNativeVersion(String version) {
            this.reactNativeVersion = version;
            return this;
        }

        Builder withUnityVersion(String version) {
            this.unityVersion = version;
            return this;
        }

        Builder withUnityBuildId(String buildId) {
            this.buildGUID = buildId;
            return this;
        }

        AppInfo build() {
            return new AppInfo(this);
        }
    }
}

