/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Debug;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.strings.Charsets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.embrace.android.embracesdk.ApiClientRetryWorker;
import io.embrace.android.embracesdk.ApiRequest;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.networking.EmbraceConnection;
import io.embrace.android.embracesdk.networking.EmbraceUrl;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import java9.util.function.BiConsumer;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

class ApiClient
implements Closeable {
    static final int MESSAGE_VERSION = 13;
    private static final int CONFIG_API_VERSION = 2;
    private static final int API_VERSION = 1;
    private static final String SCREENSHOT_URL_FORMAT = "%s/%s/%s/%s.jpg";
    private static final String URL_FORMAT = "%s/v%s/%s";
    private static final String CONFIG_URL_FORMAT = "%s?appId=%s&osVersion=%s&appVersion=%s&deviceId=%s";
    private static final String ID_HEADER_FORMAT = "%s:%s";
    private final String screenshotUrl;
    private final String configBaseUrl;
    private final String appId;
    private final String deviceId;
    private final String operatingSystemCode = String.format(Locale.US, "%d.0.0", MetadataUtils.getOperatingSystemVersionCode());
    private final BackgroundWorker worker = BackgroundWorker.ofSingleThread("API Client");
    private final Gson gson = new Gson();
    private final ScheduledWorker retryWorker = ScheduledWorker.ofSingleThread("API Retry");
    private final LocalConfig localConfig;
    private final MetadataService metadataService;
    private final CacheService cacheService;
    private final boolean enableIntegrationTesting;
    private ApiClientRetryWorker<SessionMessage> sessionRetryWorker;
    private ApiClientRetryWorker<EventMessage> eventRetryWorker;
    private String coreBaseUrl;
    private String appVersion;

    ApiClient(LocalConfig localConfig, MetadataService metadataService, CacheService cacheService, boolean enableIntegrationTesting) {
        this.localConfig = (LocalConfig)Preconditions.checkNotNull((Object)localConfig, (Object)"localConfig must not be null");
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService, (Object)"metadataService must not be null");
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService, (Object)"cacheService must not be null");
        this.enableIntegrationTesting = enableIntegrationTesting;
        this.configBaseUrl = String.format(URL_FORMAT, localConfig.getConfigurations().getBaseUrls().getConfig(), 2, "config");
        this.screenshotUrl = String.format(URL_FORMAT, localConfig.getConfigurations().getBaseUrls().getImages(), 1, "screenshot");
        this.appId = metadataService.getAppId();
        this.deviceId = metadataService.getDeviceId();
    }

    private synchronized ApiClientRetryWorker<SessionMessage> getSessionRetryWorker() {
        if (this.sessionRetryWorker == null) {
            this.sessionRetryWorker = new ApiClientRetryWorker<SessionMessage>(SessionMessage.class, this.cacheService, this, this.retryWorker);
        }
        return this.sessionRetryWorker;
    }

    private synchronized ApiClientRetryWorker<EventMessage> getEventRetryWorker() {
        if (this.eventRetryWorker == null) {
            this.eventRetryWorker = new ApiClientRetryWorker<EventMessage>(EventMessage.class, this.cacheService, this, this.retryWorker);
        }
        return this.eventRetryWorker;
    }

    private synchronized String getCoreBaseUrl() {
        if (this.coreBaseUrl == null) {
            this.coreBaseUrl = this.metadataService.isDebug() && this.enableIntegrationTesting && (Debug.isDebuggerConnected() || Debug.waitingForDebugger()) ? this.localConfig.getConfigurations().getBaseUrls().getDataDev() : this.localConfig.getConfigurations().getBaseUrls().getData();
        }
        return this.coreBaseUrl;
    }

    private synchronized String getAppVersion() {
        if (this.appVersion == null) {
            this.appVersion = (String)this.metadataService.getAppVersionCodeForRequest().or((Object)"");
        }
        return this.appVersion;
    }

    Future<Config> getConfig() {
        String url = String.format(CONFIG_URL_FORMAT, this.configBaseUrl, this.appId, this.operatingSystemCode, this.getAppVersion(), this.deviceId);
        EmbraceConnection connection = ApiRequest.newBuilder().withHttpMethod(HttpMethod.GET).withUrl(Unchecked.wrap(() -> EmbraceUrl.getUrl(url))).build().toConnection();
        return this.worker.submit(() -> {
            connection.connect();
            return this.httpCall(connection, Config.class);
        });
    }

    Future<String> sendLogScreenshot(byte[] screenshot, String logId) {
        EmbraceUrl url = Unchecked.wrap(() -> EmbraceUrl.getUrl(String.format(SCREENSHOT_URL_FORMAT, this.screenshotUrl, this.appId, "logs", logId)));
        ApiRequest request = this.screenshotBuilder(url).withLogId(logId).build();
        return this.rawPost(request, screenshot);
    }

    Future<String> sendMomentScreenshot(byte[] screenshot, String eventId) {
        EmbraceUrl url = Unchecked.wrap(() -> EmbraceUrl.getUrl(String.format(SCREENSHOT_URL_FORMAT, this.screenshotUrl, this.appId, "moments", eventId)));
        ApiRequest request = this.screenshotBuilder(url).withEventId(eventId).build();
        return this.rawPost(request, screenshot);
    }

    Future<String> sendSession(SessionMessage sessionMessage) {
        EmbraceUrl url = Unchecked.wrap(() -> EmbraceUrl.getUrl(String.format(URL_FORMAT, this.getCoreBaseUrl(), 1, "log/sessions")));
        ApiRequest request = this.eventBuilder(url).withDeviceId(this.deviceId).withAppId(this.appId).withUrl(url).withHttpMethod(HttpMethod.POST).withContentEncoding("gzip").build();
        return this.jsonPost(request, sessionMessage, SessionMessage.class, this.getSessionRetryWorker()::addFailedCall);
    }

    Future<String> sendLogs(EventMessage eventMessage) {
        Preconditions.checkNotNull((Object)eventMessage.getEvent(), (Object)"event must be set");
        Event event = eventMessage.getEvent();
        Preconditions.checkNotNull((Object)((Object)event.getType()), (Object)"event type must be set");
        Preconditions.checkNotNull((Object)event.getEventId(), (Object)"event ID must be set");
        EmbraceUrl url = Unchecked.wrap(() -> EmbraceUrl.getUrl(String.format(URL_FORMAT, this.getCoreBaseUrl(), 1, "log/logging")));
        String abbreviation = event.getType().getAbbreviation();
        String logIdentifier = String.format(ID_HEADER_FORMAT, abbreviation, event.getMessageId());
        ApiRequest request = this.eventBuilder(url).withLogId(logIdentifier).build();
        return this.sendEvent(eventMessage, request);
    }

    Future<String> sendEvent(EventMessage eventMessage) {
        Preconditions.checkNotNull((Object)eventMessage.getEvent(), (Object)"event must be set");
        Event event = eventMessage.getEvent();
        Preconditions.checkNotNull((Object)((Object)event.getType()), (Object)"event type must be set");
        Preconditions.checkNotNull((Object)event.getEventId(), (Object)"event ID must be set");
        EmbraceUrl url = Unchecked.wrap(() -> EmbraceUrl.getUrl(String.format(URL_FORMAT, this.getCoreBaseUrl(), 1, "log/events")));
        String abbreviation = event.getType().getAbbreviation();
        String eventIdentifier = event.getType().equals((Object)EmbraceEvent.Type.CRASH) ? this.createCrashActiveEventsHeader(abbreviation, event.getActiveEventIds()) : String.format(ID_HEADER_FORMAT, abbreviation, event.getEventId());
        ApiRequest request = this.eventBuilder(url).withEventId(eventIdentifier).build();
        return this.sendEvent(eventMessage, request);
    }

    <T> Future<String> jsonPost(ApiRequest request, T payload, Class<T> clazz, BiConsumer<ApiRequest, T> failureHandler) {
        return this.worker.submit(() -> {
            try {
                byte[] bytes = this.gson.toJson(payload, clazz.getGenericSuperclass()).getBytes(Charsets.UTF_8);
                return this.sendBytes(request, ApiClient.gzip(bytes));
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to post Embrace API call. Will retry.");
                failureHandler.accept((Object)request, payload);
                throw Unchecked.propagate(ex);
            }
        });
    }

    private Future<String> sendEvent(EventMessage eventMessage, ApiRequest request) {
        return this.jsonPost(request, eventMessage, EventMessage.class, this.getEventRetryWorker()::addFailedCall);
    }

    private Future<String> rawPost(ApiRequest request, byte[] payload) {
        return this.worker.submit(() -> this.sendBytes(request, payload));
    }

    private String sendBytes(ApiRequest request, byte[] payload) {
        return Unchecked.wrap(() -> {
            EmbraceConnection connection = request.toConnection();
            if (payload != null) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(payload);
                connection.connect();
            }
            return this.httpCall(connection);
        });
    }

    private static byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream baos = null;
        GZIPOutputStream os = null;
        try {
            baos = new ByteArrayOutputStream();
            os = new GZIPOutputStream(baos);
            os.write(bytes);
            os.finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logDebug("Failed to close streams when gzipping payload", ex);
            }
        }
    }

    private <T> T httpCall(EmbraceConnection connection, Class<T> clazz) {
        this.handleHttpResponseCode(connection);
        return this.readJsonObject(connection, clazz);
    }

    private String httpCall(EmbraceConnection connection) {
        this.handleHttpResponseCode(connection);
        return Unchecked.wrap(() -> this.readString(connection.getInputStream()));
    }

    private void handleHttpResponseCode(EmbraceConnection connection) {
        Integer responseCode = null;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseCode == null || responseCode != 200) {
            if (responseCode != null) {
                String errorMessage = this.readString(connection.getErrorStream());
                EmbraceLogger.logDebug("Embrace API request failed. HTTP response code: " + responseCode + ", message: " + errorMessage);
            }
            throw new IllegalStateException("Failed to retrieve from Embrace server.");
        }
    }

    private <T> T readJsonObject(EmbraceConnection connection, Class<T> clazz) {
        InputStreamReader inputStreamReader = null;
        JsonReader reader = null;
        try {
            inputStreamReader = new InputStreamReader(connection.getInputStream());
            reader = new JsonReader((Reader)inputStreamReader);
            Object object = this.gson.fromJson(reader, clazz);
            return (T)object;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logDebug("Failed to close HTTP reader", ex);
            }
        }
    }

    private String readString(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            int len;
            inputStreamReader = new InputStreamReader(inputStream);
            reader = new BufferedReader(inputStreamReader);
            char[] buffer = new char[4096];
            StringBuilder sb = new StringBuilder();
            while ((len = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logDebug("Failed to close HTTP reader", ex);
            }
        }
    }

    private ApiRequest.Builder screenshotBuilder(EmbraceUrl url) {
        return ApiRequest.newBuilder().withContentType("application/octet-stream").withHttpMethod(HttpMethod.POST).withAppId(this.appId).withDeviceId(this.deviceId).withUrl(url);
    }

    private ApiRequest.Builder eventBuilder(EmbraceUrl url) {
        return ApiRequest.newBuilder().withUrl(url).withHttpMethod(HttpMethod.POST).withAppId(this.appId).withDeviceId(this.deviceId).withContentEncoding("gzip");
    }

    @Override
    public void close() {
        EmbraceLogger.logDebug("Shutting down ApiClient");
        this.retryWorker.close();
        this.worker.close();
    }

    private String createCrashActiveEventsHeader(String abbreviation, List<String> eventIds) {
        String stories = "";
        if (eventIds != null) {
            stories = (String)StreamSupport.stream(eventIds).collect(Collectors.joining((CharSequence)","));
        }
        return String.format(ID_HEADER_FORMAT, abbreviation, stories);
    }
}

