package io.embrace.android.embracesdk;

import java.util.Locale;
import java.util.UUID;

public final class Uuid {
    private Uuid() {
    }

    /**
     * Get the Embrace UUID based on a random UUID.
     *
     * @return the Embrace UUID.
     */
    public static String getEmbUuid() {
        return getEmbUuid(null);
    }

    /**
     * Get the Embrace UUID. If the argument uuid is null, generates the Embrace UUID using a
     * random UUID.
     *
     * @param uuid the uuid.
     * @return the Embrace UUID.
     */
    public static String getEmbUuid(String uuid) {
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
        }

        return String.format("%32.32s", uuid.replaceAll("-", "")).replace(' ', '0')
                .toUpperCase(Locale.getDefault());
    }
}
