package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.List;
import java.util.Map;

class NetworkSessionV2 {
    /** The list of network requests captured as part of the session. */
    @SerializedName("r")
    private final List<NetworkCallV2> requests;

    /** Counts of network requests per domain, only for domains exeeding the capture limit. */
    @SerializedName("c")
    private final Map<String, DomainCount> requestCounts;

    NetworkSessionV2(List<NetworkCallV2> requests, Map<String, DomainCount> requestCounts) {
        this.requests = requests;
        this.requestCounts = requestCounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NetworkSessionV2 that = (NetworkSessionV2) o;

        if (requests != null ? !requests.equals(that.requests) : that.requests != null)
            return false;
        return requestCounts != null ? requestCounts.equals(that.requestCounts) : that.requestCounts == null;
    }

    @Override
    public int hashCode() {
        int result = requests != null ? requests.hashCode() : 0;
        result = 31 * result + (requestCounts != null ? requestCounts.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "NetworkSessionV2{" +
                "requests=" + requests +
                ", requestCounts=" + requestCounts +
                '}';
    }

    /**
     * Included in the payload when the network request capture limit has been exceeded for a
     * particular domain. Specifies the limit, and the total count.
     */
    static class DomainCount {
        /** The total count of network calls for the given domain. */
        private final int requestCount;

        /** The configured request capture limit for the given domain. */
        private final int captureLimit;

        DomainCount(int requestCount, int captureLimit) {
            this.requestCount = requestCount;
            this.captureLimit = captureLimit;
        }

        public int getRequestCount() {
            return requestCount;
        }

        public int getCaptureLimit() {
            return captureLimit;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainCount that = (DomainCount) o;

            if (requestCount != that.requestCount) return false;
            return captureLimit == that.captureLimit;
        }

        @Override
        public int hashCode() {
            int result = requestCount;
            result = 31 * result + captureLimit;
            return result;
        }

        @Override
        public String toString() {
            return "DomainCount{" +
                    "requestCount=" + requestCount +
                    ", captureLimit=" + captureLimit +
                    '}';
        }
    }
}
