/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.Nullable;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import com.fernandocejas.arrow.strings.Charsets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.AppInfo;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.DeviceInfo;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.NativeCrashData;
import io.embrace.android.embracesdk.NativeSymbols;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.UserInfo;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

class EmbraceNdkService
implements NdkService,
ActivityListener {
    private static final String APPLICATION_STATE_ACTIVE = "active";
    private static final String APPLICATION_STATE_BACKGROUND = "background";
    private static final String CRASH_REPORT_EVENT_NAME = "_crash_report";
    private static final String NATIVE_CRASH_FILE_PREFIX = "emb_ndk";
    private static final String NATIVE_CRASH_FILE_FOLDER = "ndk";
    private static final int MAX_NATIVE_CRASH_FILES_ALLOWED = 4;
    private final Object lock = new Object();
    private static boolean isInstalled = false;
    private final Context context;
    private final MetadataService metadataService;
    private final ApiClient apiClient;
    private final UserService userService;
    private final EmbraceSessionProperties sessionProperties;
    private Gson gson;
    private String unityCrashId;
    private final BackgroundWorker cleanCacheWorker;
    private final BackgroundWorker crashFetchWorker;

    EmbraceNdkService(Context context, MetadataService metadataService, ActivityService activityService, LocalConfig localConfig, ApiClient apiClient, UserService userService, EmbraceSessionProperties sessionProperties, Embrace.AppFramework appFramework) {
        this.context = (Context)Preconditions.checkNotNull((Object)context);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.sessionProperties = (EmbraceSessionProperties)Preconditions.checkNotNull((Object)sessionProperties);
        Preconditions.checkNotNull((Object)((Object)appFramework));
        Preconditions.checkNotNull((Object)activityService);
        Preconditions.checkNotNull((Object)localConfig);
        this.cleanCacheWorker = BackgroundWorker.ofSingleThread("Native Crash Cleaner");
        this.crashFetchWorker = BackgroundWorker.ofSingleThread("Native Crash Fetch");
        if (localConfig.isNdkEnabled().booleanValue()) {
            activityService.addListener(this);
            this.gson = new Gson();
            if (appFramework == Embrace.AppFramework.UNITY) {
                this.unityCrashId = Uuid.getEmbUuid();
            }
            this.startNdk();
            this.cleanOldCrashFiles();
            this.checkForNativeCrash();
        }
    }

    @Override
    public void testCrash(boolean isCpp) {
        if (isCpp) {
            this.testCrashCPP();
        } else {
            this.testCrashC();
        }
    }

    @Override
    public void updateSessionId(String newSessionId) {
        if (isInstalled) {
            this._updateSessionId(newSessionId);
        }
    }

    @Override
    public void onSessionPropertiesUpdate(Map<String, String> properties) {
        if (isInstalled) {
            NativeCrashData.NativeCrashMetadata metadata = this.buildNativeCrashMetadata(this.metadataService.getAppInfo(), this.metadataService.getDeviceInfo(), this.userService.getUserInfo(), this.sessionProperties.get());
            this.updateDeviceMetaData(metadata);
        }
    }

    @Override
    public void onUserInfoUpdate() {
        if (isInstalled) {
            NativeCrashData.NativeCrashMetadata metadata = this.buildNativeCrashMetadata(this.metadataService.getAppInfo(), this.metadataService.getDeviceInfo(), this.userService.getUserInfo(), this.sessionProperties.get());
            this.updateDeviceMetaData(metadata);
        }
    }

    @Override
    @Nullable
    public String getUnityCrashId() {
        return this.unityCrashId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackground() {
        Object object = this.lock;
        synchronized (object) {
            if (isInstalled) {
                this.updateAppState(APPLICATION_STATE_BACKGROUND);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        Object object = this.lock;
        synchronized (object) {
            if (isInstalled) {
                this.updateAppState(APPLICATION_STATE_ACTIVE);
            }
        }
    }

    private void startNdk() {
        try {
            this.loadNDKLibrary();
            this.installSignals();
            this.createCrashReportDirectory();
            EmbraceLogger.logInfo("NDK library successfully loaded");
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to load NDK library", ex);
        }
    }

    private void createCrashReportDirectory() {
        String directory = String.format("%s/%s", this.context.getCacheDir(), NATIVE_CRASH_FILE_FOLDER);
        File directoryFile = new File(directory);
        if (directoryFile.exists()) {
            return;
        }
        if (!directoryFile.mkdirs()) {
            EmbraceLogger.logError("Failed to create crash report directory");
        }
    }

    private void loadNDKLibrary() throws UnsatisfiedLinkError {
        System.loadLibrary("embrace-native");
    }

    private void installSignals() {
        String reportPath = String.format("%s/%s", this.context.getCacheDir().getAbsolutePath(), NATIVE_CRASH_FILE_FOLDER);
        String nativeCrashId = this.unityCrashId != null ? this.unityCrashId : Uuid.getEmbUuid();
        boolean is32bit = Build.VERSION.SDK_INT >= 21 ? !TextUtils.join((CharSequence)", ", (Object[])Build.SUPPORTED_ABIS).contains("64") : true;
        NativeCrashData.NativeCrashMetadata metadata = this.buildNativeCrashMetadata(this.metadataService.getAppInfo(), this.metadataService.getDeviceInfo(), this.userService.getUserInfo(), this.sessionProperties.get());
        this._installSignalHandlers(reportPath, this.gson.toJson((Object)metadata), "null", this.metadataService.getAppState(), nativeCrashId, Build.VERSION.SDK_INT, is32bit);
        isInstalled = true;
    }

    private NativeCrashData.NativeCrashMetadata buildNativeCrashMetadata(AppInfo appInfo, DeviceInfo deviceInfo, UserInfo userInfo, Map<String, String> properties) {
        return new NativeCrashData.NativeCrashMetadata(appInfo, deviceInfo, userInfo, properties);
    }

    private void checkForNativeCrash() {
        this.crashFetchWorker.submit(() -> {
            NativeCrashData nativeCrash = null;
            List<File> matchingFiles = this.sortNativeCrashes(false);
            for (File crashFile : matchingFiles) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(crashFile);
                    Throwable throwable = null;
                    try {
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charsets.UTF_8);
                        Throwable throwable2 = null;
                        try {
                            JsonReader jsonreader = new JsonReader((Reader)inputStreamReader);
                            Throwable throwable3 = null;
                            try {
                                jsonreader.setLenient(true);
                                nativeCrash = (NativeCrashData)new Gson().fromJson(jsonreader, NativeCrashData.class);
                                NativeSymbols nativeSymbols = this.getNativeSymbols();
                                if (nativeSymbols != null) {
                                    String arch = MetadataUtils.getArchitecture();
                                    nativeCrash.setSymbols(nativeSymbols.getSymbolByArchitecture(arch));
                                }
                                this.sendNativeCrash(nativeCrash);
                                if (crashFile.delete()) continue;
                                EmbraceLogger.logWarning("Failed to delete native crash file.");
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (jsonreader == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        jsonreader.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                jsonreader.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (inputStreamReader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputStreamReader.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            inputStreamReader.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    EmbraceLogger.logDebug("Native crash file not found.", ex);
                }
                catch (Exception ex) {
                    crashFile.deleteOnExit();
                    EmbraceLogger.logDebug("Failed to read native crash file " + crashFile.getPath(), ex);
                }
            }
            Embrace.getInstance().getSessionService().handleNativeCrash((Optional<NativeCrashData>)Optional.fromNullable(nativeCrash));
            return null;
        });
    }

    private NativeSymbols getNativeSymbols() {
        Resources resources = this.context.getResources();
        int resourceId = resources.getIdentifier("symbols", "string", this.context.getPackageName());
        if (resourceId != 0) {
            try {
                String encodedSymbols = new String(Base64.decode((String)this.context.getResources().getString(resourceId), (int)0));
                return (NativeSymbols)this.gson.fromJson(encodedSymbols, NativeSymbols.class);
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to decode symbols from resources.", ex);
            }
        } else {
            EmbraceLogger.logError("Failed to find symbols in resources.");
        }
        return null;
    }

    private File[] getNativeCrashFiles() {
        File[] matchingFiles = null;
        for (File cached : this.context.getCacheDir().listFiles()) {
            if (!cached.isDirectory() || !cached.getName().equals(NATIVE_CRASH_FILE_FOLDER)) continue;
            matchingFiles = cached.listFiles(file -> file.getName().startsWith(NATIVE_CRASH_FILE_PREFIX));
            break;
        }
        return matchingFiles;
    }

    private void cleanOldCrashFiles() {
        this.cleanCacheWorker.submit(() -> {
            List<File> sortedFiles = this.sortNativeCrashes(true);
            int deleteCount = sortedFiles.size() - 4;
            if (deleteCount > 0) {
                LinkedList<File> files = new LinkedList<File>(sortedFiles);
                try {
                    for (int i = 0; i < deleteCount; ++i) {
                        File removed = files.get(i);
                        if (!files.get(i).delete()) continue;
                        EmbraceLogger.logDebug(String.format("Native crash file %s removed from cache", removed.getName()));
                    }
                }
                catch (Exception ex) {
                    EmbraceLogger.logError("Failed to delete native crash from cache.", ex);
                }
            }
            return null;
        });
    }

    private List<File> sortNativeCrashes(boolean byOldest) {
        File[] nativeCrashFiles = this.getNativeCrashFiles();
        ArrayList<File> nativeCrashList = new ArrayList<File>();
        if (nativeCrashFiles == null) {
            return nativeCrashList;
        }
        nativeCrashList.addAll(Arrays.asList(nativeCrashFiles));
        HashMap<File, Long> sorted = new HashMap<File, Long>();
        try {
            for (File f : nativeCrashList) {
                sorted.put(f, f.lastModified());
            }
            return (List)StreamSupport.stream(nativeCrashList).sorted((first, next) -> byOldest ? ((Long)sorted.get(first)).compareTo((Long)sorted.get(next)) : ((Long)sorted.get(next)).compareTo((Long)sorted.get(first))).collect(Collectors.toList());
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to sort native crashes to remove oldest.", ex);
            return nativeCrashList;
        }
    }

    private void sendNativeCrash(NativeCrashData nativeCrash) {
        Event.Builder nativeCrashEventBuilder = Event.newBuilder().withName(CRASH_REPORT_EVENT_NAME).withType(EmbraceEvent.Type.CRASH).withSessionId(nativeCrash.getSessionId()).withTimestamp(nativeCrash.getTimestamp()).withAppState(nativeCrash.getAppState()).withSessionProperties(nativeCrash.getMetadata().getSessionProperties());
        EventMessage.Builder nativeCrashMessageEventBuilder = EventMessage.newBuilder().withAppInfo(nativeCrash.getMetadata().getAppInfo()).withDeviceInfo(nativeCrash.getMetadata().getDeviceInfo()).withUserInfo(nativeCrash.getMetadata().getUserInfo()).withNativeCrash(nativeCrash.getCrash()).withEvent(nativeCrashEventBuilder.build());
        try {
            this.apiClient.sendEvent(nativeCrashMessageEventBuilder.build()).get();
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to report native crash to the api", ex);
        }
    }

    private void updateAppState(String newAppState) {
        this._updateAppState(newAppState);
    }

    private void updateDeviceMetaData(NativeCrashData.NativeCrashMetadata newDeviceMetaData) {
        this._updateMetaData(this.gson.toJson((Object)newDeviceMetaData));
    }

    private void uninstallSignals() {
        this._uninstallSignals();
    }

    private void testCrashC() {
        this._testNativeCrash_C();
    }

    private void testCrashCPP() {
        this._testNativeCrash_CPP();
    }

    public native void _installSignalHandlers(String var1, String var2, String var3, String var4, String var5, int var6, boolean var7);

    public native void _updateMetaData(String var1);

    public native void _updateSessionId(String var1);

    public native void _updateAppState(String var1);

    public native void _uninstallSignals();

    public native void _testNativeCrash_C();

    public native void _testNativeCrash_CPP();
}

