/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.ConfigListener;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import java9.util.stream.StreamSupport;

final class EmbraceConfigService
implements ConfigService,
ActivityListener {
    private static final long CONFIG_TTL = 3600000L;
    private static final String CONFIG_FILE_NAME = "config.json";
    private static final long DEFAULT_RETRY_WAIT_TIME = 2L;
    private static final long MAX_ALLOWED_RETRY_WAIT_TIME = 300L;
    private final Set<ConfigListener> listeners = new CopyOnWriteArraySet<ConfigListener>();
    private final BackgroundWorker worker = BackgroundWorker.ofSingleThread("SDK Configuration");
    private final ApiClient apiClient;
    private final CacheService cacheService;
    private final MetadataService metadataService;
    private final Object lock = new Object();
    private volatile Config config = Config.ofDefault();
    private volatile long lastUpdated;
    private volatile long lastRefreshConfigAttempt;
    private volatile double configRetrySafeWindow = 2.0;

    EmbraceConfigService(ApiClient apiClient, EmbraceActivityService activityService, CacheService cacheService, MetadataService metadataService) {
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient, (Object)"apiClient must not be null");
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService, (Object)"cacheService must not be null");
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService, (Object)"metadataService must not be null");
        ((EmbraceActivityService)Preconditions.checkNotNull((Object)activityService)).addListener(this);
        Optional<Config> optionalConfig = cacheService.loadObject(CONFIG_FILE_NAME, Config.class);
        if (optionalConfig.isPresent()) {
            this.config = (Config)optionalConfig.get();
        }
        this.getConfig();
    }

    @Override
    public Config getConfig() {
        if (this.configRequiresRefresh() && this.configRetryIsSafe()) {
            this.refreshConfig();
        }
        return this.config;
    }

    private void refreshConfig() {
        Config previousConfig = this.config;
        this.worker.submit(() -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.configRequiresRefresh() && this.configRetryIsSafe()) {
                    try {
                        this.lastRefreshConfigAttempt = System.currentTimeMillis();
                        this.config = this.apiClient.getConfig().get();
                        this.cacheService.cacheObject(CONFIG_FILE_NAME, this.config, Config.class);
                        this.lastUpdated = System.currentTimeMillis();
                        if (!this.config.equals(previousConfig)) {
                            this.notifyListeners(previousConfig, this.config);
                        }
                        this.configRetrySafeWindow = 2.0;
                    }
                    catch (Exception ex) {
                        this.configRetrySafeWindow = Math.min(300.0, this.configRetrySafeWindow * 2.0);
                        EmbraceLogger.logWarning("Failed to load SDK config from the server. Trying again in " + this.configRetrySafeWindow + " seconds.");
                    }
                }
                return this.config;
            }
        });
    }

    @Override
    public boolean isScreenshotDisabledForEvent(String eventName) {
        return this.doesStringMatchesPatternInSet(eventName, this.config.getDisabledScreenshotPatterns());
    }

    @Override
    public boolean isEventDisabled(String eventName) {
        return this.doesStringMatchesPatternInSet(eventName, this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public boolean isLogMessageDisabled(String logMessage) {
        return this.doesStringMatchesPatternInSet(logMessage, this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public boolean isMessageTypeDisabled(MessageType type) {
        return this.config.getDisabledMessageTypes().contains(type.name().toLowerCase());
    }

    @Override
    public boolean isUrlDisabled(String url) {
        return this.doesStringMatchesPatternInSet(url, this.config.getDisabledUrlPatterns());
    }

    @Override
    public boolean isInternalExceptionCaptureEnabled() {
        return this.config.getInternalExceptionCaptureEnabled();
    }

    @Override
    public boolean isSdkDisabled() {
        int upperBound;
        Config sdkConfig = this.getConfig();
        float result = this.getNormalizedDeviceId();
        int lowerBound = Math.max(0, sdkConfig.getOffset());
        return lowerBound == (upperBound = Math.min(sdkConfig.getOffset() + sdkConfig.getThreshold(), 100)) || result < (float)lowerBound || result > (float)upperBound;
    }

    @Override
    public boolean isAnrCaptureEnabled() {
        return (float)this.getConfig().getAnrUsersEnabledPercentage() >= this.getNormalizedDeviceId();
    }

    @Override
    public void addListener(ConfigListener configListener) {
        this.listeners.add(configListener);
    }

    @Override
    public void removeListener(ConfigListener configListener) {
        this.listeners.remove(configListener);
    }

    @Override
    public boolean isSessionControlEnabled() {
        return this.config.getSessionControl();
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        this.getConfig();
        if (Embrace.getInstance().isStarted() && this.isSdkDisabled()) {
            EmbraceLogger.logInfo("Embrace SDK disabled by config");
            Embrace.getInstance().stop();
        }
    }

    private void notifyListeners(Config previousConfig, Config newConfig) {
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onConfigChange(previousConfig, newConfig);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to notify ConfigListener", ex);
            }
        });
    }

    private boolean doesStringMatchesPatternInSet(String string, Set<String> patternSet) {
        return StreamSupport.stream(patternSet).map(Pattern::compile).anyMatch(p -> p.matcher(string).matches());
    }

    private boolean configRequiresRefresh() {
        return System.currentTimeMillis() - this.lastUpdated > 3600000L;
    }

    private boolean configRetryIsSafe() {
        return (double)System.currentTimeMillis() > (double)this.lastRefreshConfigAttempt + this.configRetrySafeWindow * 1000.0;
    }

    private float getNormalizedDeviceId() {
        String deviceId = this.metadataService.getDeviceId();
        String finalChars = deviceId.substring(deviceId.length() - 2);
        return (float)Integer.valueOf(finalChars, 16).intValue() / 255.0f * 100.0f;
    }

    @Override
    public void close() {
        EmbraceLogger.logDebug("Shutting down EmbraceConfigService");
        this.worker.close();
    }
}

