package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.HashMap;
import java.util.Map;

class NativeSymbols {

    private static final String ARM_ABI_V7_NAME = "armeabi-v7a";
    private static final String ARM_64_NAME = "arm64-v8a";
    private static final String ARCH_X86_NAME = "x86";
    private static final String ARCH_X86_64_NAME = "x86_64";

    @SerializedName("symbols")
    private Map<String, Map<String, String>> symbols;

    NativeSymbols(Map<String, Map<String, String>> symbols) {
        this.symbols = symbols;
    }

    Map<String, String> getSymbolByArchitecture(String arch) {
        Map<String, String> symbols = new HashMap<>();

        if (arch == null) {
            return symbols;
        }

        if (this.symbols.containsKey(arch)) {
            symbols = this.symbols.get(arch);
        } else if (arch.equals(ARM_64_NAME)) {
            // Uses arm-v7 symbols for arm64 if no symbols for amr64 found.
            symbols = this.symbols.get(ARM_ABI_V7_NAME);
        } else if(arch.equals(ARCH_X86_64_NAME)){
            // Uncommon 64 bits arch, uses x86 symbols for x86-64 if no symbols for x86-64 found.
            symbols = this.symbols.get(ARCH_X86_NAME);
        }

        return symbols;
    }
}
