package io.embrace.android.embracesdk;

/**
 * Service for taking a screenshot of the app for a slow moment or a particular log event.
 */
interface ScreenshotService {
    /**
     * Take a screenshot which is associated with a particular event in the logs.
     *
     * @param logId the ID of the event
     * @return whether the screenshot was successfully taken or not
     */
    boolean takeScreenshotLogEvent(String logId);

    /**
     * Take a screenshot which is associated with a particular event in the logs.
     *
     * @param eventId the ID of the event
     * @return whether the screenshot was successfully taken or not
     */
    boolean takeScreenshotMoment(String eventId);
}
