/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Parcelable;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

final class PropertyUtils {
    static final int MAX_PROPERTY_SIZE = 10;

    static Map<String, Object> sanitizeProperties(Map<String, Object> properties) {
        if (properties.size() > 10) {
            EmbraceLogger.logWarning("The maximum number of properties is 10, the rest will be ignored.");
        }
        return (Map)StreamSupport.stream(properties.entrySet()).filter(entry -> entry.getKey() != null).limit(10L).map(PropertyUtils::mapNullValue).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map.Entry<String, Object> mapNullValue(Map.Entry<String, Object> entry) {
        return new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), PropertyUtils.checkIfSerializable(entry.getKey(), entry.getValue()));
    }

    private static Object checkIfSerializable(String key, Object value) {
        if (value == null) {
            return "null";
        }
        if (!(value instanceof Parcelable) && !(value instanceof Serializable)) {
            EmbraceLogger.logWarning(String.format("The property with key %s has an entry that cannot be serialized. It will be ignored.", key));
            return "not serializable";
        }
        return value;
    }

    private PropertyUtils() {
    }
}

