package io.embrace.android.embracesdk;

/**
 * Notifies listeners on changes in the {@link ConfigService}.
 */
interface ConfigListener {
    /**
     * Called when {@link Config} has been refreshed.
     *
     * @param previousConfig the previous configuration
     * @param newConfig the new configuration
     */
    void onConfigChange(Config previousConfig, Config newConfig);
}
